/*
 * Decompiled with CFR 0.152.
 */
package me.lucaspickering.utils;

import net.runelite.client.game.ItemManager;

public enum Compost {
    NONE("None", 0.0, -1, 27.0),
    NORMAL("Compost", 18.0, 6032, 14.0),
    SUPERCOMPOST("Supercompost", 26.0, 6034, 6.0),
    ULTRACOMPOST("Ultracompost", 36.0, 21483, 3.0);

    private final String name;
    private final double xp;
    private final int item;
    private final double baseDiseaseChance;

    public int getPrice(ItemManager itemManager) {
        if (this.item >= 0) {
            return itemManager.getItemPrice(this.item);
        }
        return 0;
    }

    public int getHarvestLives() {
        switch (this) {
            case NONE: {
                return 3;
            }
            case NORMAL: {
                return 4;
            }
            case SUPERCOMPOST: {
                return 5;
            }
            case ULTRACOMPOST: {
                return 6;
            }
        }
        return 3;
    }

    private Compost(String name, double xp, int item, double baseDiseaseChance) {
        this.name = name;
        this.xp = xp;
        this.item = item;
        this.baseDiseaseChance = baseDiseaseChance;
    }

    public String getName() {
        return this.name;
    }

    public double getXp() {
        return this.xp;
    }

    public int getItem() {
        return this.item;
    }

    public double getBaseDiseaseChance() {
        return this.baseDiseaseChance;
    }
}

