/*
 * Decompiled with CFR 0.152.
 */
package me.lucaspickering;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import me.lucaspickering.HerbFarmCalculator;
import me.lucaspickering.HerbFarmCalculatorConfig;
import me.lucaspickering.HerbFarmCalculatorPanel;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Herb Farming Calculator", tags={"panel", "herb", "farming", "calculator"})
public class HerbFarmCalculatorPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    ClientThread clientThread;
    @Inject
    private HerbFarmCalculatorConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton uiNavigationButton;
    private HerbFarmCalculatorPanel uiPanel;
    private boolean refreshCalculator = false;

    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"herb.png");
        HerbFarmCalculator calculator = new HerbFarmCalculator(this.client, this.config, this.itemManager);
        this.uiPanel = new HerbFarmCalculatorPanel(this.client, this.clientThread, this.itemManager, this.config, calculator);
        this.uiNavigationButton = NavigationButton.builder().tooltip("Herb Farming Calculator").icon(icon).priority(9).panel((PluginPanel)this.uiPanel).build();
        this.clientToolbar.addNavigation(this.uiNavigationButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.refreshCalculator = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.refreshCalculator) {
            this.refreshCalculator = false;
            this.uiPanel.refreshPanel();
        }
    }

    @Provides
    HerbFarmCalculatorConfig provideConfig(ConfigManager configManager) {
        return (HerbFarmCalculatorConfig)configManager.getConfig(HerbFarmCalculatorConfig.class);
    }
}

