/*
 * Decompiled with CFR 0.152.
 */
package me.lucaspickering;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.StringJoiner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import me.lucaspickering.HerbFarmCalculator;
import me.lucaspickering.HerbFarmCalculatorConfig;
import me.lucaspickering.UIHerbSlot;
import me.lucaspickering.utils.HerbCalculatorResult;
import me.lucaspickering.utils.HerbPatchBuffs;
import me.lucaspickering.utils.HerbResult;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HerbFarmCalculatorPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(HerbFarmCalculatorPanel.class);
    private static final DecimalFormat PCT_FORMAT = new DecimalFormat("+0%");
    private final Client client;
    private final ClientThread clientThread;
    private final ItemManager itemManager;
    private final HerbFarmCalculator calculator;
    private JPanel uiPanel;

    public HerbFarmCalculatorPanel(Client client, ClientThread clientThread, ItemManager itemManager, HerbFarmCalculatorConfig config, HerbFarmCalculator calculator) {
        this.client = client;
        this.clientThread = clientThread;
        this.itemManager = itemManager;
        this.calculator = calculator;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
    }

    public void onActivate() {
        super.onActivate();
        this.refreshPanel();
    }

    public void refreshPanel() {
        this.clientThread.invokeLater(() -> {
            HerbCalculatorResult result = this.calculator.calculate();
            SwingUtilities.invokeLater(() -> this.renderResult(result));
        });
    }

    private void renderResult(HerbCalculatorResult result) {
        log.debug("Rendering calculator result");
        if (this.uiPanel != null) {
            this.remove(this.uiPanel);
        }
        this.uiPanel = new JPanel();
        this.uiPanel.setLayout(new BoxLayout(this.uiPanel, 1));
        this.add(this.uiPanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        infoPanel.setLayout(new GridLayout(0, 1));
        infoPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.uiPanel.add(infoPanel);
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JLabel notLoggedInWarning = new JLabel("Log in for more accurate results");
            notLoggedInWarning.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            infoPanel.add(notLoggedInWarning);
        }
        JLabel farmingLevelLabel = new JLabel(String.format("Farming level: %d", result.getFarmingLevel()));
        farmingLevelLabel.setForeground(Color.WHITE);
        infoPanel.add(farmingLevelLabel);
        for (HerbPatchBuffs patch : result.getPatches()) {
            StringBuilder text = new StringBuilder(patch.getPatch().getName());
            StringJoiner buffLabels = new StringJoiner(", ");
            if (patch.isDiseaseFree()) {
                buffLabels.add("disease-free");
            }
            if (patch.getYieldBonus() != 0.0) {
                buffLabels.add(PCT_FORMAT.format(patch.getYieldBonus()) + " yield");
            }
            if (patch.getXpBonus() != 0.0) {
                buffLabels.add(PCT_FORMAT.format(patch.getXpBonus()) + " XP");
            }
            if (buffLabels.length() > 0) {
                text.append(" (");
                text.append(buffLabels);
                text.append(")");
            }
            JLabel patchLabel = new JLabel(text.toString());
            patchLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            patchLabel.setFont(FontManager.getRunescapeSmallFont());
            infoPanel.add(patchLabel);
        }
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BoxLayout(resultsPanel, 1));
        this.uiPanel.add(resultsPanel);
        for (HerbResult herbResult : result.getHerbs()) {
            UIHerbSlot slot = new UIHerbSlot(result.getFarmingLevel(), this.itemManager, herbResult);
            resultsPanel.add(slot);
        }
        this.revalidate();
        this.repaint();
    }
}

