/*
 * Decompiled with CFR 0.152.
 */
package me.lucaspickering;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.lucaspickering.HerbFarmCalculatorConfig;
import me.lucaspickering.utils.Herb;
import me.lucaspickering.utils.HerbCalculatorResult;
import me.lucaspickering.utils.HerbPatch;
import me.lucaspickering.utils.HerbPatchBuffs;
import me.lucaspickering.utils.HerbPatchResult;
import me.lucaspickering.utils.HerbResult;
import me.lucaspickering.utils.SurvivalChance;
import me.lucaspickering.utils.Utils;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.skillcalculator.skills.MagicAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HerbFarmCalculator {
    private static final Logger log = LoggerFactory.getLogger(HerbFarmCalculator.class);
    private final Client client;
    private final HerbFarmCalculatorConfig config;
    private final ItemManager itemManager;

    public HerbFarmCalculator(Client client, HerbFarmCalculatorConfig config, ItemManager itemManager) {
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
    }

    public HerbCalculatorResult calculate() {
        log.debug("Running herb calculator");
        List<HerbPatchBuffs> patches = this.config.patches().stream().map(patch -> new HerbPatchBuffs((HerbPatch)((Object)patch), patch.isDiseaseFree(this.client), this.getDiaryChanceToSaveBonus((HerbPatch)((Object)patch)), this.getXpBonus((HerbPatch)((Object)patch)))).sorted(Comparator.comparing(patch -> patch.getPatch().getName())).collect(Collectors.toList());
        List<HerbResult> herbs = Arrays.stream(Herb.values()).map(herb -> this.calculateHerb((Herb)((Object)herb), patches)).collect(Collectors.toList());
        return new HerbCalculatorResult(this.getFarmingLevel(), patches, herbs);
    }

    private HerbResult calculateHerb(Herb herb, List<HerbPatchBuffs> patches) {
        List<HerbPatchResult> patchResults = patches.stream().map(patch -> this.calculatePatch(herb, (HerbPatchBuffs)patch)).collect(Collectors.toList());
        HerbResult rv = new HerbResult(herb, patchResults);
        log.debug("{}", (Object)rv);
        return rv;
    }

    private HerbPatchResult calculatePatch(Herb herb, HerbPatchBuffs patch) {
        SurvivalChance survivalChance = this.calcSurvivalChance(patch);
        double expectedYield = this.calcExpectedYield(herb, patch) * survivalChance.getSurvivalChance();
        double baseXp = this.config.compost().getXp() + herb.getPlantXp() * survivalChance.getSurvivalChance() + herb.getHarvestXp() * expectedYield;
        double expectedXp = baseXp * (1.0 + patch.getXpBonus());
        double compostCost = (double)this.config.compost().getPrice(this.itemManager) * (this.config.useBottomlessBucket() ? 0.5 : 1.0);
        double seedCost = this.itemManager.getItemPrice(herb.getSeedItem());
        double runeCost = (double)this.getResurrectRuneCost() * survivalChance.getResurrectionCastChance();
        double cost = compostCost + seedCost + runeCost;
        double revenue = (double)this.itemManager.getItemPrice(herb.getGrimyHerbItem()) * expectedYield;
        return new HerbPatchResult(herb, patch.getPatch(), survivalChance.getSurvivalChance(), expectedYield, expectedXp, cost, revenue);
    }

    private double calcExpectedYield(Herb herb, HerbPatchBuffs patch) {
        return (double)this.config.compost().getHarvestLives() / (1.0 - this.calcChanceToSave(herb, patch));
    }

    private double calcChanceToSave(Herb herb, HerbPatchBuffs patch) {
        int farmingLevel = this.getFarmingLevel();
        double itemBonus = this.getItemChanceToSaveBonus();
        double attasBonus = this.config.animaPlant().getChanceToSaveBonus();
        double chance1 = herb.getMinChanceToSave();
        double chance99 = 80.0;
        return Math.floor(Math.floor(Math.floor(chance1 * (99.0 - (double)farmingLevel) / 98.0 + chance99 * ((double)farmingLevel - 1.0) / 98.0) * (1.0 + itemBonus) * (1.0 + patch.getYieldBonus()) * (1.0 + attasBonus) + 1.0)) / 256.0;
    }

    private SurvivalChance calcSurvivalChance(HerbPatchBuffs patch) {
        if (patch.isDiseaseFree()) {
            return new SurvivalChance(1.0, 0.0);
        }
        double baseChance = this.config.compost().getBaseDiseaseChance();
        double modifier = this.config.animaPlant().getDiseaseChanceModifier();
        double numerator = Math.max(Math.floor(baseChance * modifier), 1.0);
        double diseaseChancePerCycle = numerator / 128.0;
        double survivalChancePerCycle = 1.0 - diseaseChancePerCycle;
        double naturalSurvivalChance = Math.pow(survivalChancePerCycle, 3.0);
        if (this.config.useResurrectCrops()) {
            double resurrectToAdulthoodChance = 3.0 * Math.pow(survivalChancePerCycle, 3.0) * diseaseChancePerCycle * this.getResurrectionChance();
            double resurrectCastChance = 1.0 - naturalSurvivalChance;
            return new SurvivalChance(naturalSurvivalChance + resurrectToAdulthoodChance, resurrectCastChance);
        }
        return new SurvivalChance(naturalSurvivalChance, 0.0);
    }

    private int getResurrectRuneCost() {
        return this.itemManager.getItemPrice(566) * 8 + this.itemManager.getItemPrice(561) * 12 + this.itemManager.getItemPrice(565) * 8 + this.itemManager.getItemPrice(557) * 25;
    }

    private double getResurrectionChance() {
        int minLevel;
        int magicLevel = this.client.getRealSkillLevel(Skill.MAGIC);
        if (magicLevel < (minLevel = MagicAction.RESURRECT_CROPS.getLevel())) {
            return 0.0;
        }
        return Utils.mapToRange(magicLevel, minLevel, 99.0, 0.5, 0.75);
    }

    private int getFarmingLevel() {
        return this.client.getRealSkillLevel(Skill.FARMING);
    }

    private double getItemChanceToSaveBonus() {
        double bonus = 0.0;
        if (this.config.useMagicSecateurs()) {
            bonus += 0.1;
        }
        if (this.config.useFarmingCape()) {
            bonus += 0.05;
        }
        return bonus;
    }

    private double getDiaryChanceToSaveBonus(HerbPatch patch) {
        switch (patch) {
            case CATHERBY: {
                if (this.client.getVarbitValue(4478) > 0) {
                    return 0.15;
                }
                if (this.client.getVarbitValue(4477) > 0) {
                    return 0.1;
                }
                if (this.client.getVarbitValue(4476) > 0) {
                    return 0.05;
                }
                return 0.0;
            }
            case FARMING_GUILD: 
            case HOSIDIUS: {
                if (this.client.getVarbitValue(7927) > 0) {
                    return 0.05;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private double getXpBonus(HerbPatch patch) {
        switch (patch) {
            case FALADOR: {
                if (this.client.getVarbitValue(4463) > 0) {
                    return 0.1;
                }
                return 0.0;
            }
        }
        return 0.0;
    }
}

