/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.common.net;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Server;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SAuth;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SMicPacket;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SUpdatePacket;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CAuthReq;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CKillDecoder;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CMicPacket;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CUpdateReq;
import com.thatgamerblue.osrs.proxchat.common.serializers.ByteArySerializer;
import com.thatgamerblue.osrs.proxchat.common.serializers.UUIDSerializer;
import java.io.IOException;
import java.util.UUID;

public abstract class NetworkHandler {
    protected Client netClient;
    protected Server netServer;
    protected final Mode networkMode;

    protected NetworkHandler(Mode mode) {
        this.networkMode = mode;
    }

    public void initKryonet() {
        EndPoint endPoint;
        Kryo kryo;
        switch (this.networkMode) {
            case CLIENT: {
                this.netClient = new Client(16384, 16384);
                kryo = this.netClient.getKryo();
                break;
            }
            case SERVER: {
                this.netServer = new Server(16384, 16384);
                kryo = this.netServer.getKryo();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.networkMode);
            }
        }
        kryo.register(byte[].class, new ByteArySerializer());
        kryo.register(UUID.class, new UUIDSerializer());
        kryo.register(C2SAuth.class, new C2SAuth.Serializer());
        kryo.register(C2SMicPacket.class, new C2SMicPacket.Serializer());
        kryo.register(C2SUpdatePacket.class, new C2SUpdatePacket.Serializer());
        kryo.register(S2CAuthReq.class, new S2CAuthReq.Serializer());
        kryo.register(S2CKillDecoder.class, new S2CKillDecoder.Serializer());
        kryo.register(S2CMicPacket.class, new S2CMicPacket.Serializer());
        kryo.register(S2CUpdateReq.class, new S2CUpdateReq.Serializer());
        switch (this.networkMode) {
            case CLIENT: {
                endPoint = this.netClient;
                break;
            }
            case SERVER: {
                endPoint = this.netServer;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.networkMode);
            }
        }
        endPoint.addListener(new Listener(){

            @Override
            public void connected(Connection connection) {
                NetworkHandler.this.onConnected(connection);
            }

            @Override
            public void disconnected(Connection connection) {
                NetworkHandler.this.onDisconnected(connection);
            }

            @Override
            public void received(Connection connection, Object o) {
                NetworkHandler.this.onMessageReceived(connection, o);
            }
        });
    }

    public abstract void connect() throws IOException;

    protected abstract void onConnected(Connection var1);

    protected abstract void onMessageReceived(Connection var1, Object var2);

    protected abstract void onDisconnected(Connection var1);

    public abstract void disconnect() throws IOException;

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

