/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client.net;

import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.google.common.hash.Hashing;
import com.thatgamerblue.osrs.proxchat.client.ProxChatClientPlugin;
import com.thatgamerblue.osrs.proxchat.client.audio.SpeakerThread;
import com.thatgamerblue.osrs.proxchat.common.net.NetworkHandler;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SAuth;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SMicPacket;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SUpdatePacket;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CAuthReq;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CKillDecoder;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CMicPacket;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CUpdateReq;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNetworkHandler
extends NetworkHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientNetworkHandler.class);
    private final ProxChatClientPlugin plugin;
    private final Client client;
    private final Supplier<String> connectionAddress;
    private final Supplier<Integer> port;
    private final Supplier<String> password;
    private final Supplier<Boolean> enabled;
    private final Supplier<String> room;
    private final ConcurrentHashMap<UUID, SpeakerThread> speakers = new ConcurrentHashMap();
    private final AtomicBoolean speakerMuted = new AtomicBoolean(false);
    private final AtomicBoolean micTransmitting = new AtomicBoolean(false);
    private final AtomicBoolean reconnect = new AtomicBoolean(false);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private C2SUpdatePacket lastState = null;
    private static final int BACKOFF_TIMER_MAX = 240;
    private static final int BACKOFF_TIMER_MIN = 30;
    private int backoffTimer = 30;
    private ScheduledFuture<?> connectionFuture;

    public ClientNetworkHandler(ProxChatClientPlugin plugin, Client client, Supplier<String> connectionAddress, Supplier<Integer> port, Supplier<String> password, Supplier<Boolean> enabled, Supplier<String> room) {
        super(NetworkHandler.Mode.CLIENT);
        this.plugin = plugin;
        this.client = client;
        this.connectionAddress = connectionAddress;
        this.port = port;
        this.password = password;
        this.enabled = enabled;
        this.room = room;
    }

    @Override
    public void connect() {
        if (this.connecting.get()) {
            return;
        }
        this.backoffTimer = 30;
        this.connecting.set(true);
        this.doConnect();
    }

    private void doConnect() {
        block3: {
            if (this.connectionAddress.get().equals("<disabled>") || !this.enabled.get().booleanValue()) {
                this.connecting.set(false);
                return;
            }
            try {
                this.netClient.start();
                this.netClient.connect(5000, this.connectionAddress.get(), (int)this.port.get());
                this.connecting.set(false);
                log.info("Connected to voice server");
            }
            catch (IOException ex) {
                log.error("Failed to connect to the server, retrying in " + this.backoffTimer + " seconds.", (Throwable)ex);
                this.connectionFuture = this.plugin.getExecutor().schedule(this::doConnect, (long)this.backoffTimer, TimeUnit.SECONDS);
                this.backoffTimer *= 2;
                if (this.backoffTimer <= 240) break block3;
                this.backoffTimer = 240;
            }
        }
    }

    @Override
    protected void onConnected(Connection connection) {
    }

    @Override
    protected void onMessageReceived(Connection connection, Object message) {
        if (!(message instanceof FrameworkMessage) && !(message instanceof S2CMicPacket)) {
            log.info("Recv message: {}", message);
        }
        if (message instanceof S2CAuthReq) {
            Random rand = new Random(((S2CAuthReq)message).replay);
            byte[] pw = this.password.get().getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < pw.length; ++i) {
                pw[i] = (byte)(pw[i] ^ rand.nextInt());
            }
            byte[] fin = Hashing.sha256().hashBytes(pw).asBytes();
            this.sendTCP(new C2SAuth(fin));
        } else if (message instanceof S2CUpdateReq) {
            this.sendUpdate(this.client.getGameState().getState());
        } else if (message instanceof S2CKillDecoder) {
            UUID uuid = ((S2CKillDecoder)message).uuid;
            SpeakerThread speaker = this.speakers.get(uuid);
            if (speaker != null) {
                speaker.destroy();
                this.speakers.remove(uuid);
            }
        } else if (message instanceof S2CMicPacket) {
            S2CMicPacket micPacket = (S2CMicPacket)message;
            if (micPacket.distance < 0 || micPacket.distance > 1920) {
                return;
            }
            if (this.speakerMuted.get()) {
                return;
            }
            UUID decoderId = micPacket.decoder;
            SpeakerThread speaker = this.speakers.get(decoderId);
            if (speaker == null) {
                speaker = new SpeakerThread(decoderId, () -> this.plugin.getConfig().speakerVolume(), () -> ((Client)this.client).getGameState());
                this.speakers.put(decoderId, speaker);
                speaker.start();
            }
            speaker.push(micPacket);
        }
    }

    public boolean isConnected() {
        return this.netClient.isConnected();
    }

    public void sendTCP(Object object) {
        if (object instanceof C2SMicPacket) {
            this.micTransmitting.set(true);
        }
        this.netClient.sendTCP(object);
    }

    @Override
    protected void onDisconnected(Connection connection) {
        if (!this.reconnect.get()) {
            return;
        }
        this.connect();
    }

    public void sendUpdate(int gameState) {
        int world;
        int plane;
        int y;
        int x;
        if (this.client.getLocalPlayer() != null) {
            LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
            int lX = lp.getX();
            int lY = lp.getY();
            x = lX + this.client.getBaseX() * 128;
            y = lY + this.client.getBaseY() * 128;
            plane = this.client.getPlane();
            world = this.client.getWorld();
        } else {
            world = -1;
            plane = -1;
            y = -1;
            x = -1;
        }
        if (!this.netClient.isConnected()) {
            return;
        }
        C2SUpdatePacket packet = new C2SUpdatePacket(x, y, plane, world, gameState, this.room.get());
        if (packet.equals(this.lastState)) {
            return;
        }
        this.lastState = packet;
        this.sendTCP(packet);
    }

    @Override
    public void disconnect() {
        this.reconnect.set(false);
        this.netClient.stop();
        this.speakers.forEach((u, s) -> s.destroy());
        this.speakers.clear();
    }

    public void cancelConnecting() {
        if (this.connectionFuture != null) {
            this.connectionFuture.cancel(false);
        }
        this.connecting.set(false);
    }

    public void toggleSpeakerMute() {
        boolean v;
        while (!this.speakerMuted.compareAndSet(v, !(v = this.speakerMuted.get()))) {
        }
    }

    public boolean isConnecting() {
        return this.connecting.get();
    }

    public AtomicBoolean getSpeakerMuted() {
        return this.speakerMuted;
    }

    public AtomicBoolean getMicTransmitting() {
        return this.micTransmitting;
    }
}

