/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client.audio;

import com.thatgamerblue.osrs.proxchat.client.audio.AudioUtil;
import com.thatgamerblue.osrs.proxchat.common.audio.AudioConstants;
import com.thatgamerblue.osrs.proxchat.common.net.messages.s2c.S2CMicPacket;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.runelite.api.GameState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeakerThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(SpeakerThread.class);
    private final ArrayBlockingQueue<S2CMicPacket> soundQueue = new ArrayBlockingQueue(50);
    private final SourceDataLine speaker;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Supplier<Integer> volume;
    private final Supplier<GameState> gameState;

    public SpeakerThread(UUID uuid, Supplier<Integer> volume, Supplier<GameState> gameState) {
        SourceDataLine __speaker;
        this.volume = volume;
        this.gameState = gameState;
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, null);
            __speaker = (SourceDataLine)AudioSystem.getLine(info);
        }
        catch (LineUnavailableException e) {
            log.error("Failed to initialize speaker", (Throwable)e);
            __speaker = null;
        }
        this.speaker = __speaker;
        this.setDaemon(true);
        this.setName("Prox-SpeakerThread-" + uuid.toString());
    }

    @Override
    public void run() {
        try {
            this.speaker.open(AudioConstants.STEREO_FORMAT);
        }
        catch (LineUnavailableException e) {
            log.error("Failed to initialize speaker", (Throwable)e);
            this.speaker.close();
            return;
        }
        FloatControl gainControl = (FloatControl)this.speaker.getControl(FloatControl.Type.MASTER_GAIN);
        while (this.running.get()) {
            GameState gs;
            S2CMicPacket packet;
            if (this.speaker.getBufferSize() - this.speaker.available() <= 0 && this.speaker.isActive()) {
                this.speaker.stop();
            }
            try {
                packet = this.soundQueue.poll(5L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                continue;
            }
            if (packet == null || (gs = this.gameState.get()).getState() > GameState.LOGGED_IN.getState() || gs.getState() < GameState.LOADING.getState()) continue;
            if (this.speaker.getBufferSize() - this.speaker.available() <= 0) {
                byte[] data = new byte[Math.min(3840, this.speaker.getBufferSize() - 960)];
                this.speaker.write(data, 0, data.length);
            }
            float volumeScale = this.scaleAudio(packet.distance);
            float volumeDb = (float)(10.0 * Math.log(volumeScale)) * ((float)this.volume.get().intValue() / 50.0f);
            gainControl.setValue(Math.min(Math.max(volumeDb, gainControl.getMinimum()), gainControl.getMaximum()));
            byte[] decoded = packet.data;
            byte[] stereo = AudioUtil.convertToStereo(decoded);
            this.speaker.write(stereo, 0, stereo.length);
            this.speaker.start();
        }
        this.speaker.stop();
        this.speaker.close();
        this.soundQueue.clear();
    }

    private float scaleAudio(int distance) {
        float minDist = 640.0f;
        float maxDist = 1920.0f;
        float diff = maxDist - minDist;
        float val = 1.0f - (((float)distance - minDist) * 0.99f / diff + 0.01f);
        return Math.max(0.0f, Math.min(val, 1.0f));
    }

    public void destroy() {
        this.running.set(false);
    }

    public void push(S2CMicPacket micPacket) {
        try {
            this.soundQueue.offer(micPacket, 25L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

