/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client.audio;

import com.thatgamerblue.osrs.proxchat.client.audio.AudioMode;
import com.thatgamerblue.osrs.proxchat.client.audio.AudioUtil;
import com.thatgamerblue.osrs.proxchat.client.net.ClientNetworkHandler;
import com.thatgamerblue.osrs.proxchat.common.audio.AudioConstants;
import com.thatgamerblue.osrs.proxchat.common.net.messages.c2s.C2SMicPacket;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.runelite.api.GameState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MicThread.class);
    private static final int MIC_HOLDON_TIME_DELAY = 120;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicBoolean pttDown = new AtomicBoolean(false);
    private final AtomicBoolean toggleMute = new AtomicBoolean(false);
    private final ClientNetworkHandler networkHandler;
    private final Supplier<Integer> amplificationSupplier;
    private final Supplier<Integer> thresholdSupplier;
    private final Supplier<AudioMode> audioModeSupplier;
    private final Supplier<GameState> gameStateSupplier;
    private final TargetDataLine mic;
    private long micHoldOnTime = -1L;

    public MicThread(ClientNetworkHandler network, Supplier<Integer> amplificationSupplier, Supplier<Integer> thresholdSupplier, Supplier<AudioMode> audioModeSupplier, Supplier<GameState> gameStateSupplier) {
        TargetDataLine __mic;
        this.networkHandler = network;
        this.amplificationSupplier = amplificationSupplier;
        this.thresholdSupplier = thresholdSupplier;
        this.audioModeSupplier = audioModeSupplier;
        this.gameStateSupplier = gameStateSupplier;
        try {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, null);
            __mic = (TargetDataLine)AudioSystem.getLine(info);
            __mic.open(AudioConstants.MONO_FORMAT);
        }
        catch (LineUnavailableException e) {
            log.error("Failed to initialize microphone", (Throwable)e);
            __mic = null;
        }
        this.mic = __mic;
        this.setDaemon(true);
        this.setName("Prox-MicThread");
    }

    @Override
    public void run() {
        if (this.mic == null) {
            throw new RuntimeException("Microphone uninitialized.");
        }
        byte[] inBuf = new byte[960];
        block4: while (this.running.get()) {
            if (this.toggleMute.get()) {
                this.sleep(1);
                continue;
            }
            if (!this.networkHandler.isConnected()) {
                this.sleep(1);
                continue;
            }
            GameState currentState = this.gameStateSupplier.get();
            if (currentState != GameState.LOADING && currentState != GameState.LOGGED_IN) {
                this.sleep(1);
                continue;
            }
            this.mic.start();
            int avail = this.mic.available();
            if (avail < 960) {
                this.sleep(1);
                continue;
            }
            Arrays.fill(inBuf, (byte)0);
            this.mic.read(inBuf, 0, inBuf.length);
            AudioUtil.amplify(inBuf, (float)this.amplificationSupplier.get().intValue() / 25.0f);
            switch (this.audioModeSupplier.get()) {
                case PUSH_TO_TALK: {
                    if (!this.pttDown.get()) break;
                    this.micHoldOnTime = System.currentTimeMillis() + 120L;
                    this.networkHandler.sendTCP(new C2SMicPacket(inBuf));
                    continue block4;
                }
                case VOICE_ACTIVITY: {
                    double highestLvl = AudioUtil.calculateAudioLevel(inBuf);
                    if (!(highestLvl > (double)this.thresholdSupplier.get().intValue())) break;
                    this.micHoldOnTime = System.currentTimeMillis() + 120L;
                    this.networkHandler.sendTCP(new C2SMicPacket(inBuf));
                    continue block4;
                }
            }
            if (this.micHoldOnTime > System.currentTimeMillis()) {
                this.networkHandler.sendTCP(new C2SMicPacket(inBuf));
                continue;
            }
            this.networkHandler.getMicTransmitting().set(false);
        }
        log.info("MicThread stopping...");
        this.mic.stop();
        this.mic.close();
    }

    public void end() {
        this.running.set(false);
    }

    public void setPttDown(boolean ptt) {
        this.pttDown.set(ptt);
    }

    public void toggleMute() {
        boolean v;
        while (!this.toggleMute.compareAndSet(v, !(v = this.toggleMute.get()))) {
        }
    }

    public boolean isToggleMute() {
        return this.toggleMute.get();
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

