/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client.audio;

public class AudioUtil {
    public static short bytesToShort(byte b1, byte b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static byte[] shortsToBytes(short[] sIn) {
        byte[] bAry = new byte[sIn.length * 2];
        AudioUtil.shortsToBytes(sIn, bAry);
        return bAry;
    }

    public static void shortsToBytes(short[] sIn, byte[] bOut) {
        for (int i = 0; i < sIn.length; ++i) {
            byte[] bytes = AudioUtil.shortToBytes(sIn[i]);
            bOut[i * 2] = bytes[0];
            bOut[i * 2 + 1] = bytes[1];
        }
    }

    public static short[] bytesToShorts(byte[] bIn) {
        short[] sOut = new short[bIn.length / 2];
        AudioUtil.bytesToShorts(bIn, sOut);
        return sOut;
    }

    public static void bytesToShorts(byte[] bIn, short[] sOut) {
        int j = 0;
        for (int i = 0; i < bIn.length; i += 2) {
            short s = AudioUtil.bytesToShort(bIn[i], bIn[i + 1]);
            sOut[j++] = s;
        }
    }

    public static byte[] shortToBytes(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public static void amplify(byte[] buf, float scale) {
        for (int i = 0; i < buf.length; i += 2) {
            float fSample = AudioUtil.bytesToShort(buf[i], buf[i + 1]);
            short sSample = (short)(fSample *= scale);
            buf[i] = (byte)sSample;
            buf[i + 1] = (byte)(sSample >> 8);
        }
    }

    public static byte[] convertToStereo(byte[] mono) {
        byte[] stereo = new byte[mono.length * 2];
        for (int i = 0; i < mono.length; i += 2) {
            stereo[i * 2] = mono[i];
            stereo[i * 2 + 1] = mono[i + 1];
            stereo[i * 2 + 2] = mono[i];
            stereo[i * 2 + 3] = mono[i + 1];
        }
        return stereo;
    }

    public static double calculateAudioLevel(byte[] samples) {
        double rms = 0.0;
        for (int i = 0; i < samples.length; i += 2) {
            double sample = (double)AudioUtil.bytesToShort(samples[i], samples[i + 1]) / 32767.0;
            rms += sample * sample;
        }
        int sampleCount = samples.length / 2;
        rms = sampleCount == 0 ? 0.0 : Math.sqrt(rms / (double)sampleCount);
        double db = rms > 0.0 ? Math.min(Math.max(20.0 * Math.log10(rms), -127.0), 0.0) : -127.0;
        return db;
    }
}

