/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client;

import com.esotericsoftware.minlog.Log;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.thatgamerblue.osrs.proxchat.client.ProxChatClientConfig;
import com.thatgamerblue.osrs.proxchat.client.ProxChatClientOverlay;
import com.thatgamerblue.osrs.proxchat.client.ProxKeyHandler;
import com.thatgamerblue.osrs.proxchat.client.audio.MicThread;
import com.thatgamerblue.osrs.proxchat.client.net.ClientNetworkHandler;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Proximity Chat")
public class ProxChatClientPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ProxChatClientPlugin.class);
    private static final String ICON_LICENSE = "Icons from iconfinder.com (Benjamin STAWARZ)\r\nAll licensed under CC Abbrib. 3.0 Unported:\r\nhttps://creativecommons.org/licenses/by/3.0/\r\nDisconnected: iconfinder.com/icons/6137632\r\nOutput Muted: iconfinder.com/icons/6138050\r\nMic Muted: iconfinder.com/icons/6138089\r\nMic Active: iconfinder.com/icons/6138088\r\nModified by ThatGamerBlue, filled in icons";
    private static final Set<String> RECONNECT_CONFIGS = ImmutableSet.of((Object)"address", (Object)"port", (Object)"password", (Object)"enabled");
    @Inject
    private Client client;
    @Inject
    private ProxChatClientConfig config;
    private ScheduledExecutorService executor;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ProxKeyHandler keyHandler;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ProxChatClientOverlay overlay;
    private ClientNetworkHandler network;
    private MicThread micThread;

    @Provides
    ProxChatClientConfig provideConfig(ConfigManager configManager) {
        return (ProxChatClientConfig)configManager.getConfig(ProxChatClientConfig.class);
    }

    protected void startUp() {
        Log.set(3);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.network = new ClientNetworkHandler(this, this.client, this.config::address, this.config::port, this.config::password, this.config::enabled, this.config::room);
        this.network.initKryonet();
        this.micThread = new MicThread(this.network, this.config::micVolume, this.config::activationThreshold, this.config::audioMode, () -> ((Client)this.client).getGameState());
        this.micThread.start();
        this.executor.submit(() -> this.network.connect());
        this.keyManager.registerKeyListener((KeyListener)this.keyHandler);
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.keyHandler);
        this.network.cancelConnecting();
        this.executor.submit(() -> this.network.disconnect());
        if (this.micThread != null) {
            this.micThread.end();
        }
        this.executor.submit(System::gc);
        this.executor.shutdown();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"blueproxchat".equals(event.getGroup())) {
            return;
        }
        if (RECONNECT_CONFIGS.contains(event.getKey())) {
            this.executor.submit(() -> {
                if (!(event.getKey().equals("enabled") || this.network.isConnected() || this.network.isConnecting())) {
                    return;
                }
                this.network.cancelConnecting();
                this.network.disconnect();
                this.network.connect();
            });
        } else if ("showLicenseInfo".equals(event.getKey())) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, ICON_LICENSE, "Blue's Prox Chat", 1));
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        this.network.sendUpdate(this.client.getGameState().getState());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().getState() < GameState.LOGIN_SCREEN.getState()) {
            return;
        }
        this.network.sendUpdate(event.getGameState().getState());
    }

    public ProxChatClientConfig getConfig() {
        return this.config;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public ClientNetworkHandler getNetwork() {
        return this.network;
    }

    public MicThread getMicThread() {
        return this.micThread;
    }
}

