/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client;

import com.google.inject.Inject;
import com.thatgamerblue.osrs.proxchat.client.ProxChatClientPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ImageUtil;

public class ProxChatClientOverlay
extends Overlay {
    private final ProxChatClientPlugin plugin;
    private final BufferedImage disconnectedImg;
    private final BufferedImage micMutedImg;
    private final BufferedImage micActiveImg;
    private final BufferedImage outputMutedImg;

    @Inject
    public ProxChatClientOverlay(ProxChatClientPlugin plugin) {
        this.plugin = plugin;
        this.disconnectedImg = ImageUtil.loadImageResource(ProxChatClientPlugin.class, (String)"disconnected.png");
        this.micMutedImg = ImageUtil.loadImageResource(ProxChatClientPlugin.class, (String)"mic-muted.png");
        this.micActiveImg = ImageUtil.loadImageResource(ProxChatClientPlugin.class, (String)"mic-active.png");
        this.outputMutedImg = ImageUtil.loadImageResource(ProxChatClientPlugin.class, (String)"output-muted.png");
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        if (!this.plugin.getNetwork().isConnected()) {
            image1 = this.disconnectedImg;
        } else if (this.plugin.getMicThread().isToggleMute()) {
            image1 = this.micMutedImg;
        } else if (this.plugin.getNetwork().getMicTransmitting().get()) {
            image1 = this.micActiveImg;
        }
        if (this.plugin.getNetwork().getSpeakerMuted().get()) {
            if (image1 == null) {
                image1 = this.outputMutedImg;
            } else {
                image2 = this.outputMutedImg;
            }
        }
        if (image1 == null) {
            return new Dimension(32, 32);
        }
        graphics.drawImage((Image)image1, 0, 0, null);
        if (image2 != null) {
            graphics.drawImage((Image)image2, 0, 34, null);
        }
        return new Dimension(32, image2 == null ? 32 : 66);
    }
}

