/*
 * Decompiled with CFR 0.152.
 */
package com.thatgamerblue.osrs.proxchat.client;

import com.thatgamerblue.osrs.proxchat.client.audio.AudioMode;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.Range;

@ConfigGroup(value="blueproxchat")
public interface ProxChatClientConfig
extends Config {
    @ConfigItem(keyName="enabled", name="Enabled", description="Enable the plugin", position=0)
    default public boolean enabled() {
        return false;
    }

    @ConfigItem(keyName="address", name="Server Address", description="The voice server to use. Default: proxchat.thatgamerblue.com", position=1)
    default public String address() {
        return "proxchat.thatgamerblue.com";
    }

    @Range(min=1024, max=65535)
    @ConfigItem(keyName="port", name="Server Port", description="Port of the voice server", position=2)
    default public int port() {
        return 30666;
    }

    @ConfigItem(keyName="password", name="Server Password", description="Password of the voice server", position=3, secret=true)
    default public String password() {
        return "";
    }

    @ConfigItem(keyName="room", name="Room Name", description="Shared room name for private calls - if this gets leaked anyone can join", position=4)
    default public String room() {
        return "";
    }

    @ConfigItem(keyName="audioMode", name="Mic Mode", description="Voice detection type to use.", position=5)
    default public AudioMode audioMode() {
        return AudioMode.VOICE_ACTIVITY;
    }

    @Range(min=-127, max=0)
    @ConfigItem(keyName="activationThreshold", name="Activation Threshold", description="Threshold for voice activation in dB. Range: -127 - 0", position=6)
    default public int activationThreshold() {
        return -50;
    }

    @ConfigItem(keyName="pushToTalk", name="PTT Key", description="Push To Talk Key", position=7)
    default public Keybind pushToTalk() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(keyName="toggleMute", name="Mute Mic", description="Push to mute mic", position=8)
    default public Keybind toggleMute() {
        return Keybind.NOT_SET;
    }

    @Range(max=100)
    @ConfigItem(keyName="micVolume", name="Mic Volume", description="Range 0 - 100", position=9)
    default public int micVolume() {
        return 25;
    }

    @ConfigItem(keyName="toggleMuteSpeaker", name="Mute Speaker", description="Push to mute speakers", position=10)
    default public Keybind toggleMuteSpeaker() {
        return Keybind.NOT_SET;
    }

    @Range(max=100)
    @ConfigItem(keyName="speakerVolume", name="Speaker Volume", description="Range 0 - 100", position=11)
    default public int speakerVolume() {
        return 50;
    }

    @ConfigItem(keyName="showLicenseInfo", name="Display Icon License", description="Acts as a button. Click to show icon license info", position=99)
    default public boolean showLicenseInfo() {
        return false;
    }
}

