/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.Connection;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Listener {
    public void connected(Connection connection) {
    }

    public void disconnected(Connection connection) {
    }

    public void received(Connection connection, Object object) {
    }

    public void idle(Connection connection) {
    }

    public static class LagListener
    extends QueuedListener {
        private final ScheduledExecutorService threadPool;
        private final int lagMillisMin;
        private final int lagMillisMax;
        final LinkedList<Runnable> runnables = new LinkedList();

        public LagListener(int lagMillisMin, int lagMillisMax, Listener listener) {
            super(listener);
            this.lagMillisMin = lagMillisMin;
            this.lagMillisMax = lagMillisMax;
            this.threadPool = Executors.newScheduledThreadPool(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void queue(Runnable runnable) {
            LinkedList<Runnable> linkedList = this.runnables;
            synchronized (linkedList) {
                this.runnables.addFirst(runnable);
            }
            int lag = this.lagMillisMin + (int)(Math.random() * (double)(this.lagMillisMax - this.lagMillisMin));
            this.threadPool.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Runnable runnable;
                    LinkedList<Runnable> linkedList = runnables;
                    synchronized (linkedList) {
                        runnable = runnables.removeLast();
                    }
                    runnable.run();
                }
            }, (long)lag, TimeUnit.MILLISECONDS);
        }
    }

    public static class ThreadedListener
    extends QueuedListener {
        protected final ExecutorService threadPool;

        public ThreadedListener(Listener listener) {
            this(listener, Executors.newFixedThreadPool(1));
        }

        public ThreadedListener(Listener listener, ExecutorService threadPool) {
            super(listener);
            if (threadPool == null) {
                throw new IllegalArgumentException("threadPool cannot be null.");
            }
            this.threadPool = threadPool;
        }

        @Override
        public void queue(Runnable runnable) {
            this.threadPool.execute(runnable);
        }
    }

    public static abstract class QueuedListener
    extends Listener {
        final Listener listener;

        public QueuedListener(Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener cannot be null.");
            }
            this.listener = listener;
        }

        @Override
        public void connected(final Connection connection) {
            this.queue(new Runnable(){

                @Override
                public void run() {
                    listener.connected(connection);
                }
            });
        }

        @Override
        public void disconnected(final Connection connection) {
            this.queue(new Runnable(){

                @Override
                public void run() {
                    listener.disconnected(connection);
                }
            });
        }

        @Override
        public void received(final Connection connection, final Object object) {
            this.queue(new Runnable(){

                @Override
                public void run() {
                    listener.received(connection, object);
                }
            });
        }

        @Override
        public void idle(final Connection connection) {
            this.queue(new Runnable(){

                @Override
                public void run() {
                    listener.idle(connection);
                }
            });
        }

        protected abstract void queue(Runnable var1);
    }
}

