/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.minlog.Log;

public class Util {
    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return Void.class;
    }

    public static void log(String message, Object object) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null");
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            // empty if block
        }
    }

    public static String className(Class type) {
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n = Util.getDimensionCount(type);
            for (int i = 0; i < n; ++i) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }
}

