/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;

public class DefaultClassResolver
implements ClassResolver {
    protected Kryo kryo;
    protected final IntMap<Registration> idToRegistration = new IntMap();
    protected final ObjectMap<Class, Registration> classToRegistration = new ObjectMap();
    protected IdentityObjectIntMap<Class> classToNameId;
    protected IntMap<Class> nameIdToClass;
    protected int nextNameId;
    private int memoizedClassId = -1;
    private Registration memoizedClassIdValue;
    private Class memoizedClass;
    private Registration memoizedClassValue;

    @Override
    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    @Override
    public Registration register(Registration registration) {
        if (registration == null) {
            throw new IllegalArgumentException("registration cannot be null.");
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Register class ID " + registration.getId() + ": " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
        }
        this.idToRegistration.put(registration.getId(), registration);
        this.classToRegistration.put(registration.getType(), registration);
        if (registration.getType().isPrimitive()) {
            this.classToRegistration.put(Util.getWrapperClass(registration.getType()), registration);
        }
        return registration;
    }

    @Override
    public Registration getRegistration(Class type) {
        if (type == this.memoizedClass) {
            return this.memoizedClassValue;
        }
        Registration registration = this.classToRegistration.get(type);
        if (registration != null) {
            this.memoizedClass = type;
            this.memoizedClassValue = registration;
        }
        return registration;
    }

    @Override
    public Registration getRegistration(int classID) {
        return this.idToRegistration.get(classID);
    }

    @Override
    public Registration writeClass(Output output, Class type) {
        if (type == null) {
            if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                Util.log("Write", null);
            }
            output.writeVarInt(0, true);
            return null;
        }
        Registration registration = this.kryo.getRegistration(type);
        if (Log.TRACE) {
            Log.trace("kryo", "Write class " + registration.getId() + ": " + Util.className(type));
        }
        output.writeVarInt(registration.getId() + 2, true);
        return registration;
    }

    @Override
    public Registration readClass(Input input) {
        int classID = input.readVarInt(true);
        if (classID == 0) {
            if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                Util.log("Read", null);
            }
            return null;
        }
        if (classID == this.memoizedClassId) {
            return this.memoizedClassIdValue;
        }
        Registration registration = this.idToRegistration.get(classID - 2);
        if (registration == null) {
            throw new KryoException("Encountered unregistered class ID: " + (classID - 2));
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read class " + (classID - 2) + ": " + Util.className(registration.getType()));
        }
        this.memoizedClassId = classID;
        this.memoizedClassIdValue = registration;
        return registration;
    }

    @Override
    public void reset() {
        if (!this.kryo.isRegistrationRequired()) {
            if (this.classToNameId != null) {
                this.classToNameId.clear();
            }
            if (this.nameIdToClass != null) {
                this.nameIdToClass.clear();
            }
            this.nextNameId = 0;
        }
    }
}

