/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.NullSerializerFactory;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import com.esotericsoftware.kryo.util.IdentityMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;

public class Kryo {
    public static final byte NULL = 0;
    private SerializerFactory defaultSerializer = new NullSerializerFactory();
    private final ArrayList<DefaultSerializerEntry> defaultSerializers = new ArrayList(32);
    private final int lowPriorityDefaultSerializerCount;
    private final ClassResolver classResolver;
    private int nextRegisterID;
    private boolean registrationRequired = true;
    private int depth;
    private int maxDepth = Integer.MAX_VALUE;
    private boolean autoReset = true;
    private volatile Thread thread;
    private boolean copyReferences = true;
    private int copyDepth;
    private IdentityMap originalToCopy;
    private Object needsCopyReference;

    public Kryo() {
        this(new DefaultClassResolver());
    }

    public Kryo(ClassResolver classResolver) {
        if (classResolver == null) {
            throw new IllegalArgumentException("classResolver cannot be null.");
        }
        this.classResolver = classResolver;
        classResolver.setKryo(this);
        this.lowPriorityDefaultSerializerCount = this.defaultSerializers.size();
        this.register(Integer.TYPE, new DefaultSerializers.IntSerializer());
        this.register(String.class, new DefaultSerializers.StringSerializer());
        this.register(Float.TYPE, new DefaultSerializers.FloatSerializer());
        this.register(Boolean.TYPE, new DefaultSerializers.BooleanSerializer());
        this.register(Byte.TYPE, new DefaultSerializers.ByteSerializer());
        this.register(Character.TYPE, new DefaultSerializers.CharSerializer());
        this.register(Short.TYPE, new DefaultSerializers.ShortSerializer());
        this.register(Long.TYPE, new DefaultSerializers.LongSerializer());
        this.register(Double.TYPE, new DefaultSerializers.DoubleSerializer());
        this.register(Void.TYPE, new DefaultSerializers.VoidSerializer());
    }

    public void setDefaultSerializer(SerializerFactory serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = serializer;
    }

    public void setDefaultSerializer(Class<? extends Serializer> serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.defaultSerializer = new NullSerializerFactory();
    }

    public void addDefaultSerializer(Class type, SerializerFactory serializerFactory) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("serializerFactory cannot be null.");
        }
        DefaultSerializerEntry entry = new DefaultSerializerEntry(type, serializerFactory);
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, entry);
    }

    public void addDefaultSerializer(Class type, Class<? extends Serializer> serializerClass) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializerClass == null) {
            throw new IllegalArgumentException("serializerClass cannot be null.");
        }
        DefaultSerializerEntry entry = new DefaultSerializerEntry(type, new NullSerializerFactory());
        this.defaultSerializers.add(this.defaultSerializers.size() - this.lowPriorityDefaultSerializerCount, entry);
    }

    public Serializer getDefaultSerializer(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        int n = this.defaultSerializers.size();
        for (int i = 0; i < n; ++i) {
            DefaultSerializerEntry entry = this.defaultSerializers.get(i);
            if (!entry.type.isAssignableFrom(type)) continue;
            Serializer defaultSerializer = entry.serializerFactory.makeSerializer(this, type);
            return defaultSerializer;
        }
        return this.newDefaultSerializer(type);
    }

    protected Serializer newDefaultSerializer(Class type) {
        return this.defaultSerializer.makeSerializer(this, type);
    }

    public Registration register(Class type) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            return registration;
        }
        return this.register(type, this.getDefaultSerializer(type));
    }

    public Registration register(Class type, int id) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            return registration;
        }
        return this.register(type, this.getDefaultSerializer(type), id);
    }

    public Registration register(Class type, Serializer serializer) {
        Registration registration = this.classResolver.getRegistration(type);
        if (registration != null) {
            registration.setSerializer(serializer);
            return registration;
        }
        return this.classResolver.register(new Registration(type, serializer, this.getNextRegistrationId()));
    }

    public Registration register(Class type, Serializer serializer, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be >= 0: " + id);
        }
        return this.register(new Registration(type, serializer, id));
    }

    public Registration register(Registration registration) {
        int id = registration.getId();
        if (id < 0) {
            throw new IllegalArgumentException("id must be > 0: " + id);
        }
        Registration existing = this.getRegistration(registration.getId());
        if (Log.DEBUG && existing != null && existing.getType() != registration.getType()) {
            Log.debug("An existing registration with a different type already uses ID: " + registration.getId() + "\nExisting registration: " + existing + "\nUnable to set registration: " + registration);
        }
        return this.classResolver.register(registration);
    }

    public int getNextRegistrationId() {
        while (this.nextRegisterID != -2) {
            if (this.classResolver.getRegistration(this.nextRegisterID) == null) {
                return this.nextRegisterID;
            }
            ++this.nextRegisterID;
        }
        throw new KryoException("No registration IDs are available.");
    }

    public Registration getRegistration(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Registration registration = this.classResolver.getRegistration(type);
        if (registration == null) {
            if (!type.isEnum() && Enum.class.isAssignableFrom(type)) {
                registration = this.getRegistration(type.getEnclosingClass());
            } else if (EnumSet.class.isAssignableFrom(type)) {
                registration = this.classResolver.getRegistration(EnumSet.class);
            }
            if (registration == null) {
                throw new IllegalArgumentException("Class is not registered: " + Util.className(type) + "\nNote: To register this class use: kryo.register(" + Util.className(type) + ".class);");
            }
        }
        return registration;
    }

    public Registration getRegistration(int classID) {
        return this.classResolver.getRegistration(classID);
    }

    public Serializer getSerializer(Class type) {
        return this.getRegistration(type).getSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration writeClass(Output output, Class type) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        try {
            Registration registration = this.classResolver.writeClass(output, type);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClassAndObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        this.beginObject();
        try {
            if (object == null) {
                this.writeClass(output, null);
                return;
            }
            Registration registration = this.writeClass(output, object.getClass());
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Write", object);
            }
            registration.getSerializer().write(this, output, object);
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    public Registration readClass(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        try {
            Registration registration = this.classResolver.readClass(input);
            return registration;
        }
        finally {
            if (this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> type) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.beginObject();
        try {
            T object = this.getRegistration(type).getSerializer().read(this, input, type);
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(Input input, Class<T> type, Serializer serializer) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        this.beginObject();
        try {
            T object = serializer.read(this, input, type);
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            T t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readClassAndObject(Input input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        this.beginObject();
        try {
            Registration registration = this.readClass(input);
            if (registration == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Class type = registration.getType();
            Object object = registration.getSerializer().read(this, input, type);
            if (Log.TRACE || Log.DEBUG && this.depth == 1) {
                Util.log("Read", object);
            }
            Object t = object;
            return t;
        }
        finally {
            if (--this.depth == 0 && this.autoReset) {
                this.reset();
            }
        }
    }

    public void reference(Object object) {
        if (this.copyDepth > 0 && this.needsCopyReference != null) {
            if (object == null) {
                throw new IllegalArgumentException("object cannot be null.");
            }
            this.originalToCopy.put(this.needsCopyReference, object);
            this.needsCopyReference = null;
        }
    }

    public void reset() {
        this.depth = 0;
        this.classResolver.reset();
        this.copyDepth = 0;
        if (this.originalToCopy != null) {
            this.originalToCopy.clear(2048);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Object graph complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T object) {
        if (object == null) {
            return null;
        }
        ++this.copyDepth;
        try {
            Object existingCopy;
            if (this.originalToCopy == null) {
                this.originalToCopy = new IdentityMap();
            }
            if ((existingCopy = this.originalToCopy.get(object)) != null) {
                Object v = existingCopy;
                return (T)v;
            }
            if (this.copyReferences) {
                this.needsCopyReference = object;
            }
            T copy = this.getSerializer(object.getClass()).copy(this, object);
            if (this.needsCopyReference != null) {
                this.reference(copy);
            }
            if (Log.TRACE || Log.DEBUG && this.copyDepth == 1) {
                Util.log("Copy", copy);
            }
            T t = copy;
            return t;
        }
        finally {
            if (--this.copyDepth == 0) {
                this.reset();
            }
        }
    }

    private void beginObject() {
        if (Log.DEBUG) {
            if (this.depth == 0) {
                this.thread = Thread.currentThread();
            } else if (this.thread != Thread.currentThread()) {
                throw new ConcurrentModificationException("Kryo must not be accessed concurrently by multiple threads.");
            }
        }
        if (this.depth == this.maxDepth) {
            throw new KryoException("Max depth exceeded: " + this.depth);
        }
        ++this.depth;
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public int getDepth() {
        return this.depth;
    }

    static final class DefaultSerializerEntry {
        final Class type;
        final SerializerFactory serializerFactory;

        DefaultSerializerEntry(Class type, SerializerFactory serializerFactory) {
            this.type = type;
            this.serializerFactory = serializerFactory;
        }
    }
}

