/*
 * Decompiled with CFR 0.152.
 */
package com.attacktimer;

import com.attacktimer.AnimationData;
import com.attacktimer.AttackStyle;
import com.attacktimer.AttackTimerBarOverlay;
import com.attacktimer.AttackTimerMetronomeConfig;
import com.attacktimer.AttackTimerMetronomeTileOverlay;
import com.attacktimer.WeaponType;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Dimension;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;

@PluginDescriptor(name="Attack Timer Metronome", description="Shows a visual cue on an overlay every game tick to help timing based activities", tags={"timers", "overlays", "tick", "skilling"})
public class AttackTimerMetronomePlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private AttackTimerMetronomeTileOverlay overlay;
    @Inject
    private AttackTimerBarOverlay barOverlay;
    @Inject
    private AttackTimerMetronomeConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    public int tickPeriod = 0;
    final int ATTACK_DELAY_NONE = 0;
    private int uiUnshowDebounceTickCount = 0;
    private int uiUnshowDebounceTicksMax = 1;
    public int attackDelayHoldoffTicks = 0;
    public AttackState attackState = AttackState.NOT_ATTACKING;
    public Color CurrentColor = Color.WHITE;
    public int DEFAULT_SIZE_UNIT_PX = 25;
    private final int DEFAULT_FOOD_ATTACK_DELAY_TICKS = 3;
    private final int KARAMBWAN_ATTACK_DELAY_TICKS = 2;
    public Dimension DEFAULT_SIZE = new Dimension(this.DEFAULT_SIZE_UNIT_PX, this.DEFAULT_SIZE_UNIT_PX);

    @Provides
    AttackTimerMetronomeConfig provideConfig(ConfigManager configManager) {
        return (AttackTimerMetronomeConfig)configManager.getConfig(AttackTimerMetronomeConfig.class);
    }

    private ItemStats getItemStatsFromContainer(ItemContainer container, int slotID) {
        Item item = container.getItem(slotID);
        return item != null ? this.itemManager.getItemStats(item.getId(), false) : null;
    }

    private ItemStats getWeaponStats() {
        return this.getItemStatsFromContainer(this.client.getItemContainer(InventoryID.EQUIPMENT), EquipmentInventorySlot.WEAPON.getSlotIdx());
    }

    private AttackStyle getAttackStyle() {
        int currentEquippedWeaponTypeVarbit;
        AttackStyle[] attackStyles;
        int currentAttackStyleVarbit = this.client.getVarpValue(43);
        if (currentAttackStyleVarbit < (attackStyles = WeaponType.getWeaponType(currentEquippedWeaponTypeVarbit = this.client.getVarbitValue(357)).getAttackStyles()).length) {
            return attackStyles[currentAttackStyleVarbit];
        }
        return AttackStyle.ACCURATE;
    }

    private int getWeaponSpeed() {
        ItemStats weaponStats = this.getWeaponStats();
        if (weaponStats == null) {
            return 4;
        }
        ItemEquipmentStats e = weaponStats.getEquipment();
        int speed = e.getAspeed();
        if (this.getAttackStyle() == AttackStyle.RANGING && this.client.getVarpValue(43) == 1) {
            --speed;
        }
        return speed;
    }

    private boolean isPlayerAttacking() {
        return AnimationData.fromId(this.client.getLocalPlayer().getAnimation()) != null;
    }

    private void performAttack() {
        this.attackState = AttackState.DELAYED;
        this.tickPeriod = this.attackDelayHoldoffTicks = this.getWeaponSpeed();
        this.uiUnshowDebounceTickCount = this.uiUnshowDebounceTicksMax;
    }

    public int getTicksUntilNextAttack() {
        return 1 + this.attackDelayHoldoffTicks;
    }

    public int getWeaponPeriod() {
        return this.tickPeriod;
    }

    public boolean isAttackCooldownPending() {
        return this.attackState == AttackState.DELAYED || this.uiUnshowDebounceTickCount > 0;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = event.getMessage();
        if (message.startsWith("You eat") || message.startsWith("You drink the wine")) {
            int attackDelay;
            int n = attackDelay = message.toLowerCase().contains("karambwan") ? 2 : 3;
            if (this.attackState == AttackState.DELAYED) {
                this.attackDelayHoldoffTicks += attackDelay;
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        Actor source = interactingChanged.getSource();
        Actor target = interactingChanged.getTarget();
        Player p = this.client.getLocalPlayer();
        if (source.equals(p) && target instanceof NPC) {
            switch (this.attackState) {
                case NOT_ATTACKING: {
                    if (!this.isPlayerAttacking()) break;
                    this.performAttack();
                    break;
                }
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        boolean isAttacking = this.isPlayerAttacking();
        switch (this.attackState) {
            case NOT_ATTACKING: {
                if (isAttacking) {
                    this.performAttack();
                    break;
                }
                --this.uiUnshowDebounceTickCount;
                break;
            }
            case DELAYED: {
                if (this.attackDelayHoldoffTicks > 0) break;
                if (isAttacking) {
                    this.performAttack();
                    break;
                }
                this.attackState = AttackState.NOT_ATTACKING;
            }
        }
        --this.attackDelayHoldoffTicks;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.attackDelayHoldoffTicks = 0;
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlay.setPreferredSize(this.DEFAULT_SIZE);
        this.overlayManager.add((Overlay)this.barOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.barOverlay);
        this.attackDelayHoldoffTicks = 0;
    }

    public static enum AttackState {
        NOT_ATTACKING,
        DELAYED;

    }
}

