/*
 * Decompiled with CFR 0.152.
 */
package com.prayervolumecontrol;

import com.google.inject.Provides;
import com.prayervolumecontrol.PrayerVolumeControlConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Prayer volume control")
public class PrayerVolumeControlPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PrayerVolumeControlPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PrayerVolumeControlConfig config;

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        int soundId = soundEffectPlayed.getSoundId();
        int soundVolume = 100;
        boolean isPrayer = false;
        switch (soundId) {
            case 2670: {
                soundVolume = Math.round(this.config.auguryMysticWill());
                isPrayer = true;
                break;
            }
            case 2688: {
                soundVolume = this.config.burstOfStrength();
                isPrayer = true;
                break;
            }
            case 3826: {
                soundVolume = this.config.chivalry();
                isPrayer = true;
                break;
            }
            case 2664: {
                soundVolume = this.config.clarityOfThought();
                isPrayer = true;
                break;
            }
            case 2665: {
                soundVolume = this.config.eagleEye();
                isPrayer = true;
                break;
            }
            case 2666: {
                soundVolume = this.config.hawkEye();
                isPrayer = true;
                break;
            }
            case 2662: {
                soundVolume = this.config.improvedReflexes();
                isPrayer = true;
                break;
            }
            case 2667: {
                soundVolume = this.config.incredibleReflexes();
                isPrayer = true;
                break;
            }
            case 2668: {
                soundVolume = this.config.mysticLore();
                isPrayer = true;
                break;
            }
            case 2669: {
                soundVolume = this.config.mysticMight();
                isPrayer = true;
                break;
            }
            case 3825: {
                soundVolume = this.config.piety();
                isPrayer = true;
                break;
            }
            case 2679: {
                soundVolume = this.config.preserveRapidRestore();
                isPrayer = true;
                break;
            }
            case 2675: {
                soundVolume = this.config.protectFromMagic();
                isPrayer = true;
                break;
            }
            case 2676: {
                soundVolume = this.config.protectFromMelee();
                isPrayer = true;
                break;
            }
            case 2677: {
                soundVolume = this.config.protectFromMissiles();
                isPrayer = true;
                break;
            }
            case 1982: {
                soundVolume = this.config.protectItem();
                isPrayer = true;
                break;
            }
            case 2678: {
                soundVolume = this.config.rapidHeal();
                isPrayer = true;
                break;
            }
            case 2680: {
                soundVolume = this.config.redemption();
                isPrayer = true;
                break;
            }
            case 2682: {
                soundVolume = this.config.retribution();
                isPrayer = true;
                break;
            }
            case 2685: {
                soundVolume = this.config.rigourSharpEye();
                isPrayer = true;
                break;
            }
            case 2684: {
                soundVolume = this.config.rockSkin();
                isPrayer = true;
                break;
            }
            case 2686: {
                soundVolume = this.config.smite();
                isPrayer = true;
                break;
            }
            case 2687: {
                soundVolume = this.config.steelSkin();
                isPrayer = true;
                break;
            }
            case 2689: {
                soundVolume = this.config.superhumanStrength();
                isPrayer = true;
                break;
            }
            case 2690: {
                soundVolume = this.config.thickSkin();
                isPrayer = true;
                break;
            }
            case 2691: {
                soundVolume = this.config.ultimateStrength();
                isPrayer = true;
                break;
            }
            case 2663: {
                soundVolume = this.config.prayerDeactivate();
                break;
            }
            case 2266: {
                soundVolume = this.config.uiBoop();
            }
        }
        if (isPrayer && this.config.useOverridePrayerVolume()) {
            this.overridePrayerSound(soundEffectPlayed, soundId, this.config.overridePrayerVolume());
            return;
        }
        if (soundVolume == 100) {
            return;
        }
        this.overridePrayerSound(soundEffectPlayed, soundId, soundVolume);
    }

    protected void overridePrayerSound(SoundEffectPlayed soundEffectPlayed, int soundId, int soundVolume) {
        soundEffectPlayed.consume();
        int currentVolume = this.client.getPreferences().getSoundEffectVolume();
        this.client.getPreferences().setSoundEffectVolume(soundVolume);
        this.client.playSoundEffect(soundId, soundVolume);
        this.client.getPreferences().setSoundEffectVolume(currentVolume);
    }

    @Provides
    PrayerVolumeControlConfig provideConfig(ConfigManager configManager) {
        return (PrayerVolumeControlConfig)configManager.getConfig(PrayerVolumeControlConfig.class);
    }
}

