/*
 * Decompiled with CFR 0.152.
 */
package xrio.worldlocation;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.RenderOverview;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import xrio.worldlocation.InfoType;
import xrio.worldlocation.WorldLocationConfig;

class WorldMapOverlay
extends Overlay {
    private static final int LABEL_PADDING = 4;
    private static final Color WHITE_TRANSLUCENT = new Color(255, 255, 255, 127);
    private final Client client;
    private final WorldLocationConfig config;

    @Inject
    private WorldMapOverlay(Client client, WorldLocationConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.mapTileLines()) {
            this.drawMapLines(graphics, 1, this.config.tileLineColour());
        }
        if (this.config.mapChunkLines()) {
            this.drawMapLines(graphics, 8, this.config.chunkLineColour());
        }
        if (this.config.mapRegionLines()) {
            this.drawMapLines(graphics, 64, this.config.regionLineColour());
        }
        return null;
    }

    private void drawMapLines(Graphics2D graphics, int gridSize, Color gridColour) {
        int gridTruncate = ~(gridSize - 1);
        RenderOverview ro = this.client.getRenderOverview();
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        Float pixelsPerTile = Float.valueOf(ro.getWorldMapZoom());
        if (map == null) {
            return;
        }
        if ((float)gridSize * pixelsPerTile.floatValue() < 3.0f) {
            return;
        }
        Rectangle worldMapRect = map.getBounds();
        graphics.setClip(worldMapRect);
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile.floatValue());
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile.floatValue());
        Point worldMapPosition = ro.getWorldMapPosition();
        int yTileMin = worldMapPosition.getY() - heightInTiles / 2;
        int xRegionMin = worldMapPosition.getX() - widthInTiles / 2 & gridTruncate;
        int xRegionMax = (worldMapPosition.getX() + widthInTiles / 2 & gridTruncate) + gridSize;
        int yRegionMin = yTileMin & gridTruncate;
        int yRegionMax = (worldMapPosition.getY() + heightInTiles / 2 & gridTruncate) + gridSize;
        int regionPixelSize = (int)Math.ceil((float)gridSize * pixelsPerTile.floatValue());
        for (int x = xRegionMin; x < xRegionMax; x += gridSize) {
            for (int y = yRegionMin; y < yRegionMax; y += gridSize) {
                int yTileOffset = -(yTileMin - y);
                int xTileOffset = x + widthInTiles / 2 - worldMapPosition.getX();
                int xPos = (int)((float)xTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getX();
                int yPos = worldMapRect.height - (int)((float)yTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getY();
                graphics.setColor(gridColour);
                graphics.drawRect(xPos, yPos -= regionPixelSize, regionPixelSize, regionPixelSize);
                graphics.setColor(WHITE_TRANSLUCENT);
                if (gridSize != 64) continue;
                int regionId = x >> 6 << 8 | y >> 6;
                Object regionText = String.valueOf(regionId);
                if (InfoType.LOCAL_COORDINATES.equals((Object)this.config.gridInfoType())) {
                    regionText = (x >> 6) + ", " + (y >> 6);
                }
                FontMetrics fm = graphics.getFontMetrics();
                Rectangle2D textBounds = fm.getStringBounds((String)regionText, graphics);
                int labelWidth = (int)textBounds.getWidth() + 8;
                int labelHeight = (int)textBounds.getHeight() + 8;
                graphics.fillRect(xPos, yPos, labelWidth, labelHeight);
                graphics.setColor(Color.BLACK);
                graphics.drawString((String)regionText, xPos + 4, yPos + (int)textBounds.getHeight() + 4);
            }
        }
    }
}

