/*
 * Decompiled with CFR 0.152.
 */
package xrio.worldlocation;

import com.google.inject.Inject;
import com.google.inject.Provides;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import xrio.worldlocation.InfoOverlay;
import xrio.worldlocation.SceneOverlay;
import xrio.worldlocation.WorldLocationConfig;
import xrio.worldlocation.WorldMapOverlay;

@PluginDescriptor(name="World Location", description="Shows world tile location and grid lines", tags={"world", "tile", "location", "coordinates", "grid", "lines"})
public class WorldLocationPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfoOverlay infoOverlay;
    @Inject
    private SceneOverlay sceneOverlay;
    @Inject
    private WorldMapOverlay worldMapOverlay;
    @Inject
    private WorldLocationConfig config;

    @Provides
    WorldLocationConfig providesConfig(ConfigManager configManager) {
        return (WorldLocationConfig)configManager.getConfig(WorldLocationConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.infoOverlay);
        this.overlayManager.add((Overlay)this.sceneOverlay);
        this.overlayManager.add((Overlay)this.worldMapOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.infoOverlay);
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.overlayManager.remove((Overlay)this.worldMapOverlay);
    }
}

