/*
 * Decompiled with CFR 0.152.
 */
package xrio.worldlocation;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import xrio.worldlocation.InstanceInfoType;
import xrio.worldlocation.WorldLocationConfig;

public class SceneOverlay
extends Overlay {
    private static final int CULL_CHUNK_BORDERS_RANGE = 16;
    private static final int LOCAL_TILE_SIZE = 128;
    private final Client client;
    private final WorldLocationConfig config;
    private final TooltipManager tooltipManager;

    @Inject
    public SceneOverlay(Client client, WorldLocationConfig config, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.tileLines()) {
            this.renderLines(graphics, 1, this.config.tileLineWidth(), this.config.tileLineColour());
        }
        if (this.config.chunkLines()) {
            this.renderLines(graphics, 8, this.config.chunkLineWidth(), this.config.chunkLineColour());
        }
        if (this.config.regionLines()) {
            this.renderLines(graphics, 64, this.config.regionLineWidth(), this.config.regionLineColour());
        }
        if (this.config.tileLocation() && this.isHoveringScene()) {
            this.renderTile(graphics, this.config.tileColour());
        }
        return null;
    }

    private void renderLines(Graphics2D graphics, int gridSize, int lineWidth, Color lineColour) {
        Point p;
        boolean first;
        LocalPoint lp2;
        LocalPoint lp1;
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int startX = (wp.getX() - 16 + gridSize - 1) / gridSize * gridSize;
        int startY = (wp.getY() - 16 + gridSize - 1) / gridSize * gridSize;
        int endX = (wp.getX() + 16) / gridSize * gridSize;
        int endY = (wp.getY() + 16) / gridSize * gridSize;
        graphics.setStroke(new BasicStroke(lineWidth));
        graphics.setColor(lineColour);
        GeneralPath path = new GeneralPath();
        for (int x = startX; x <= endX; x += gridSize) {
            lp1 = LocalPoint.fromWorld((Client)this.client, (int)x, (int)(wp.getY() - 16));
            lp2 = LocalPoint.fromWorld((Client)this.client, (int)x, (int)(wp.getY() + 16));
            if (lp1 == null || lp2 == null) {
                return;
            }
            first = true;
            for (int y = lp1.getY(); y <= lp2.getY(); y += 128) {
                p = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(lp1.getX() - 64, y - 64), (int)this.client.getPlane());
                if (p == null) continue;
                if (first) {
                    path.moveTo(p.getX(), p.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p.getX(), p.getY());
            }
        }
        for (int y = startY; y <= endY; y += gridSize) {
            lp1 = LocalPoint.fromWorld((Client)this.client, (int)(wp.getX() - 16), (int)y);
            lp2 = LocalPoint.fromWorld((Client)this.client, (int)(wp.getX() + 16), (int)y);
            if (lp1 == null || lp2 == null) {
                return;
            }
            first = true;
            for (int x = lp1.getX(); x <= lp2.getX(); x += 128) {
                p = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(x - 64, lp1.getY() - 64), (int)this.client.getPlane());
                if (p == null) continue;
                if (first) {
                    path.moveTo(p.getX(), p.getY());
                    first = false;
                    continue;
                }
                path.lineTo(p.getX(), p.getY());
            }
        }
        graphics.draw(path);
    }

    private void renderTile(Graphics2D graphics, Color tileColour) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = this.client.getPlane();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Polygon poly;
                Tile tile = tiles[z][x][y];
                if (tile == null || (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)tile.getLocalLocation())) == null || !poly.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) continue;
                WorldPoint wp = tile.getWorldLocation();
                int tileX = wp.getX();
                int tileY = wp.getY();
                if (InstanceInfoType.TEMPLATE.equals((Object)this.config.instanceInfoType()) && this.client.isInInstancedRegion()) {
                    int[][][] instanceTemplateChunks = this.client.getInstanceTemplateChunks();
                    LocalPoint localPoint = tile.getLocalLocation();
                    int chunkData = instanceTemplateChunks[z][localPoint.getSceneX() / 8][localPoint.getSceneY() / 8];
                    tileX = (chunkData >> 14 & 0x3FF) * 8 + tileX % 8;
                    tileY = (chunkData >> 3 & 0x7FF) * 8 + tileY % 8;
                }
                this.tooltipManager.add(new Tooltip(tileX + ", " + tileY + ", " + z));
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)tileColour);
            }
        }
    }

    private boolean isHoveringScene() {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        for (int i = menuEntries.length - 1; i >= 0; --i) {
            if (!MenuAction.WALK.equals((Object)menuEntries[i].getType())) continue;
            return true;
        }
        return false;
    }
}

