/*
 * Decompiled with CFR 0.152.
 */
package xrio.worldlocation;

import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import xrio.worldlocation.InfoType;
import xrio.worldlocation.InstanceInfoType;
import xrio.worldlocation.WorldLocationConfig;

public class InfoOverlay
extends OverlayPanel {
    private final Client client;
    private final WorldLocationConfig config;

    @Inject
    InfoOverlay(Client client, WorldLocationConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.gridInfo() || this.client.getLocalPlayer() == null) {
            return null;
        }
        int z = this.client.getPlane();
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int tileX = wp.getX();
        int tileY = wp.getY();
        int chunkTileX = tileX % 8;
        int chunkTileY = tileY % 8;
        if (InstanceInfoType.TEMPLATE.equals((Object)this.config.instanceInfoType()) && this.client.isInInstancedRegion()) {
            int[][][] instanceTemplateChunks = this.client.getInstanceTemplateChunks();
            LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
            int chunkData = instanceTemplateChunks[z][localPoint.getSceneX() / 8][localPoint.getSceneY() / 8];
            tileX = (chunkData >> 14 & 0x3FF) * 8 + chunkTileX;
            tileY = (chunkData >> 3 & 0x7FF) * 8 + chunkTileY;
        }
        int chunkX = tileX >> 3;
        int chunkY = tileY >> 3;
        int regionX = tileX >> 6;
        int regionY = tileY >> 6;
        int regionTileX = tileX % 64;
        int regionTileY = tileY % 64;
        int chunkID = chunkX << 11 | chunkY;
        int regionID = regionX << 8 | regionY;
        boolean useId = InfoType.UNIQUE_ID.equals((Object)this.config.gridInfoType());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Tile").right(tileX + ", " + tileY + ", " + z).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Chunk" + (useId ? " ID" : "")).right(useId ? "" + chunkID : chunkX + ", " + chunkY + ", " + chunkTileX + ", " + chunkTileY).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Region" + (useId ? " ID" : "")).right(useId ? "" + regionID : regionX + ", " + regionY + ", " + regionTileX + ", " + regionTileY).build());
        return super.render(graphics);
    }
}

