/*
 * Decompiled with CFR 0.152.
 */
package com.resting;

import com.google.inject.Provides;
import com.resting.IdlePoses;
import com.resting.RestingConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Resting", description="Allows the player a resting idle animation", tags={"immersion", "rest", "emote"})
public class RestingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RestingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private RestingConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    private final Map<Player, WorldPoint> restMap = new HashMap<Player, WorldPoint>();
    private final int MAGIC_LUNAR_DREAM_Z = 1056;
    private final int IDLE_POSE = 808;
    private final int REST_POSE = 6296;
    private final int SIT_POSE = 4851;
    private final int RELAX_POSE = 8409;
    private final int LOUNGE_POSE = 6284;
    private final int CROSS_ARMS_POSE = 2256;
    private final int FOLD_HANDS_POSE = 2578;
    private final int MAGIC_LUNAR_DREAM_SITTING_DOWN = 7627;
    private final int EMOTE_SPIN = 2107;
    private int autoRestTimer = 0;
    private WorldPoint autoRestWorldPoint;
    private final Random random = new Random();

    protected void shutDown() throws Exception {
        this.clientThread.invoke(this::clearAllRests);
    }

    protected void startUp() throws Exception {
        this.clientThread.invoke(this::loadRunWidget);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.config.autoRest()) {
            Player player = this.client.getLocalPlayer();
            WorldPoint playerLocation = player.getWorldLocation();
            ++this.autoRestTimer;
            if (!playerLocation.equals((Object)this.autoRestWorldPoint)) {
                this.autoRestTimer = 0;
                this.autoRestWorldPoint = playerLocation;
            }
            if (this.restMap.containsKey(player) || this.client.getWidget(WidgetInfo.BANK_CONTAINER) != null || this.client.getWidget(WidgetInfo.DIALOG_OPTION_OPTIONS) != null || this.client.getWidget(WidgetInfo.DIALOG_NPC_HEAD_MODEL) != null || this.client.getWidget(WidgetInfo.DIALOG_PLAYER) != null || this.client.getWidget(WidgetInfo.DIALOG_OPTION) != null || this.client.getWidget(WidgetInfo.BANK_PIN_CONTAINER) != null || player.getAnimation() != -1) {
                this.autoRestTimer = 0;
            }
            if (this.autoRestTimer >= this.config.autoRestTimer()) {
                this.autoRestTimer = 0;
                this.startRest(player);
            }
        }
        for (Map.Entry<Player, WorldPoint> entry : this.restMap.entrySet()) {
            Player player = entry.getKey();
            WorldPoint worldPoint = entry.getValue();
            if (player.getWorldLocation().equals((Object)worldPoint)) continue;
            this.stopRest(player);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() instanceof Player) {
            Player player = (Player)event.getActor();
            int animationID = player.getAnimation();
            if (player == this.client.getLocalPlayer()) {
                this.autoRestTimer = 0;
            }
            if (this.restMap.containsKey(player) && animationID != 808 && animationID != -1) {
                this.stopRest(player);
            } else if (!this.restMap.containsKey(player) && animationID == 2107 && (player == this.client.getLocalPlayer() && this.config.allowSpinRest() || player != this.client.getLocalPlayer() && this.config.allowPublicRest())) {
                this.startRest(player);
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuEntry().getOption().equals("Rest (private)")) {
            this.startRest(this.client.getLocalPlayer());
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        Player player;
        if (event.getActor() instanceof Player && this.restMap.containsKey(player = (Player)event.getActor())) {
            this.stopRest(player);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int eventId = event.getGroupId();
        if (eventId == WidgetInfo.MINIMAP_TOGGLE_RUN_ORB.getGroupId()) {
            this.loadRunWidget();
        }
        if (!this.restMap.containsKey(this.client.getLocalPlayer())) {
            return;
        }
        if (eventId == WidgetInfo.BANK_CONTAINER.getGroupId() || eventId == WidgetInfo.DIALOG_OPTION_OPTIONS.getGroupId() || eventId == WidgetInfo.DIALOG_NPC_HEAD_MODEL.getGroupId() || eventId == WidgetInfo.DIALOG_PLAYER.getGroupId() || eventId == WidgetInfo.DIALOG_OPTION.getGroupId() || eventId == WidgetInfo.BANK_PIN_CONTAINER.getGroupId()) {
            this.autoRestTimer = 0;
            this.stopRest(this.client.getLocalPlayer());
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String key = event.getKey();
        if (key.equals("autoRest") || key.equals("autoRestTimer")) {
            this.autoRestTimer = 0;
            return;
        }
        if (key.equals("allowPublicResting") && !this.config.allowPublicRest()) {
            this.clearAllRests();
            return;
        }
        if (key.equals("restMode") || key.equals("customAnimation")) {
            Player player = this.client.getLocalPlayer();
            if (!this.restMap.containsKey(player)) {
                return;
            }
            this.stopRest(player);
            this.startRest(player);
        }
    }

    public void startRest(Player player) {
        System.out.println("StartRest");
        if (this.restMap.containsKey(player)) {
            System.out.println("Contains player");
            if (player == this.client.getLocalPlayer()) {
                this.stopRest(player);
            }
            return;
        }
        System.out.println("Doesn't contain player");
        if (player == this.client.getLocalPlayer()) {
            this.removeWeapon();
            player.setAnimation(-1);
            switch (this.config.restMode()) {
                case REST: {
                    player.setAnimation(7627);
                    player.setAnimationFrame(0);
                    player.setIdlePoseAnimation(6296);
                    break;
                }
                case SLEEP: {
                    player.setAnimation(7627);
                    player.setAnimationFrame(0);
                    player.createSpotAnim(0, 1056, 0, 0);
                    player.setIdlePoseAnimation(6296);
                    break;
                }
                case SIT: {
                    player.setIdlePoseAnimation(4851);
                    break;
                }
                case LOUNGE: {
                    player.setIdlePoseAnimation(6284);
                    break;
                }
                case RELAX: {
                    player.setIdlePoseAnimation(8409);
                    break;
                }
                case CROSS_ARMS: {
                    player.setIdlePoseAnimation(2256);
                    break;
                }
                case FOLD_HANDS: {
                    player.setIdlePoseAnimation(2578);
                    break;
                }
                case CUSTOM: {
                    player.setIdlePoseAnimation(this.config.customAnimation());
                }
            }
        } else {
            int randomInt = this.random.nextInt(5);
            switch (randomInt) {
                case 0: {
                    player.setAnimation(7627);
                    player.setAnimationFrame(0);
                    player.setIdlePoseAnimation(6296);
                    break;
                }
                case 1: {
                    player.setAnimation(7627);
                    player.setAnimationFrame(0);
                    player.createSpotAnim(0, 1056, 0, 0);
                    player.setIdlePoseAnimation(6296);
                    break;
                }
                case 2: {
                    player.setIdlePoseAnimation(4851);
                    break;
                }
                case 3: {
                    player.setIdlePoseAnimation(6284);
                    break;
                }
                case 4: {
                    player.setIdlePoseAnimation(8409);
                }
            }
        }
        this.restMap.put(player, player.getWorldLocation());
    }

    public void removeWeapon() {
        Player player = this.client.getLocalPlayer();
        PlayerComposition comp = player.getPlayerComposition();
        int[] kits = comp.getEquipmentIds();
        kits[KitType.WEAPON.getIndex()] = 0;
        kits[KitType.SHIELD.getIndex()] = 0;
        player.getPlayerComposition().setHash();
    }

    public void stopRest(Player player) {
        System.out.println("Stop rest");
        player.setAnimation(-1);
        if (player == this.client.getLocalPlayer()) {
            this.returnWeapon();
            this.autoRestTimer = 0;
        }
        this.returnIdleAnimation(player);
        player.removeSpotAnim(0);
        this.restMap.remove(player);
    }

    public void clearAllRests() {
        for (Map.Entry<Player, WorldPoint> entry : this.restMap.entrySet()) {
            Player player = entry.getKey();
            this.stopRest(player);
        }
    }

    public void returnWeapon() {
        Item shield;
        Player player = this.client.getLocalPlayer();
        PlayerComposition comp = player.getPlayerComposition();
        int[] kits = comp.getEquipmentIds();
        ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipmentContainer == null) {
            return;
        }
        Item weapon = equipmentContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx());
        if (weapon != null) {
            kits[KitType.WEAPON.getIndex()] = weapon.getId() + 512;
        }
        if ((shield = equipmentContainer.getItem(EquipmentInventorySlot.SHIELD.getSlotIdx())) != null) {
            kits[KitType.SHIELD.getIndex()] = shield.getId() + 512;
        }
        player.getPlayerComposition().setHash();
    }

    public void returnIdleAnimation(Player player) {
        if (player == this.client.getLocalPlayer()) {
            ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
            if (equipmentContainer == null) {
                player.setIdlePoseAnimation(808);
                return;
            }
            Item weapon = equipmentContainer.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx());
            if (weapon == null) {
                player.setIdlePoseAnimation(808);
            }
            if (weapon != null) {
                for (IdlePoses idlePoses : IdlePoses.values()) {
                    if (idlePoses.getWeaponType() != weapon.getId()) continue;
                    player.setIdlePoseAnimation(idlePoses.getAnimationId());
                    return;
                }
                player.setIdlePoseAnimation(808);
            }
            return;
        }
        PlayerComposition comp = player.getPlayerComposition();
        int[] kits = comp.getEquipmentIds();
        int weaponId = kits[KitType.WEAPON.getIndex()] - 512;
        for (IdlePoses idlePoses : IdlePoses.values()) {
            if (idlePoses.getWeaponType() != weaponId) continue;
            player.setIdlePoseAnimation(idlePoses.getAnimationId());
            return;
        }
        player.setIdlePoseAnimation(808);
    }

    public void loadRunWidget() {
        Widget widget = this.client.getWidget(WidgetInfo.MINIMAP_TOGGLE_RUN_ORB);
        if (widget == null) {
            return;
        }
        widget.setAction(1, "Rest (private)");
    }

    @Provides
    RestingConfig provideConfig(ConfigManager configManager) {
        return (RestingConfig)configManager.getConfig(RestingConfig.class);
    }
}

