/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.StabilityUpdateInfo;
import com.ultimatevm.StatusState;
import com.ultimatevm.UltimateVolcanicMineConfig;
import com.ultimatevm.VentStatus;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class VentStatusTimeline {
    public static final int VENT_MOVE_TICK_TIME = 10;
    public static final int STABILITY_UPDATE_TICK_TIME = 25;
    public static final int VM_GAME_FULL_TIME = 1000;
    public static final int VM_GAME_RESET_TIME = 500;
    public static final int DIRECTION_CHANGED_FLAG = 16;
    public static final int IDENTIFIED_VENT_FLAG = 17;
    public static final int MOVEMENT_UPDATE_FLAG = 18;
    public static final int STABILITY_UPDATE_FLAG = 19;
    public static final int EARTHQUAKE_EVENT_FLAG = 20;
    public static final int ESTIMATED_MOVEMENT_FLAG = 21;
    public static final int HALF_SPACE_COMPLETED_FLAG = 22;
    public static final int IDENTIFIED_BIT_MASK = 7;
    public static final int DIRECTION_CHANGED_BIT_MASK = 56;
    public static final int MOVEMENT_BIT_MASK = 4032;
    public static final int HALF_SPACE_VENTS_BIT_MASK = 0x3800000;
    public static final int HALF_SPACE_CLIP_BIT_MASK = 0x1C000000;
    private int currentTick;
    private int startingTick;
    private int currentMovementTick;
    private int firstStabilityUpdateTick;
    private int[] timeline;
    private int[] identifiedVentTick;
    private StatusState[] identifiedVentStates;
    private int numIdentifiedVents;
    private boolean hasReset = false;
    StatusState initialState;
    StabilityUpdateInfo initialStabInfo;
    HashMap<Integer, StatusState> tickToMovementVentState;
    HashMap<Integer, StabilityUpdateInfo> tickToStabilityUpdateState;

    public VentStatusTimeline() {
        this.initialize();
    }

    public void initialize() {
        this.currentTick = 0;
        this.timeline = new int[1000];
        this.tickToMovementVentState = new HashMap();
        this.tickToStabilityUpdateState = new HashMap();
        this.reset();
        this.hasReset = false;
    }

    public void reset() {
        if (this.hasReset) {
            return;
        }
        this.hasReset = true;
        this.firstStabilityUpdateTick = Integer.MAX_VALUE;
        this.currentMovementTick = this.startingTick = this.currentTick;
        this.numIdentifiedVents = 0;
        this.initialState = null;
        this.initialStabInfo = null;
        this.identifiedVentTick = new int[3];
        this.identifiedVentStates = new StatusState[3];
        for (int i = 0; i < 3; ++i) {
            this.identifiedVentTick[i] = -1;
            this.identifiedVentStates[i] = null;
        }
    }

    public boolean addInitialState(StatusState startingState) {
        if (this.initialState != null) {
            return false;
        }
        this.initialState = new StatusState(startingState);
        return true;
    }

    public void addIdentifiedVentTick(StatusState currentState, int bitState) {
        int ventIndex = -1;
        for (int i = 0; i < 3; ++i) {
            if (this.identifiedVentTick[i] != -1 || (bitState & 1 << i) == 0) continue;
            int n = this.currentTick;
            this.timeline[n] = this.timeline[n] | 0x20000;
            int n2 = this.currentTick;
            this.timeline[n2] = this.timeline[n2] | bitState & 7;
            ++this.numIdentifiedVents;
            this.identifiedVentStates[i] = new StatusState(currentState);
            this.identifiedVentTick[i] = this.currentTick;
            ventIndex = i;
        }
        if (this.numIdentifiedVents == 3 || ventIndex == -1) {
            return;
        }
        this.updatePreviousVentValues(this.identifiedVentStates[ventIndex], this.currentTick);
    }

    private void updatePreviousVentValues(StatusState startingState, int tick) {
        StatusState curState = new StatusState(startingState);
        LinkedList<Integer> stabilityUpdateTicks = new LinkedList<Integer>();
        int numTicksNoMovement = 0;
        int futureMovementTick = Integer.MAX_VALUE;
        for (int i = tick; i >= this.startingTick && numTicksNoMovement <= 20; --i) {
            StabilityUpdateInfo stabilityInfo;
            if ((this.timeline[i] & 0x80000) != 0) {
                if (futureMovementTick - i <= 10) {
                    stabilityInfo = this.tickToStabilityUpdateState.get(i);
                    stabilityInfo.updateVentValues(curState);
                    this.setInitialStabilityUpdateInfo(stabilityInfo);
                } else {
                    stabilityUpdateTicks.addLast(i);
                }
            }
            if ((this.timeline[i] & 0x40000) != 0) {
                numTicksNoMovement = 0;
                futureMovementTick = i;
                if (!stabilityUpdateTicks.isEmpty()) {
                    stabilityInfo = this.tickToStabilityUpdateState.get(stabilityUpdateTicks.getFirst());
                    stabilityInfo.updateVentValues(curState);
                    this.setInitialStabilityUpdateInfo(stabilityInfo);
                    stabilityUpdateTicks.removeFirst();
                }
                StatusState movementState = this.tickToMovementVentState.get(i);
                movementState.setVentsEqualTo(curState);
                if (!this.reverseMovement(curState, i - 1)) {
                    break;
                }
            } else {
                ++numTicksNoMovement;
            }
            if (this.isEarthquakeDelayMovement(i)) {
                numTicksNoMovement = 0;
            }
            if ((this.timeline[i] & 0x10000) == 0) continue;
            this.changeStateDirection(curState, i);
        }
    }

    private void clearMoveSkipEstimatedMove() {
        int minTick = Math.max(this.startingTick, this.currentTick - 25);
        int prevEstMoveTick = Integer.MIN_VALUE;
        int prevMoveTick = Integer.MIN_VALUE;
        for (int i = this.currentTick - 1; i >= minTick; --i) {
            if ((this.timeline[i] & 0x200000) != 0) {
                if (prevEstMoveTick != Integer.MIN_VALUE) {
                    return;
                }
                prevEstMoveTick = i;
            }
            if ((this.timeline[i] & 0x40000) == 0) continue;
            if (prevMoveTick != Integer.MIN_VALUE) {
                return;
            }
            prevMoveTick = i;
        }
        if (prevEstMoveTick == Integer.MIN_VALUE || prevMoveTick == Integer.MIN_VALUE) {
            return;
        }
        if (prevMoveTick > prevEstMoveTick) {
            return;
        }
        int n = prevEstMoveTick;
        this.timeline[n] = this.timeline[n] & 0xFFDFFFFF;
    }

    private void fixPreviousEstimatedMoves() {
        int updateTick = this.currentTick % 10;
        for (int i = this.currentTick - 1; i >= this.currentMovementTick; --i) {
            int n = i;
            this.timeline[n] = this.timeline[n] & 0xFFDFFFFF;
            if (i % 10 != updateTick) continue;
            this.addEstimatedMovementTick(i);
        }
    }

    public void addDirectionChangeTick(int bitState) {
        int n = this.currentTick;
        this.timeline[n] = this.timeline[n] | bitState & 0x38;
        int n2 = this.currentTick;
        this.timeline[n2] = this.timeline[n2] | 0x10000;
    }

    public void addEarthquakeEventTick() {
        int n = this.currentTick;
        this.timeline[n] = this.timeline[n] | 0x100000;
        int n2 = this.currentTick;
        this.timeline[n2] = this.timeline[n2] & 0xFFDFFFFF;
    }

    public void addMovementTick(StatusState currentState, int movementBitState) {
        this.addNewMovementTickState(this.currentTick, currentState, movementBitState);
        this.clearMoveSkipEstimatedMove();
        if (this.currentMovementTick == this.startingTick) {
            this.fixPreviousEstimatedMoves();
            this.updatePreviousVentValues(currentState, this.currentTick);
        }
        this.currentMovementTick = this.currentTick;
    }

    public void addStabilityUpdateTick(StatusState currentState, int change) {
        this.addNewStabilityUpdateTickState(this.currentTick, currentState, change);
    }

    public boolean addEstimatedMovementTick() {
        return this.addEstimatedMovementTick(this.currentTick);
    }

    private boolean addEstimatedMovementTick(int tick) {
        if ((this.timeline[tick] & 0x100000) != 0) {
            return false;
        }
        int n = tick;
        this.timeline[n] = this.timeline[n] | 0x200000;
        return true;
    }

    private void checkHalfSpace(int tick) {
        if (!this.tickToStabilityUpdateState.containsKey(tick)) {
            return;
        }
        int numKnownVents = this.tickToStabilityUpdateState.get(tick).getStabilityUpdateState().getNumIdentifiedVents();
        if (numKnownVents != 1) {
            return;
        }
        int currentChange = this.tickToStabilityUpdateState.get(tick).getInitialChange();
        int endingTick = Math.max(tick - 50, this.startingTick);
        for (int i = tick - 25; i >= endingTick; i -= 25) {
            int timeframeSize;
            int[] moveChange;
            int[] pointChange;
            if (!this.tickToStabilityUpdateState.containsKey(i)) continue;
            int change = this.tickToStabilityUpdateState.get(i).getInitialChange();
            int prevKnownVents = this.tickToStabilityUpdateState.get(i).getStabilityUpdateState().getNumIdentifiedVents();
            if (numKnownVents == prevKnownVents && (!this.getPointContribution(i, tick, pointChange = new int[3], moveChange = new int[4]) || this.completeHalfSpace(tick, timeframeSize = (tick - i) / 25, currentChange - change, pointChange, moveChange))) break;
        }
    }

    public StatusState getTimelinePredictionState() {
        LinkedList<StatusState> possibleStates = new LinkedList<StatusState>();
        StabilityUpdateInfo prevStabInfo = null;
        StatusState predictedState = new StatusState(this.initialState);
        int previousMovementTick = this.startingTick;
        int numTicksNegativePredictedStability = 0;
        possibleStates.push(predictedState);
        for (int i = this.startingTick; i <= this.currentTick; ++i) {
            int ticksSinceLastUpdate;
            int predictedChange;
            StatusState curState;
            Iterator iterator;
            if ((this.timeline[i] & 0x20000) != 0) {
                int idFlags = this.timeline[i] & 7;
                iterator = possibleStates.descendingIterator();
                while (iterator.hasNext()) {
                    curState = (StatusState)iterator.next();
                    if ((idFlags & 1) != 0) {
                        curState.setVentEqualTo(this.identifiedVentStates[0], 0);
                    }
                    if ((idFlags & 2) != 0) {
                        curState.setVentEqualTo(this.identifiedVentStates[1], 1);
                    }
                    if ((idFlags & 4) == 0) continue;
                    curState.setVentEqualTo(this.identifiedVentStates[2], 2);
                }
            }
            if ((this.timeline[i] & 0x200000) != 0) {
                boolean isValueClipped = false;
                boolean isConsecMoveSkip = i - previousMovementTick > 10;
                StatusState newPossibility = new StatusState((StatusState)possibleStates.getLast());
                if (isConsecMoveSkip) {
                    isValueClipped = newPossibility.doFreezeClipping(0);
                }
                if (!isValueClipped) {
                    this.handleSameTickDirectionChangeMovement(newPossibility, i);
                    possibleStates.addLast(newPossibility);
                }
                if (isConsecMoveSkip) {
                    predictedState = (StatusState)possibleStates.getLast();
                }
            }
            if ((this.timeline[i] & 0x40000) != 0) {
                previousMovementTick = i;
                int moveBitState = this.timeline[i] & 0xFC0;
                moveBitState >>= 6;
                iterator = possibleStates.descendingIterator();
                while (iterator.hasNext()) {
                    curState = (StatusState)iterator.next();
                    boolean isValueClipped = curState.doFreezeClipping(moveBitState);
                    if (possibleStates.size() > 1 && isValueClipped) {
                        iterator.remove();
                        continue;
                    }
                    this.handleSameTickDirectionChangeMovement(curState, i);
                    this.syncWithMovementState(curState, i);
                }
                predictedState = (StatusState)possibleStates.getLast();
            }
            if ((this.timeline[i] & 0x80000) != 0) {
                int initalRNGMod;
                Iterator iterator2 = possibleStates.descendingIterator();
                StabilityUpdateInfo stabilityInfo = this.tickToStabilityUpdateState.get(i);
                int n = initalRNGMod = this.initialStabInfo == null ? 0 : this.initialStabInfo.getRNGUpdateMod();
                while (iterator2.hasNext()) {
                    StatusState curState2 = (StatusState)iterator2.next();
                    if (stabilityInfo.isValid()) {
                        if (stabilityInfo == this.initialStabInfo) {
                            curState2.alignPredictedRangesWith(this.initialStabInfo.getStabilityUpdateState());
                        } else {
                            stabilityInfo.updatePredictedState(curState2, prevStabInfo, initalRNGMod);
                        }
                    }
                    if ((this.timeline[i] & 0x400000) == 0) continue;
                    int ventsToClip = (this.timeline[i] & 0x3800000) >> 23;
                    int clipInfo = (this.timeline[i] & 0x1C000000) >> 26;
                    curState2.doHalfSpaceClipping(ventsToClip, clipInfo);
                }
                this.removeInvalidPossibilities(possibleStates);
                predictedState = possibleStates.getLast();
                prevStabInfo = stabilityInfo;
                numTicksNegativePredictedStability = 0;
            }
            if ((this.timeline[i] & 0x10000) != 0) {
                Iterator iterator3 = possibleStates.descendingIterator();
                while (iterator3.hasNext()) {
                    this.changeStateDirection((StatusState)iterator3.next(), i);
                }
            }
            numTicksNegativePredictedStability = (predictedChange = predictedState.getFutureStabilityChange(UltimateVolcanicMineConfig.PredictionScenario.WORST_CASE)) < StabilityUpdateInfo.getMinRNGVariation() - 1 ? ++numTicksNegativePredictedStability : 0;
            if (prevStabInfo == null || numTicksNegativePredictedStability < 50 || (ticksSinceLastUpdate = i - prevStabInfo.getTickTimeStamp()) < 50) continue;
            Iterator<StatusState> iterator4 = possibleStates.descendingIterator();
            while (iterator4.hasNext()) {
                StatusState curState3 = iterator4.next();
                curState3.clipPredictedStabilityMismatch(StabilityUpdateInfo.getMinRNGVariation() - 1);
            }
        }
        return predictedState;
    }

    public StatusState getCurrentPredictionState() {
        return StabilityUpdateInfo.getPredictionState(this.initialStabInfo, this);
    }

    private void addNewMovementTickState(int tick, StatusState currentState, int moveState) {
        StatusState newState = new StatusState(currentState);
        this.tickToMovementVentState.put(tick, newState);
        int n = tick;
        this.timeline[n] = this.timeline[n] | 0x40000;
        int n2 = tick;
        this.timeline[n2] = this.timeline[n2] | moveState;
    }

    private void addNewStabilityUpdateTickState(int tick, StatusState currentState, int change) {
        StabilityUpdateInfo newInfo = new StabilityUpdateInfo(currentState, tick, change);
        this.tickToStabilityUpdateState.put(this.currentTick, newInfo);
        int n = tick;
        this.timeline[n] = this.timeline[n] | 0x80000;
        this.setInitialStabilityUpdateInfo(newInfo);
    }

    private void setInitialStabilityUpdateInfo(StabilityUpdateInfo info) {
        this.firstStabilityUpdateTick = Math.min(this.firstStabilityUpdateTick, this.currentTick);
        int infoIdentifiedVentCount = info.getStabilityUpdateState().getNumIdentifiedVents();
        if (infoIdentifiedVentCount == 0) {
            return;
        }
        if (this.initialStabInfo == null) {
            this.initialStabInfo = info;
        } else if (this.initialStabInfo.getTickTimeStamp() > info.getTickTimeStamp()) {
            this.initialStabInfo = info;
        }
    }

    private void changeStateDirection(StatusState state, int tick) {
        int directionFlags = this.timeline[tick] & 0x38;
        if (((directionFlags >>= 3) & 1) != 0) {
            state.getVents()[0].flipDirection();
        }
        if ((directionFlags & 2) != 0) {
            state.getVents()[1].flipDirection();
        }
        if ((directionFlags & 4) != 0) {
            state.getVents()[2].flipDirection();
        }
    }

    private void handleSameTickDirectionChangeMovement(StatusState curState, int tick) {
        if ((this.timeline[tick] & 0x10000) != 0) {
            StatusState newDirState = new StatusState(curState);
            this.changeStateDirection(newDirState, tick);
            newDirState.updateVentMovement();
            curState.updateVentMovement();
            curState.mergePredictedRangesWith(newDirState);
        } else {
            curState.updateVentMovement();
        }
    }

    private void syncWithMovementState(StatusState state, int tick) {
        StatusState moveState = this.tickToMovementVentState.get(tick);
        for (int i = 0; i < 3; ++i) {
            if (!moveState.getVents()[i].isIdentified()) continue;
            state.setVentEqualTo(moveState, i);
        }
    }

    private boolean isEarthquakeDelayMovement(int tick) {
        if ((this.timeline[tick] & 0x100000) == 0) {
            return false;
        }
        if (tick + 10 <= 1000 && (this.timeline[tick + 10] & 0x40000) != 0) {
            return true;
        }
        if (tick - 10 >= this.startingTick) {
            return (this.timeline[tick - 10] & 0x40000) != 0;
        }
        return false;
    }

    private boolean reverseMovement(StatusState curState, int tick) {
        StatusState prevMoveTickState = null;
        int numTicksNoMovement = 0;
        for (int i = tick; i >= this.startingTick && numTicksNoMovement <= 20; --i) {
            if ((this.timeline[i] & 0x20000) != 0) {
                int idFlags = this.timeline[i] & 7;
                if ((idFlags & 1) != 0) {
                    prevMoveTickState = this.identifiedVentStates[0];
                }
                if ((idFlags & 2) != 0) {
                    prevMoveTickState = this.identifiedVentStates[1];
                }
                if ((idFlags & 4) == 0) break;
                prevMoveTickState = this.identifiedVentStates[2];
                break;
            }
            if ((this.timeline[i] & 0x40000) != 0) {
                prevMoveTickState = this.tickToMovementVentState.get(i);
                break;
            }
            ++numTicksNoMovement;
            if (!this.isEarthquakeDelayMovement(i)) continue;
            numTicksNoMovement = 0;
        }
        int knownBitFlag = 0;
        int unknownBitMask = 0;
        if (prevMoveTickState != null) {
            for (int i = 0; i < 3; ++i) {
                VentStatus prevVent = prevMoveTickState.getVents()[i];
                VentStatus curVent = curState.getVents()[i];
                if (curVent.isIdentified() && prevVent.isIdentified()) {
                    knownBitFlag |= 1 << i;
                    curState.setVentEqualTo(prevMoveTickState, i);
                }
                if (curVent.isIdentified() || prevVent.isIdentified()) continue;
                knownBitFlag |= 1 << i;
                unknownBitMask |= 1 << i;
            }
        }
        if (knownBitFlag == 7) {
            return true;
        }
        int result = curState.reverseMovement(knownBitFlag & ~unknownBitMask);
        if (result == -1) {
            return false;
        }
        if (result == -2) {
            return this.numIdentifiedVents == 1 && this.identifiedVentTick[0] != -1;
        }
        if (result == -3) {
            // empty if block
        }
        return true;
    }

    private void removeInvalidPossibilities(LinkedList<StatusState> possibleStates) {
        Iterator<StatusState> iterator = possibleStates.descendingIterator();
        while (iterator.hasNext() && possibleStates.size() != 1) {
            StatusState curState = iterator.next();
            if (curState.areRangesDefined()) continue;
            iterator.remove();
        }
    }

    private boolean getPointContribution(int startTick, int endTick, int[] pointChange, int[] moveChange) {
        int i;
        if (!this.tickToStabilityUpdateState.containsKey(startTick)) {
            return false;
        }
        StatusState startState = this.tickToStabilityUpdateState.get(startTick).getStabilityUpdateState();
        int[] startingPoints = new int[3];
        int[] endingPoints = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!startState.getVents()[i2].isIdentified()) {
                startingPoints[i2] = Integer.MAX_VALUE;
                endingPoints[i2] = Integer.MAX_VALUE;
                continue;
            }
            endingPoints[i2] = startingPoints[i2] = VentStatus.getStabilityInfluence(startState.getVents()[i2].getActualValue());
        }
        int directionState = 0;
        int numMovementUpdates = 0;
        for (i = startTick; i <= endTick; ++i) {
            if ((this.timeline[i] & 0x10000) != 0) {
                int directionFlags = this.timeline[i] & 0x38;
                if (((directionFlags >>= 3) & 1) != 0) {
                    directionState |= 1;
                }
                if ((directionFlags & 2) != 0) {
                    directionState |= 2;
                }
                if ((directionFlags & 4) != 0) {
                    directionState |= 4;
                }
            }
            if ((this.timeline[i] & 0x40000) == 0) continue;
            StatusState moveState = this.tickToMovementVentState.get(i);
            for (int j = 0; j < 3; ++j) {
                endingPoints[j] = !moveState.getVents()[j].isIdentified() ? Integer.MAX_VALUE : VentStatus.getStabilityInfluence(moveState.getVents()[j].getActualValue());
            }
            moveChange[0] = ++numMovementUpdates;
        }
        for (i = 0; i < 3; ++i) {
            if (startingPoints[i] == Integer.MAX_VALUE) {
                pointChange[i] = Integer.MAX_VALUE;
                continue;
            }
            pointChange[i] = endingPoints[i] - startingPoints[i];
            directionState &= ~(1 << i);
        }
        return directionState == 0;
    }

    private boolean completeHalfSpace(int tick, int timeframeSize, int changeDiff, int[] pointChange, int[] moveChange) {
        if (Math.abs(changeDiff) < StabilityUpdateInfo.getMaxRNGPossibleSize()) {
            return false;
        }
        int knownVentIndex = 0;
        for (int i = 0; i < 3; ++i) {
            if (pointChange[i] == Integer.MAX_VALUE) continue;
            changeDiff -= pointChange[i];
            knownVentIndex = i;
        }
        int missingVentFlag = 7 & ~(1 << knownVentIndex);
        if (moveChange[0] == 0) {
            if (knownVentIndex == 1) {
                if (changeDiff < 0) {
                    int n = tick;
                    this.timeline[n] = this.timeline[n] | 0x4000000;
                }
                int n = tick;
                this.timeline[n] = this.timeline[n] | 0x800000;
                int n2 = tick;
                this.timeline[n2] = this.timeline[n2] | 0x400000;
                return true;
            }
            return false;
        }
        if (Math.abs(changeDiff) <= timeframeSize) {
            return false;
        }
        if (changeDiff < 0) {
            int n = tick;
            this.timeline[n] = this.timeline[n] | missingVentFlag << 26;
        }
        int n = tick;
        this.timeline[n] = this.timeline[n] | missingVentFlag << 23;
        int n3 = tick;
        this.timeline[n3] = this.timeline[n3] | 0x400000;
        return true;
    }

    public boolean isHasReset() {
        return this.hasReset;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public int getCurrentStartingTick() {
        return this.startingTick;
    }

    public int getNumIdentifiedVents() {
        return this.numIdentifiedVents;
    }

    public final int[] getTimeline() {
        return this.timeline;
    }

    public final int[] getIdentifiedVentTicks() {
        return this.identifiedVentTick;
    }

    public final StatusState[] getIdentifiedVentStates() {
        return this.identifiedVentStates;
    }

    public final StatusState getInitialState() {
        return this.initialState;
    }

    public final HashMap<Integer, StatusState> getMovementVentStates() {
        return this.tickToMovementVentState;
    }

    public final HashMap<Integer, StabilityUpdateInfo> getStabilityUpdateStates() {
        return this.tickToStabilityUpdateState;
    }

    public void updateTick() {
        ++this.currentTick;
    }
}

