/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.StabilityUpdateInfo;
import com.ultimatevm.StatusState;
import com.ultimatevm.UltimateVolcanicMineConfig;
import com.ultimatevm.VentStatus;
import com.ultimatevm.VentStatusTimeline;

public class VentStatusPredicter {
    public static final int SLOWEST_VENT_UPDATE_TICK = 9;
    public static final int HIGHEST_STABLE_RNG_PLAYER_COUNT = 8;
    private VentStatusTimeline timeline;
    private StatusState displayState;
    private int numTicksNoMove;
    private int cooldownEndTick;

    public VentStatusPredicter() {
        this.initialize();
    }

    public void initialize() {
        this.timeline = new VentStatusTimeline();
        this.displayState = new StatusState();
        this.cooldownEndTick = 0;
    }

    public void reset() {
        if (!this.timeline.isHasReset()) {
            this.displayState.forceReset();
        }
        this.timeline.reset();
    }

    public void updateVentStatus(int[] ventStatus, int chambers) {
        this.processVentChangeState(this.displayState.updateVentStatus(ventStatus, chambers));
    }

    public void makeStatusState(int change) {
        this.timeline.addStabilityUpdateTick(this.displayState, change);
        this.updateDisplayState();
    }

    public String getVentStatusText(int index, String startingText) {
        VentStatus[] vents = this.displayState.getVents();
        if (vents[index].isIdentified() || !vents[index].isRangeDefined()) {
            return startingText;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(startingText, 0, 3);
        builder.append("<col=00ffff>");
        builder.append(this.getVentPercentText(vents[index]));
        return builder.append("</col>").toString();
    }

    public void markEarthquakeEvent() {
        this.timeline.addEarthquakeEventTick();
    }

    private String getVentPercentText(VentStatus vent) {
        StringBuilder builder = new StringBuilder();
        if (vent.isTwoSeperateValues()) {
            if (vent.isLowerBoundSingleValue()) {
                builder.append(vent.getLowerBoundStart()).append("%");
            } else {
                builder.append(vent.getLowerBoundStart()).append("-");
                builder.append(vent.getLowerBoundEnd());
            }
            builder.append(" ");
            if (vent.isUpperBoundSingleValue()) {
                builder.append(vent.getUpperBoundStart()).append("%");
            } else {
                builder.append(vent.getUpperBoundStart()).append("-");
                builder.append(vent.getUpperBoundEnd());
            }
        } else if (vent.isLowerBoundSingleValue()) {
            builder.append(vent.getLowerBoundStart()).append("%");
        } else {
            builder.append(vent.getLowerBoundStart()).append("-");
            builder.append(vent.getLowerBoundEnd()).append("%");
        }
        return builder.toString();
    }

    private void processVentChangeState(int[] changeStates) {
        int bitState = 0;
        int movementBitState = 0;
        for (int i = 0; i < changeStates.length; ++i) {
            if ((changeStates[i] & VentStatus.VentChangeStateFlag.IDENTIFIED.bitFlag()) != 0) {
                bitState |= 1 << i;
                movementBitState |= 3 << i * 2;
            }
            if ((changeStates[i] & VentStatus.VentChangeStateFlag.DIRECTION_CHANGE.bitFlag()) != 0) {
                bitState |= 1 << i + 3;
            }
            if ((changeStates[i] & VentStatus.VentChangeStateFlag.NO_CHANGE.bitFlag()) != 0) {
                bitState |= 0x40;
            }
            if ((changeStates[i] & VentStatus.VentChangeStateFlag.ONE_CHANGE.bitFlag()) != 0) {
                bitState |= 0x80;
                movementBitState |= 1 << i * 2;
            }
            if ((changeStates[i] & VentStatus.VentChangeStateFlag.TWO_CHANGE.bitFlag()) != 0) {
                bitState |= 0x80;
                movementBitState |= 2 << i * 2;
            }
            if ((changeStates[i] & VentStatus.VentChangeStateFlag.RESET.bitFlag()) == 0) continue;
            bitState |= 0x200;
        }
        this.timeline.addInitialState(this.displayState);
        if ((bitState & 0x200) != 0) {
            if (!this.displayState.hasDoneVMReset()) {
                this.cooldownEndTick = this.timeline.getCurrentTick() + 9;
            }
            this.displayState.doVMReset();
        }
        if ((bitState & 0x38) != 0) {
            this.timeline.addDirectionChangeTick(bitState);
        }
        if ((bitState & 0x80) == 0 && ++this.numTicksNoMove == 10) {
            if (this.timeline.addEstimatedMovementTick()) {
                this.updateDisplayState();
            }
            this.numTicksNoMove = 0;
        }
        if ((bitState & 0x80) != 0) {
            this.timeline.addMovementTick(this.displayState, movementBitState << 6);
            this.updateDisplayState();
            this.numTicksNoMove = 0;
        }
        if ((bitState & 7) != 0) {
            this.timeline.addIdentifiedVentTick(this.displayState, bitState);
            this.updateDisplayState();
        }
    }

    private void updateDisplayState() {
        if (StabilityUpdateInfo.getNumPlayers() > 8) {
            return;
        }
        if (this.displayState.isAllVentsIdentified()) {
            return;
        }
        if (this.cooldownEndTick > this.timeline.getCurrentTick()) {
            return;
        }
        StatusState predictedState = this.timeline.getCurrentPredictionState();
        if (predictedState == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            VentStatus vent = this.displayState.getVents()[i];
            if (vent.isIdentified()) continue;
            vent.setEqualTo(predictedState.getVents()[i]);
        }
    }

    public int getFutureStabilityChange(UltimateVolcanicMineConfig.PredictionScenario scenario) {
        return this.displayState.getFutureStabilityChange(scenario);
    }

    public final StatusState getDisplayState() {
        return this.displayState;
    }

    public final VentStatusTimeline getTimeline() {
        return this.timeline;
    }

    public final int getCurrentTick() {
        return this.timeline.getCurrentTick();
    }

    public boolean isMovementUpdateTick() {
        return this.getCurrentTick() % 10 == 9;
    }
}

