/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

public class VentStatus {
    public static final int STARTING_VENT_VALUE = 127;
    public static final int MIN_VENT_VALUE = 0;
    public static final int PERFECT_VENT_VALUE = 50;
    public static final int MAX_VENT_VALUE = 100;
    public static final int MIN_STARTING_VENT_VALUE = 30;
    public static final int MAX_STARTING_VENT_VALUE = 70;
    public static final float VENT_STABILITY_WEIGHT = 16.0f;
    public static int BASE_MOVE_RATE = 2;
    public static int[][] pointsToLowerRanges = null;
    public static int[][] pointsToUpperRanges = null;
    private char ventName;
    private int actualValue;
    private int movementDirection;
    private int lowerBoundStart;
    private int lowerBoundEnd;
    private int upperBoundStart;
    private int upperBoundEnd;
    private int totalBoundStart;
    private int totalBoundEnd;

    private static void makePointsToRangeTable() {
        if (pointsToLowerRanges != null && pointsToUpperRanges != null) {
            return;
        }
        pointsToLowerRanges = new int[17][2];
        pointsToUpperRanges = new int[17][2];
        VentStatus.pointsToUpperRanges[16][0] = 47;
        VentStatus.pointsToLowerRanges[16][0] = 47;
        VentStatus.pointsToUpperRanges[16][1] = 53;
        VentStatus.pointsToLowerRanges[16][1] = 53;
        VentStatus.pointsToLowerRanges[15][0] = 44;
        VentStatus.pointsToLowerRanges[15][1] = 46;
        VentStatus.pointsToLowerRanges[14][0] = 41;
        VentStatus.pointsToLowerRanges[14][1] = 43;
        VentStatus.pointsToLowerRanges[13][0] = 38;
        VentStatus.pointsToLowerRanges[13][1] = 40;
        VentStatus.pointsToLowerRanges[12][0] = 35;
        VentStatus.pointsToLowerRanges[12][1] = 37;
        VentStatus.pointsToLowerRanges[11][0] = 32;
        VentStatus.pointsToLowerRanges[11][1] = 34;
        VentStatus.pointsToLowerRanges[10][0] = 29;
        VentStatus.pointsToLowerRanges[10][1] = 31;
        VentStatus.pointsToLowerRanges[9][0] = 26;
        VentStatus.pointsToLowerRanges[9][1] = 28;
        VentStatus.pointsToLowerRanges[8][0] = 22;
        VentStatus.pointsToLowerRanges[8][1] = 25;
        VentStatus.pointsToLowerRanges[7][0] = 19;
        VentStatus.pointsToLowerRanges[7][1] = 21;
        VentStatus.pointsToLowerRanges[6][0] = 16;
        VentStatus.pointsToLowerRanges[6][1] = 18;
        VentStatus.pointsToLowerRanges[5][0] = 13;
        VentStatus.pointsToLowerRanges[5][1] = 15;
        VentStatus.pointsToLowerRanges[4][0] = 10;
        VentStatus.pointsToLowerRanges[4][1] = 12;
        VentStatus.pointsToLowerRanges[3][0] = 7;
        VentStatus.pointsToLowerRanges[3][1] = 9;
        VentStatus.pointsToLowerRanges[2][0] = 4;
        VentStatus.pointsToLowerRanges[2][1] = 6;
        VentStatus.pointsToLowerRanges[1][0] = 1;
        VentStatus.pointsToLowerRanges[1][1] = 3;
        VentStatus.pointsToLowerRanges[0][1] = 0;
        VentStatus.pointsToLowerRanges[0][0] = 0;
        VentStatus.pointsToUpperRanges[15][0] = 54;
        VentStatus.pointsToLowerRanges[15][1] = 56;
        VentStatus.pointsToUpperRanges[14][0] = 57;
        VentStatus.pointsToLowerRanges[14][1] = 59;
        VentStatus.pointsToUpperRanges[13][0] = 60;
        VentStatus.pointsToLowerRanges[13][1] = 62;
        VentStatus.pointsToUpperRanges[12][0] = 63;
        VentStatus.pointsToLowerRanges[12][1] = 65;
        VentStatus.pointsToUpperRanges[11][0] = 66;
        VentStatus.pointsToLowerRanges[11][1] = 68;
        VentStatus.pointsToUpperRanges[10][0] = 69;
        VentStatus.pointsToUpperRanges[10][1] = 71;
        VentStatus.pointsToUpperRanges[9][0] = 72;
        VentStatus.pointsToUpperRanges[9][1] = 74;
        VentStatus.pointsToUpperRanges[8][0] = 75;
        VentStatus.pointsToUpperRanges[8][1] = 78;
        VentStatus.pointsToUpperRanges[7][0] = 79;
        VentStatus.pointsToUpperRanges[7][1] = 81;
        VentStatus.pointsToUpperRanges[6][0] = 82;
        VentStatus.pointsToUpperRanges[6][1] = 84;
        VentStatus.pointsToUpperRanges[5][0] = 85;
        VentStatus.pointsToUpperRanges[5][1] = 87;
        VentStatus.pointsToUpperRanges[4][0] = 88;
        VentStatus.pointsToUpperRanges[4][1] = 90;
        VentStatus.pointsToUpperRanges[3][0] = 91;
        VentStatus.pointsToUpperRanges[3][1] = 93;
        VentStatus.pointsToUpperRanges[2][0] = 94;
        VentStatus.pointsToUpperRanges[2][1] = 96;
        VentStatus.pointsToUpperRanges[1][0] = 97;
        VentStatus.pointsToUpperRanges[1][1] = 99;
        VentStatus.pointsToUpperRanges[0][1] = 100;
        VentStatus.pointsToUpperRanges[0][0] = 100;
    }

    public static int getStabilityInfluence(int ventValue) {
        float percentValue = 50 - Math.abs(50 - ventValue);
        percentValue = percentValue / 50.0f * 16.0f;
        return (int)Math.ceil(percentValue);
    }

    public static int getMovementInfluenceOfValue(int value) {
        if (value > 40 && value < 60) {
            return -1;
        }
        return 0;
    }

    public static int[] pointsToLowerRange(int points) {
        if (pointsToLowerRanges == null) {
            return new int[]{-1, -1};
        }
        if (points < 0 || points > 16) {
            return new int[]{-1, -1};
        }
        return pointsToLowerRanges[points];
    }

    public static int[] pointsToUpperRange(int points) {
        if (pointsToUpperRanges == null) {
            return new int[]{-1, -1};
        }
        if (points < 0 || points > 16) {
            return new int[]{-1, -1};
        }
        return pointsToUpperRanges[points];
    }

    public VentStatus(char name) {
        VentStatus.makePointsToRangeTable();
        this.ventName = name;
        this.movementDirection = 0;
        this.actualValue = 127;
        this.totalBoundStart = 30;
        this.totalBoundEnd = 70;
        this.setStartingRanges();
    }

    public VentStatus(VentStatus vent) {
        this.setEqualTo(vent);
    }

    public void doVMReset() {
        this.actualValue = 127;
        this.totalBoundStart = 0;
        this.totalBoundEnd = 100;
        this.setStartingRanges();
    }

    public void setEqualTo(VentStatus vent) {
        this.ventName = vent.ventName;
        this.actualValue = vent.actualValue;
        this.movementDirection = vent.movementDirection;
        this.lowerBoundStart = vent.lowerBoundStart;
        this.lowerBoundEnd = vent.lowerBoundEnd;
        this.upperBoundStart = vent.upperBoundStart;
        this.upperBoundEnd = vent.upperBoundEnd;
        this.totalBoundStart = vent.totalBoundStart;
        this.totalBoundEnd = vent.totalBoundEnd;
    }

    public int update(int actualValue, int direction) {
        int bitState = 0;
        int prevValue = this.actualValue;
        this.actualValue = actualValue;
        if (!this.isIdentified() && prevValue != 127) {
            bitState |= VentChangeStateFlag.RESET.bitFlag;
        }
        if (this.movementDirection != 0 && this.movementDirection != direction) {
            bitState |= VentChangeStateFlag.DIRECTION_CHANGE.bitFlag;
        }
        this.movementDirection = direction;
        if (this.isIdentified() || (bitState & VentChangeStateFlag.RESET.bitFlag) != 0) {
            this.lowerBoundStart = this.lowerBoundEnd = actualValue;
            this.upperBoundStart = this.upperBoundEnd = actualValue;
        }
        if (!this.isIdentified()) {
            return bitState;
        }
        int diff = Math.abs(this.actualValue - prevValue);
        if (diff == 1) {
            return bitState | VentChangeStateFlag.ONE_CHANGE.bitFlag;
        }
        if (diff == 2) {
            return bitState | VentChangeStateFlag.TWO_CHANGE.bitFlag;
        }
        if (diff > 2) {
            return bitState | VentChangeStateFlag.IDENTIFIED.bitFlag;
        }
        if (this.actualValue == 0 && this.movementDirection == -1) {
            return bitState;
        }
        if (this.actualValue == 100 && this.movementDirection == 1) {
            return bitState;
        }
        return bitState | VentChangeStateFlag.NO_CHANGE.bitFlag;
    }

    public void updateMovement(int[] outsideVentInfluence) {
        int startRangeMoveRate;
        int endRangeMoveRate;
        if (this.isIdentified()) {
            return;
        }
        int currentMinMoveRate = BASE_MOVE_RATE + outsideVentInfluence[0];
        int currentMaxMoveRate = BASE_MOVE_RATE + outsideVentInfluence[1];
        if (this.getDirection() > 0) {
            endRangeMoveRate = currentMaxMoveRate;
            startRangeMoveRate = currentMinMoveRate;
        } else {
            startRangeMoveRate = currentMaxMoveRate;
            endRangeMoveRate = currentMinMoveRate;
        }
        int totalBoundStartMove = Math.max(0, startRangeMoveRate + VentStatus.getMovementInfluenceOfValue(this.totalBoundStart)) * this.movementDirection;
        this.totalBoundStart = this.capVentValue(this.totalBoundStart + totalBoundStartMove);
        int totalBoundEndMove = Math.max(0, endRangeMoveRate + VentStatus.getMovementInfluenceOfValue(this.totalBoundEnd)) * this.movementDirection;
        this.totalBoundEnd = this.capVentValue(this.totalBoundEnd + totalBoundEndMove);
        if (!this.isRangeDefined()) {
            return;
        }
        int lowerStart = this.getLowerBoundStart();
        int lowerStartMove = Math.max(0, startRangeMoveRate + VentStatus.getMovementInfluenceOfValue(lowerStart)) * this.movementDirection;
        int upperEnd = this.getUpperBoundEnd();
        int upperEndMove = Math.max(0, endRangeMoveRate + VentStatus.getMovementInfluenceOfValue(upperEnd)) * this.movementDirection;
        int lowerEnd = this.getLowerBoundEnd();
        int lowerEndMove = Math.max(0, endRangeMoveRate + VentStatus.getMovementInfluenceOfValue(lowerEnd)) * this.movementDirection;
        int upperStart = this.getUpperBoundStart();
        int upperStartMove = Math.max(0, startRangeMoveRate + VentStatus.getMovementInfluenceOfValue(upperStart)) * this.movementDirection;
        this.clearRanges();
        this.setLowerBoundRange(lowerStart + lowerStartMove, lowerEnd + lowerEndMove);
        this.setUpperBoundRange(upperStart + upperStartMove, upperEnd + upperEndMove);
    }

    public void clearRanges() {
        this.lowerBoundEnd = 127;
        this.lowerBoundStart = 127;
        this.upperBoundEnd = 127;
        this.upperBoundStart = 127;
    }

    public boolean canLowerBoundMergeWith(int start, int end) {
        return this.isLowerBoundWithinRange(start - 1, end + 1);
    }

    public boolean canUpperBoundMergeWith(int start, int end) {
        return this.isUpperBoundWithinRange(start - 1, end + 1);
    }

    public void mergeLowerBoundRanges(int start, int end) {
        this.lowerBoundStart = Math.min(this.lowerBoundStart, this.capVentValue(start));
        this.lowerBoundEnd = Math.max(this.lowerBoundEnd, this.capVentValue(end));
    }

    public void mergeUpperBoundRanges(int start, int end) {
        this.upperBoundStart = Math.min(this.upperBoundStart, this.capVentValue(start));
        this.upperBoundEnd = Math.max(this.upperBoundEnd, this.capVentValue(end));
    }

    public void setLowerBoundRange(int start, int end) {
        this.lowerBoundStart = this.capVentValue(start);
        this.lowerBoundEnd = this.capVentValue(end);
        if (this.canUpperBoundMergeWith(this.lowerBoundStart, this.lowerBoundEnd)) {
            this.mergeUpperBoundRanges(this.lowerBoundStart, this.lowerBoundEnd);
            this.mergeLowerBoundRanges(this.upperBoundStart, this.upperBoundEnd);
        }
    }

    public void setUpperBoundRange(int start, int end) {
        this.upperBoundStart = this.capVentValue(start);
        this.upperBoundEnd = this.capVentValue(end);
        if (this.canLowerBoundMergeWith(this.upperBoundStart, this.upperBoundEnd)) {
            this.mergeUpperBoundRanges(this.lowerBoundStart, this.lowerBoundEnd);
            this.mergeLowerBoundRanges(this.upperBoundStart, this.upperBoundEnd);
        }
    }

    public void doInnerBoundsClipping(int start, int end) {
        if (this.isIdentified()) {
            return;
        }
        if (!this.isRangeDefined()) {
            return;
        }
        int[] lower = this.getOverlappedLowerBoundRange(start, end);
        int[] upper = this.getOverlappedUpperBoundRange(start, end);
        boolean isLowerBoundClipped = lower[0] == -1 && lower[1] == -1;
        boolean isUpperBoundClipped = upper[0] == -1 && upper[1] == -1;
        this.clearRanges();
        if (isLowerBoundClipped && isUpperBoundClipped) {
            return;
        }
        if (isLowerBoundClipped) {
            this.setUpperBoundRange(upper[0], upper[1]);
            this.setLowerBoundRange(upper[0], upper[1]);
        } else if (isUpperBoundClipped) {
            this.setUpperBoundRange(lower[0], lower[1]);
            this.setLowerBoundRange(lower[0], lower[1]);
        } else {
            this.setUpperBoundRange(upper[0], upper[1]);
            this.setLowerBoundRange(lower[0], lower[1]);
        }
    }

    public void doOuterBoundsClipping(int start, int end) {
        if (this.isIdentified()) {
            return;
        }
        if (!this.isRangeDefined()) {
            return;
        }
        if (this.doOuterBoundsSingleRangeClipping(start, end)) {
            return;
        }
        int[] lower = this.getOutsideLowerBoundRange(start, end);
        int[] upper = this.getOutsideUpperBoundRange(start, end);
        boolean isLowerBoundClipped = lower[0] == -1 && lower[1] == -1;
        boolean isUpperBoundClipped = upper[0] == -1 && upper[1] == -1;
        this.clearRanges();
        if (isLowerBoundClipped && isUpperBoundClipped) {
            return;
        }
        if (isLowerBoundClipped) {
            this.setUpperBoundRange(upper[0], upper[1]);
            this.setLowerBoundRange(upper[0], upper[1]);
        } else if (isUpperBoundClipped) {
            this.setUpperBoundRange(lower[0], lower[1]);
            this.setLowerBoundRange(lower[0], lower[1]);
        } else {
            this.setUpperBoundRange(upper[0], upper[1]);
            this.setLowerBoundRange(lower[0], lower[1]);
        }
    }

    private boolean doOuterBoundsSingleRangeClipping(int start, int end) {
        if (this.isTwoSeperateValues()) {
            return false;
        }
        int upperBoundEnd = this.getUpperBoundEnd();
        int lowerBoundStart = this.getLowerBoundStart();
        if (start > upperBoundEnd) {
            return false;
        }
        if (end < lowerBoundStart) {
            return false;
        }
        this.clearRanges();
        if (start <= lowerBoundStart && end >= upperBoundEnd) {
            return true;
        }
        int maxStart = Math.max(start - 1, lowerBoundStart);
        int minEnd = Math.min(end + 1, upperBoundEnd);
        if (start <= lowerBoundStart || end >= upperBoundEnd) {
            if (start <= lowerBoundStart) {
                this.setUpperBoundRange(minEnd, upperBoundEnd);
                this.setLowerBoundRange(minEnd, upperBoundEnd);
            }
            if (end >= upperBoundEnd) {
                this.setUpperBoundRange(lowerBoundStart, maxStart);
                this.setLowerBoundRange(lowerBoundStart, maxStart);
            }
        } else {
            this.setUpperBoundRange(minEnd, upperBoundEnd);
            this.setLowerBoundRange(lowerBoundStart, maxStart);
        }
        return true;
    }

    public void flipDirection() {
        this.movementDirection *= -1;
    }

    public boolean isIdentified() {
        return this.actualValue != 127;
    }

    public boolean isRangeDefined() {
        if (this.lowerBoundStart == 127 || this.lowerBoundEnd == 127) {
            return false;
        }
        return this.upperBoundStart != 127 && this.upperBoundEnd != 127;
    }

    public boolean isTwoSeperateValues() {
        return this.lowerBoundStart != this.upperBoundStart || this.lowerBoundEnd != this.upperBoundEnd;
    }

    public boolean isLowerBoundSingleValue() {
        return this.lowerBoundStart == this.lowerBoundEnd;
    }

    public boolean isUpperBoundSingleValue() {
        return this.upperBoundStart == this.upperBoundEnd;
    }

    public boolean isLowerBoundWithinRange(int start, int end) {
        return start <= this.lowerBoundEnd && end >= this.lowerBoundStart;
    }

    public boolean isUpperBoundWithinRange(int start, int end) {
        return start <= this.upperBoundEnd && end >= this.upperBoundStart;
    }

    public boolean isWithinRange(int start, int end) {
        if (this.isLowerBoundWithinRange(start, end)) {
            return true;
        }
        if (this.isTwoSeperateValues()) {
            return this.isUpperBoundWithinRange(start, end);
        }
        return false;
    }

    public int[] getOverlappedLowerBoundRange(int start, int end) {
        if (!this.isLowerBoundWithinRange(start, end)) {
            return new int[]{-1, -1};
        }
        int maxStart = Math.max(this.getLowerBoundStart(), start);
        int minEnd = Math.min(this.getLowerBoundEnd(), end);
        return new int[]{maxStart, minEnd};
    }

    public int[] getOutsideLowerBoundRange(int start, int end) {
        int newStart = this.lowerBoundStart;
        int newEnd = this.lowerBoundEnd;
        if (!this.isLowerBoundWithinRange(start, end)) {
            return new int[]{newStart, newEnd};
        }
        if (this.lowerBoundStart >= start && this.lowerBoundStart <= end) {
            newStart = end + 1;
        }
        if (this.lowerBoundEnd >= start && this.lowerBoundEnd <= end) {
            newEnd = start - 1;
        }
        if (newStart > newEnd) {
            return new int[]{-1, -1};
        }
        return new int[]{newStart, newEnd};
    }

    public int[] getOverlappedUpperBoundRange(int start, int end) {
        if (!this.isUpperBoundWithinRange(start, end)) {
            return new int[]{-1, -1};
        }
        int maxStart = Math.max(this.getUpperBoundStart(), start);
        int minEnd = Math.min(this.getUpperBoundEnd(), end);
        return new int[]{maxStart, minEnd};
    }

    public int[] getOutsideUpperBoundRange(int start, int end) {
        int newStart = this.upperBoundStart;
        int newEnd = this.upperBoundEnd;
        if (!this.isUpperBoundWithinRange(start, end)) {
            return new int[]{newStart, newEnd};
        }
        if (this.upperBoundStart >= start && this.upperBoundStart <= end) {
            newStart = end + 1;
        }
        if (this.upperBoundEnd >= start && this.upperBoundEnd <= end) {
            newEnd = start - 1;
        }
        if (newStart > newEnd) {
            return new int[]{-1, -1};
        }
        return new int[]{newStart, newEnd};
    }

    public int getEstimatedInfluence() {
        if (!this.isRangeDefined()) {
            return -1;
        }
        if (this.isWithinRange(41, 59)) {
            return -1;
        }
        return 0;
    }

    public void updateEstimatedMovementInfluence(int[] currentInf) {
        int maxInf;
        int minInf;
        if (!this.isRangeDefined()) {
            minInf = -1;
            maxInf = 0;
        } else {
            boolean canNotInfluence;
            boolean canInfluence = this.isWithinRange(41, 59);
            boolean bl = canNotInfluence = this.isWithinRange(0, 40) || this.isWithinRange(60, 100);
            if (canInfluence && canNotInfluence) {
                minInf = -1;
                maxInf = 0;
            } else if (canInfluence) {
                maxInf = -1;
                minInf = -1;
            } else if (canNotInfluence) {
                maxInf = 0;
                minInf = 0;
            } else {
                minInf = -1;
                maxInf = 0;
            }
        }
        currentInf[0] = currentInf[0] + minInf;
        currentInf[1] = currentInf[1] + maxInf;
    }

    public int getReversedInfluence(int outsideVentInfluence) {
        if (outsideVentInfluence < -1) {
            return this.isIdentified() ? VentStatus.getMovementInfluenceOfValue(this.capVentValue(this.actualValue)) : 0;
        }
        if (!this.isIdentified()) {
            return 127;
        }
        if (this.isBounded()) {
            return 127;
        }
        int[] infPossibilities = new int[BASE_MOVE_RATE];
        for (int i = 0; i < BASE_MOVE_RATE; ++i) {
            int move = (outsideVentInfluence + (BASE_MOVE_RATE - i)) * this.movementDirection;
            infPossibilities[i] = VentStatus.getMovementInfluenceOfValue(this.capVentValue(this.actualValue - move));
        }
        if (infPossibilities[0] != infPossibilities[1]) {
            return 127;
        }
        return VentStatus.getMovementInfluenceOfValue(this.capVentValue(this.actualValue - this.movementDirection));
    }

    public void doReversedMovement(int outsideVentInfluence) {
        if (!this.isIdentified()) {
            return;
        }
        int currentMoveRate = Math.max(0, BASE_MOVE_RATE + outsideVentInfluence);
        this.lowerBoundStart = this.lowerBoundEnd = (this.actualValue = this.capVentValue(this.actualValue - currentMoveRate * this.movementDirection));
        this.upperBoundStart = this.upperBoundEnd = this.actualValue;
    }

    public int getStabilityInfluence() {
        if (!this.isIdentified()) {
            return 0;
        }
        return VentStatus.getStabilityInfluence(this.actualValue);
    }

    public boolean isBounded() {
        return this.actualValue == 100 || this.actualValue == 0;
    }

    private int capVentValue(int value) {
        return Math.min(100, Math.max(0, value));
    }

    private void setStartingRanges() {
        this.clearRanges();
        this.setLowerBoundRange(this.totalBoundStart, this.totalBoundEnd);
        this.setUpperBoundRange(this.totalBoundStart, this.totalBoundEnd);
    }

    public char getName() {
        return this.ventName;
    }

    public int getActualValue() {
        return this.actualValue;
    }

    public int getDirection() {
        return this.movementDirection;
    }

    public int getLowerBoundStart() {
        return this.lowerBoundStart;
    }

    public int getLowerBoundEnd() {
        return this.lowerBoundEnd;
    }

    public int getUpperBoundStart() {
        return this.upperBoundStart;
    }

    public int getUpperBoundEnd() {
        return this.upperBoundEnd;
    }

    public int getTotalBoundStart() {
        return this.totalBoundStart;
    }

    public int getTotalBoundEnd() {
        return this.totalBoundEnd;
    }

    public static enum VentChangeStateFlag {
        IDENTIFIED(1),
        NO_CHANGE(2),
        ONE_CHANGE(4),
        TWO_CHANGE(8),
        DIRECTION_CHANGE(16),
        RESET(32);

        private final int bitFlag;

        private VentChangeStateFlag(int bitFlag) {
            this.bitFlag = bitFlag;
        }

        int bitFlag() {
            return this.bitFlag;
        }
    }
}

