/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.UltimateVolcanicMineConfig;
import java.util.HashMap;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.client.Notifier;

public class VMNotifier {
    public static final int NOTIFICATION_START_COOLDOWN_TICKS = 10;
    @Inject
    private UltimateVolcanicMineConfig config;
    private HashSet<NotificationEvents> oneTimeEvents = new HashSet();
    private HashMap<NotificationEvents, Integer> continousEvents = new HashMap();

    @Inject
    VMNotifier(UltimateVolcanicMineConfig config) {
        this.config = config;
        this.reset();
    }

    private void setOneTimeEvents() {
        this.oneTimeEvents.add(NotificationEvents.VM_PLAYER_LEAVE);
        this.oneTimeEvents.add(NotificationEvents.VM_EXTRA_PLAYER);
        this.oneTimeEvents.add(NotificationEvents.VM_RESET);
        this.oneTimeEvents.add(NotificationEvents.VM_ERUPTION);
        this.oneTimeEvents.add(NotificationEvents.VM_PRE_RESET_VENT_FIX);
        this.oneTimeEvents.add(NotificationEvents.VM_PREDICTED_VENT_FIX);
        this.oneTimeEvents.add(NotificationEvents.VM_PICKAXE_DESPAWN);
        this.oneTimeEvents.add(NotificationEvents.VM_PICKAXE_LOW_STABILITY);
        this.oneTimeEvents.add(NotificationEvents.VM_PICKAXE_BOULDER_COMPLETE);
    }

    private void setContinousEvents() {
        this.continousEvents.put(NotificationEvents.VM_PICKAXE_DESPAWN, 0);
    }

    public void reset() {
        this.setOneTimeEvents();
        this.setContinousEvents();
    }

    public void removeEvent(NotificationEvents event) {
        this.oneTimeEvents.remove((Object)event);
    }

    public void notify(Notifier notifier, NotificationEvents event, int ticksPassed) {
        if (!this.oneTimeEvents.contains((Object)event)) {
            return;
        }
        if (event == NotificationEvents.VM_EXTRA_PLAYER) {
            if (!this.config.extraPlayerNotifier()) {
                return;
            }
            notifier.notify("An extra player has joined your team!");
            this.oneTimeEvents.remove((Object)event);
        }
        if (ticksPassed <= 10) {
            return;
        }
        switch (event) {
            case VM_PLAYER_LEAVE: {
                this.oneTimeEvents.remove((Object)event);
                if (!this.config.playerLeaveNotifier()) {
                    return;
                }
                notifier.notify("A player has left the mine!");
                break;
            }
            case VM_RESET: {
                this.oneTimeEvents.remove((Object)event);
                if (!this.config.showVentWarning()) {
                    return;
                }
                notifier.notify("The vents will shift in " + this.config.ventWarningTime() + " seconds!");
                break;
            }
            case VM_ERUPTION: {
                this.oneTimeEvents.remove((Object)event);
                if (!this.config.showEruptionWarning()) {
                    return;
                }
                notifier.notify("The volcano will erupt in " + this.config.eruptionWarningTime() + " seconds!");
                break;
            }
            case VM_PRE_RESET_VENT_FIX: {
                this.oneTimeEvents.remove((Object)event);
                if (!this.config.ventFixNotifier()) {
                    return;
                }
                notifier.notify("Fix your vent!");
                break;
            }
            case VM_PREDICTED_VENT_FIX: {
                this.oneTimeEvents.remove((Object)event);
                if (!this.config.predictedVentFixNotifier()) {
                    return;
                }
                notifier.notify("Be alert you might have to fix your vent soon!");
                break;
            }
            case VM_PICKAXE_DESPAWN: {
                int lastEventTime = this.continousEvents.get((Object)NotificationEvents.VM_PICKAXE_DESPAWN);
                if (lastEventTime + 10 >= ticksPassed) break;
                notifier.notify("Be careful your pickaxe will despawn soon!");
                this.continousEvents.put(NotificationEvents.VM_PICKAXE_DESPAWN, ticksPassed);
                break;
            }
            case VM_PICKAXE_LOW_STABILITY: {
                this.oneTimeEvents.remove((Object)event);
                notifier.notify("Mine Stability is low don't forget your pickaxe!");
                break;
            }
            case VM_PICKAXE_BOULDER_COMPLETE: {
                this.oneTimeEvents.remove((Object)event);
                notifier.notify("You finished the boulder, pick up your pickaxe!");
                break;
            }
        }
    }

    public static enum NotificationEvents {
        VM_PLAYER_LEAVE,
        VM_EXTRA_PLAYER,
        VM_RESET,
        VM_ERUPTION,
        VM_PRE_RESET_VENT_FIX,
        VM_PREDICTED_VENT_FIX,
        VM_PICKAXE_DESPAWN,
        VM_PICKAXE_LOW_STABILITY,
        VM_PICKAXE_BOULDER_COMPLETE;

    }
}

