/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.google.inject.Provides;
import com.ultimatevm.CapCounter;
import com.ultimatevm.CapCounterInfoBox;
import com.ultimatevm.PickaxeProtector;
import com.ultimatevm.StabilityTracker;
import com.ultimatevm.StabilityUpdateInfo;
import com.ultimatevm.TimedObject;
import com.ultimatevm.TimedObjectOverlay;
import com.ultimatevm.TimedObjectTracker;
import com.ultimatevm.UltimateVolcanicMineConfig;
import com.ultimatevm.VMNotifier;
import com.ultimatevm.VentStatusPredicter;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ultimate Volcanic Mine")
public class UltimateVolcanicMinePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UltimateVolcanicMinePlugin.class);
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private UltimateVolcanicMineConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TimedObjectOverlay timedObjectOverlay;
    private static final int PROC_VOLCANIC_MINE_SET_OTHERINFO = 2022;
    private static final int VARBIT_STABILITY = 5938;
    private static final int VARBIT_GAME_STATE = 5941;
    private static final int VARBIT_TIME_REMAINING = 5944;
    private static final int VARBIT_VENT_STATUS_A = 5939;
    private static final int VARBIT_VENT_STATUS_B = 5940;
    private static final int VARBIT_VENT_STATUS_C = 5942;
    private static final int VARBIT_CHAMBER_STATUS = 5936;
    private static final int VARBIT_POINTS = 5934;
    private static final int VARBIT_PLAYER_COUNT = 5937;
    private static final int HUD_STABILITY_COMPONENT = 11;
    private static final int HUD_VENT_A_PERCENTAGE = 17;
    private static final int HUD_VENT_B_PERCENTAGE = 18;
    private static final int HUD_VENT_C_PERCENTAGE = 19;
    private static final int VM_GAME_STATE_NONE = 0;
    private static final int VM_GAME_STATE_IN_LOBBY = 1;
    private static final int VM_GAME_STATE_IN_GAME = 2;
    private static final int VM_REGION_NORTH = 15263;
    private static final int VM_REGION_SOUTH = 15262;
    private static final int GAME_OBJ_CHAMBER_BLOCKED = 31044;
    private static final int GAME_OBJ_CHAMBER_UNBLOCKED = 31043;
    private static final int GAME_OBJ_TAKEN_ROCK = 31046;
    private static final int GAME_OBJ_ROCK = 31045;
    private static final int VM_EXIT_TIME = 50;
    private static final int VM_LOBBY_TIME = 50;
    private static final float SECONDS_TO_TICKS = 1.666f;
    private VentStatusPredicter ventStatusPredicter = new VentStatusPredicter();
    private StabilityTracker stabilityTracker = new StabilityTracker();
    private StabilityTracker futureStabilityTracker = new StabilityTracker();
    private VMNotifier VM_notifier;
    private CapCounter capCounter = new CapCounter();
    private TimedObjectTracker timedObjectTracker = new TimedObjectTracker();
    private CapCounterInfoBox capInfoBox;
    private PickaxeProtector pickaxeProtector;
    private HashMap<Integer, Tile> rockTiles = new HashMap();
    private int vmGameState = 0;
    private int timeRemainingFromServer;
    private int estimatedTimeRemaining;
    private int eruptionTime;
    private int ventWarningTime;
    private int maxPlayerCount;
    private int ticksSinceLobbyStart;
    private static final String PLATFORM_WARNING_MESSAGE = "The platform beneath you will disappear soon!";
    private static final String BOULDER_WARNING_MESSAGE = "The current boulder stage is complete.";
    private static final int PLATFORM_STAGE_3_ID = 31000;
    private static final int PLATFORM_STAGE_1_ID = 30998;
    private static final int BOULDER_BREAK_STAGE_1_ID = 7807;
    private static final int BOULDER_BREAK_STAGE_2_ID = 7809;
    private static final int BOULDER_BREAK_STAGE_3_ID = 7811;
    private static final int BOULDER_BREAK_STAGE_4_ID = 7813;
    private static final int BOULDER_BREAK_STAGE_5_ID = 7815;

    @Provides
    UltimateVolcanicMineConfig provideConfig(ConfigManager configManager) {
        return (UltimateVolcanicMineConfig)configManager.getConfig(UltimateVolcanicMineConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.eruptionTime = (int)((float)this.config.eruptionWarningTime() * 1.666f);
        this.ventWarningTime = (int)((float)this.config.ventWarningTime() * 1.666f);
        this.stabilityTracker.setDisplayCount(this.config.stabilityUpdateHistoryCount());
        this.futureStabilityTracker.setDisplayCount(this.config.predictedStabilityChangeHistoryCount());
        this.infoBoxManager.removeInfoBox((InfoBox)this.capInfoBox);
        if (this.config.capCounter() && this.capCounter.getTimesCapped() >= 1) {
            this.infoBoxManager.addInfoBox((InfoBox)this.capInfoBox);
        }
        this.overlayManager.remove((Overlay)this.timedObjectOverlay);
        if (this.config.rockTimer() || this.config.platformTimer()) {
            this.overlayManager.add((Overlay)this.timedObjectOverlay);
        }
    }

    protected void startUp() throws Exception {
        this.VM_notifier = new VMNotifier(this.config);
        this.pickaxeProtector = new PickaxeProtector(this.client);
        this.stabilityTracker.setDisplayCount(this.config.stabilityUpdateHistoryCount());
        this.futureStabilityTracker.setDisplayCount(this.config.predictedStabilityChangeHistoryCount());
        this.capInfoBox = new CapCounterInfoBox(this.capCounter, this);
        this.timedObjectOverlay.setRockTracker(this.timedObjectTracker);
        this.overlayManager.add((Overlay)this.timedObjectOverlay);
        this.eruptionTime = (int)((float)this.config.eruptionWarningTime() * 1.666f);
        this.ventWarningTime = (int)((float)this.config.ventWarningTime() * 1.666f);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.timedObjectOverlay);
        this.infoBoxManager.removeInfoBox((InfoBox)this.capInfoBox);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (!this.isInVM()) {
            return;
        }
        this.vmGameState = this.client.getVarbitValue(5941);
        if (this.vmGameState == 1) {
            this.stabilityTracker.initialize();
            this.ventStatusPredicter.initialize();
            this.futureStabilityTracker.initialize();
            this.stabilityTracker.setDisplayCount(this.config.stabilityUpdateHistoryCount());
            this.futureStabilityTracker.setDisplayCount(this.config.predictedStabilityChangeHistoryCount());
            this.resetGameVariables();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        int futureChange;
        int requiredDroppedTicks;
        int newTimeRemaining;
        if (!this.isInVM()) {
            this.vmGameState = 0;
            StabilityUpdateInfo.resetPlayers();
            this.infoBoxManager.removeInfoBox((InfoBox)this.capInfoBox);
            this.resetGameVariables();
            return;
        }
        if (this.maxPlayerCount > this.config.expectedTeamSize()) {
            this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_EXTRA_PLAYER, this.ventStatusPredicter.getCurrentTick());
        }
        this.estimatedTimeRemaining = (newTimeRemaining = this.client.getVarbitValue(5944)) != this.timeRemainingFromServer ? (this.timeRemainingFromServer = newTimeRemaining) : --this.estimatedTimeRemaining;
        this.pickaxeProtector.getStartingPickaxes();
        if (this.pickaxeProtector.isPickaxeDropped()) {
            this.pickaxeProtector.incrementTicksDropped();
        } else {
            this.pickaxeProtector.resetTicksDropped();
        }
        if (this.config.pickaxeDespawnProtection() && (requiredDroppedTicks = (int)((float)this.config.pickaxeDespawnProtectionStartTime() * 1.666f)) <= this.pickaxeProtector.getNumTicksPickaxeDropped()) {
            this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_PICKAXE_DESPAWN, this.ticksSinceLobbyStart);
        }
        ++this.ticksSinceLobbyStart;
        if (!this.hasGameStarted()) {
            return;
        }
        StabilityUpdateInfo.setNumPlayers(this.client.getVarbitValue(5937));
        this.timedObjectTracker.updateRockTimers();
        this.updateVentStatus(this.client.getVarbitValue(5939), this.client.getVarbitValue(5940), this.client.getVarbitValue(5942), this.client.getVarbitValue(5936));
        if (this.ventStatusPredicter.isMovementUpdateTick() && (futureChange = this.ventStatusPredicter.getFutureStabilityChange(this.config.predictedVentFixScenario())) != 127) {
            this.futureStabilityTracker.addChange(futureChange);
            if (this.futureStabilityTracker.isFutureStabilityBad(this.config.predictedStabilityChange())) {
                int startTime = 900 - (int)((float)this.config.predictedventWarningStartTime() * 1.666f);
                int endTime = 600 + (int)((float)this.config.predictedventWarningEndTime() * 1.666f);
                if (this.estimatedTimeRemaining < startTime && this.estimatedTimeRemaining > endTime) {
                    this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_PREDICTED_VENT_FIX, this.ventStatusPredicter.getCurrentTick());
                }
            }
        }
        if (this.updateStability(this.client.getVarbitValue(5938))) {
            if (this.config.ventStatusUpdateHistory()) {
                Widget widget = this.client.getWidget(611, 17);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "CyanWarrior4: ", this.ventStatusPredicter.getVentStatusText(0, widget.getText()), null);
                widget = this.client.getWidget(611, 18);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "CyanWarrior4: ", this.ventStatusPredicter.getVentStatusText(1, widget.getText()), null);
                widget = this.client.getWidget(611, 19);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "CyanWarrior4: ", this.ventStatusPredicter.getVentStatusText(2, widget.getText()), null);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "CyanWarrior4: ", "Stability Update: " + this.stabilityTracker.getCurrentChange(), null);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "CyanWarrior4: ", "Time: " + this.estimatedTimeRemaining, null);
            }
            if (this.stabilityTracker.getCurrentChange() < 0 && this.estimatedTimeRemaining > 595) {
                this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_PRE_RESET_VENT_FIX, this.ventStatusPredicter.getCurrentTick());
            }
        }
        if (this.ventStatusPredicter.getCurrentTick() > 10 && this.timeRemainingFromServer <= 500) {
            this.stabilityTracker.resetStabilityHistory();
            this.futureStabilityTracker.resetStabilityHistory();
        }
        int currentTick = this.ventStatusPredicter.getCurrentTick();
        if (this.estimatedTimeRemaining <= 500 + this.ventWarningTime) {
            this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_RESET, currentTick);
        }
        if (this.estimatedTimeRemaining <= this.eruptionTime) {
            this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_ERUPTION, currentTick);
        }
        this.ventStatusPredicter.getTimeline().updateTick();
        if (this.ventStatusPredicter.getCurrentTick() > 500) {
            this.ventStatusPredicter.reset();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMsg = Text.removeTags((String)event.getMessage());
        if (chatMsg.equals("A sudden earthquake strikes the cavern!")) {
            this.ventStatusPredicter.markEarthquakeEvent();
        }
    }

    public boolean updateStability(int newStability) {
        if (this.config.lowStabilityPickaxeLeaveProtection() && newStability <= this.config.pickaxeLeaveStabilityAmount() && this.pickaxeProtector.isPickaxeDropped()) {
            this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_PICKAXE_LOW_STABILITY, this.ventStatusPredicter.getCurrentTick());
        }
        if (this.stabilityTracker.updateStability(newStability)) {
            this.ventStatusPredicter.makeStatusState(this.stabilityTracker.getCurrentChange());
            return true;
        }
        return false;
    }

    public void updateVentStatus(int ventA, int ventB, int ventC, int chamberStatus) {
        this.ventStatusPredicter.updateVentStatus(new int[]{ventA, ventB, ventC}, chamberStatus);
    }

    public final VentStatusPredicter getVentStatusPredicter() {
        return this.ventStatusPredicter;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.isInVM()) {
            return;
        }
        if (event.getVarbitId() == 5937) {
            this.maxPlayerCount = Math.max(this.maxPlayerCount, this.client.getVarbitValue(5937));
        }
        if (!this.hasGameStarted()) {
            return;
        }
        if (event.getVarbitId() == 5937) {
            if (this.estimatedTimeRemaining <= 50) {
                return;
            }
            this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_PLAYER_LEAVE, this.ventStatusPredicter.getCurrentTick());
        }
        if (event.getVarbitId() == 5934) {
            int playerX = this.client.getLocalPlayer().getWorldLocation().getX();
            int playerY = this.client.getLocalPlayer().getWorldLocation().getY();
            if (this.capCounter.updateScore(this.client.getVarbitValue(5934), playerX, playerY) && this.capCounter.getTimesCapped() == 1) {
                this.infoBoxManager.addInfoBox((InfoBox)this.capInfoBox);
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 2022) {
            return;
        }
        Widget widget = this.client.getWidget(611, 11);
        if (this.config.stabilityUpdateHistoryCount() > 0 && widget != null) {
            widget.setText(widget.getText() + this.stabilityTracker.getStabilityText());
        }
        if ((widget = this.client.getWidget(611, 10)) != null) {
            if (this.config.predictedStabilityChangeHistoryCount() > 0) {
                widget.setText("Stab." + this.futureStabilityTracker.getStabilityText());
            } else {
                widget.setText("Stability");
            }
        }
        if (this.config.ventStatusPrediction()) {
            widget = this.client.getWidget(611, 17);
            if (widget != null) {
                widget.setText(this.ventStatusPredicter.getVentStatusText(0, widget.getText()));
            }
            if ((widget = this.client.getWidget(611, 18)) != null) {
                widget.setText(this.ventStatusPredicter.getVentStatusText(1, widget.getText()));
            }
            if ((widget = this.client.getWidget(611, 19)) != null) {
                widget.setText(this.ventStatusPredicter.getVentStatusText(2, widget.getText()));
            }
        }
    }

    @Subscribe
    void onGameObjectDespawned(GameObjectDespawned event) {
        int gameObjectId = event.getGameObject().getId();
        if (gameObjectId == 31045) {
            this.timedObjectTracker.addObject(event.getGameObject().getWorldLocation(), TimedObject.ObjectType.ROCK);
        }
    }

    private void resetGameVariables() {
        this.VM_notifier.reset();
        this.capCounter.initialize();
        this.timedObjectTracker.clearRocks();
        this.pickaxeProtector.resetStartingPickaxes();
        this.timeRemainingFromServer = 0;
        this.estimatedTimeRemaining = 0;
        this.maxPlayerCount = 0;
        this.ticksSinceLobbyStart = 0;
    }

    private boolean hasGameStarted() {
        if (this.vmGameState >= 2) {
            return true;
        }
        return this.estimatedTimeRemaining > 50;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (!this.isInVM()) {
            return;
        }
        int gameObjectId = event.getGameObject().getId();
        int playerX = this.client.getLocalPlayer().getWorldLocation().getX();
        int playerY = this.client.getLocalPlayer().getWorldLocation().getY();
        int objectX = event.getGameObject().getWorldLocation().getX();
        int objectY = event.getGameObject().getWorldLocation().getY();
        if (gameObjectId == 31044 || gameObjectId == 31043) {
            objectX = event.getGameObject().getWorldLocation().getX();
            objectY = event.getGameObject().getWorldLocation().getY();
            this.capCounter.addCappingPositions(objectX, objectY);
        }
        if (gameObjectId == 30998) {
            this.timedObjectTracker.addObject(event.getGameObject().getWorldLocation(), TimedObject.ObjectType.PLATFORM);
        }
        if (gameObjectId == 31000) {
            if (!this.config.showPlatformWarning()) {
                return;
            }
            if (playerX == objectX && playerY == objectY) {
                this.notifier.notify(PLATFORM_WARNING_MESSAGE);
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (!this.isInVM()) {
            return;
        }
        NPC npc = npcSpawned.getNpc();
        switch (npc.getId()) {
            case 7815: {
                if (this.config.boulderFinishPickaxeLeaveProtection() && this.pickaxeProtector.isPickaxeDropped()) {
                    this.VM_notifier.notify(this.notifier, VMNotifier.NotificationEvents.VM_PICKAXE_BOULDER_COMPLETE, this.ventStatusPredicter.getCurrentTick());
                }
                this.VM_notifier.removeEvent(VMNotifier.NotificationEvents.VM_PLAYER_LEAVE);
            }
            case 7807: 
            case 7809: 
            case 7811: 
            case 7813: {
                if (!this.config.showBoulderWarning()) break;
                this.notifier.notify(BOULDER_WARNING_MESSAGE);
                break;
            }
        }
    }

    private boolean isInVM() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        LocalPoint localPoint = player.getLocalLocation();
        if (localPoint == null) {
            return false;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        if (worldPoint == null) {
            return false;
        }
        int currentRegionID = worldPoint.getRegionID();
        return currentRegionID == 15263 || currentRegionID == 15262;
    }
}

