/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="ultimate-volcanic-mine")
public interface UltimateVolcanicMineConfig
extends Config {
    @ConfigSection(name="Display", description="All the options for how your interface to look", position=0, closedByDefault=false)
    public static final String display = "display";
    @ConfigSection(name="Timing", description="Options on how to display timed objects", position=1, closedByDefault=false)
    public static final String timing = "timing";
    @ConfigSection(name="Notifications", description="All the options for how you want to customize your notifications", position=2, closedByDefault=false)
    public static final String notifications = "notifications";
    @ConfigSection(name="Predicted Pre Reset Fix", description="Options for customizing your predicted vent fix", position=3, closedByDefault=false)
    public static final String preresetfix = "predicted pre reset fix";
    @ConfigSection(name="Pickaxe Protection", description="Options for customizing your predicted vent fix", position=4, closedByDefault=true)
    public static final String pickaxeprotection = "pickaxe protection";
    @ConfigSection(name="Team Size Manager", description="Notifications for any unexpected team size changes", position=5, closedByDefault=true)
    public static final String teamSize = "team size";

    @ConfigItem(position=1, keyName="capCounter", name="Cap counter", description="Displays an infobox with the total vents capped", section="display")
    default public boolean capCounter() {
        return true;
    }

    @ConfigItem(keyName="stabilityUpdateHistoryCount", name="Stability Update History", description="The number of stability updates to track", position=2, section="display")
    @Range(max=3, min=0)
    default public int stabilityUpdateHistoryCount() {
        return 3;
    }

    @ConfigItem(keyName="predictedStabilityChangeHistoryCount", name="Predicted Stability Change History", description="The number of predicted stability changes to track", position=3, section="display")
    @Range(max=3, min=0)
    default public int predictedStabilityChangeHistoryCount() {
        return 1;
    }

    @ConfigItem(position=4, keyName="ventStatusUpdateHistory", name="Vent Status Update History", description="Sends a chat message with the vent status for each stability update", section="display")
    default public boolean ventStatusUpdateHistory() {
        return false;
    }

    @ConfigItem(position=5, keyName="ventStatusPrediction", name="Vent Status Prediction", description="Displays estimates for missing vents", section="display")
    default public boolean ventStatusPrediction() {
        return true;
    }

    @ConfigItem(position=0, keyName="rockTimer", name="Rock Timer", description="Shows a respawn timer when a rock is taken", section="timing")
    default public boolean rockTimer() {
        return true;
    }

    @ConfigItem(keyName="rockRenderMode", name="Rock Render Mode", description="How the rock respawn timer is rendered", position=1, section="timing")
    default public TimingRenderMode rockRenderMode() {
        return TimingRenderMode.PROGRESS_PIE;
    }

    @ConfigItem(position=2, keyName="platformTimer", name="Platform Timer", description="Shows a despawn timer when a platform is made", section="timing")
    default public boolean platformTimer() {
        return false;
    }

    @ConfigItem(keyName="platformRenderMode", name="Platform Render Mode", description="How the platform despawn timer is rendered", position=3, section="timing")
    default public TimingRenderMode platformRenderMode() {
        return TimingRenderMode.NUMBER;
    }

    @ConfigItem(keyName="numberThreshold", name="Platform Number Threshold", description="Maximum number to display when a platform is up", position=4, section="timing")
    @Range(max=150, min=0)
    default public int numberThreshold() {
        return 25;
    }

    @ConfigItem(keyName="ventWarning", name="Vent Shift Notification", description="Show warning in advance of vents resetting 5 minutes into game", position=0, section="notifications")
    default public boolean showVentWarning() {
        return true;
    }

    @ConfigItem(keyName="ventWarningTime", name="Vent Shift Warning Time", description="Number of seconds before the vents reset", position=1, section="notifications")
    @Range(max=60, min=1)
    @Units(value="s")
    default public int ventWarningTime() {
        return 25;
    }

    @ConfigItem(keyName="eruptionWarning", name="Eruption Notification", description="Show warning in advance of the volcano erupting", position=2, section="notifications")
    default public boolean showEruptionWarning() {
        return true;
    }

    @ConfigItem(keyName="eruptionWarningTime", name="Eruption Warning Time", description="Number of seconds before the volcano erupts", position=3, section="notifications")
    @Range(max=60, min=30)
    @Units(value="s")
    default public int eruptionWarningTime() {
        return 40;
    }

    @ConfigItem(keyName="platformWarning", name="Platform Despawn Notification", description="Show warning for when platform below you is about to disappear", position=4, section="notifications")
    default public boolean showPlatformWarning() {
        return true;
    }

    @ConfigItem(keyName="boulderMovement", name="Boulder Movement Notification", description="Notify when current boulder stage is complete", position=5, section="notifications")
    default public boolean showBoulderWarning() {
        return true;
    }

    @ConfigItem(position=6, keyName="ventFixNotifier", name="Vent Fix notifier", description="Notifies on stability change 6 mins or prior for A role and B/C role", section="notifications")
    default public boolean ventFixNotifier() {
        return true;
    }

    @ConfigItem(position=0, keyName="predictedVentFixNotifier", name="Predicted Vent Fix notifier", description="Notifies when predicted stability change drops below a specific amount", section="predicted pre reset fix")
    default public boolean predictedVentFixNotifier() {
        return false;
    }

    @ConfigItem(keyName="predictedVentFixScenario", name="Prediction Scenario", description="Uses best or worst case scenario when predicting fixes or stability changes", position=1, section="predicted pre reset fix")
    default public PredictionScenario predictedVentFixScenario() {
        return PredictionScenario.WORST_CASE;
    }

    @ConfigItem(keyName="predictedStabilityChange", name="Stability Change", description="The estimated change before a recommended vent fix", position=2, section="predicted pre reset fix")
    @Range(max=13, min=1)
    default public int predictedStabilityChange() {
        return 12;
    }

    @ConfigItem(keyName="predictedventWarningStartTime", name="Warning Start Time", description="Number of seconds after 9:00 to suggest a vent fix", position=3, section="predicted pre reset fix")
    @Range(max=60, min=1)
    @Units(value="s")
    default public int predictedventWarningStartTime() {
        return 15;
    }

    @ConfigItem(keyName="predictedventWarningEndTime", name="Warning End Time", description="Number of seconds before 6:00 to suggest a vent fix", position=4, section="predicted pre reset fix")
    @Range(max=60, min=1)
    @Units(value="s")
    default public int predictedventWarningEndTime() {
        return 30;
    }

    @ConfigItem(position=0, keyName="pickaxeDespawnProtection", name="Pickaxe Despawn notifier", description="Notifies when your pickaxe is about to despawn soon", section="pickaxe protection")
    default public boolean pickaxeDespawnProtection() {
        return true;
    }

    @ConfigItem(keyName="pickaxeDespawnProtectionStartTime", name="Pickaxe Despawn Start Time", description="Notifies x seconds after you drop your pickaxe", position=1, section="pickaxe protection")
    @Range(max=100, min=1)
    @Units(value="s")
    default public int pickaxeDespawnProtectionStartTime() {
        return 75;
    }

    @ConfigItem(position=2, keyName="boulderFinishPickaxeLeaveProtection", name="Boulder Finish Pickaxe Leave notifier", description="Notifies if your pickaxe is still on the ground after finishing the boulder", section="pickaxe protection")
    default public boolean boulderFinishPickaxeLeaveProtection() {
        return true;
    }

    @ConfigItem(position=3, keyName="lowStabilityPickaxeLeaveProtection", name="Low Stability Pickaxe Leave notifier", description="Notifies if your pickaxe is still on the ground if stability gets low", section="pickaxe protection")
    default public boolean lowStabilityPickaxeLeaveProtection() {
        return true;
    }

    @ConfigItem(keyName="pickaxeLeaveStabilityAmount", name="Pickaxe Leave Stability Amount", description="Notifies once stability is x amount or lower if pick is on the floor", position=4, section="pickaxe protection")
    @Range(max=100, min=1)
    default public int pickaxeLeaveStabilityAmount() {
        return 35;
    }

    @ConfigItem(keyName="playerLeaveNotifier", name="Player Leave Notifier", description="Notifies when a player dies or exits the mine", position=0, section="team size")
    default public boolean playerLeaveNotifier() {
        return true;
    }

    @ConfigItem(keyName="extraPlayerNotifier", name="Extra Player Notifier", description="Notifies when an unexpected player enters the mine", position=1, section="team size")
    default public boolean extraPlayerNotifier() {
        return false;
    }

    @ConfigItem(keyName="expectedTeamSize", name="Expected Team Size", description="Set to the number of players in your current team", position=2, section="team size")
    @Range(max=50, min=1)
    default public int expectedTeamSize() {
        return 1;
    }

    public static enum TimingRenderMode {
        PROGRESS_PIE,
        NUMBER;

    }

    public static enum PredictionScenario {
        WORST_CASE,
        BEST_CASE;

    }
}

