/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.CappingRock;
import com.ultimatevm.PlayerPlatform;
import com.ultimatevm.TimedObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.runelite.api.coords.WorldPoint;

public class TimedObjectTracker {
    HashSet<Integer> positionCodes;
    LinkedList<TimedObject> timedObjects = new LinkedList();

    public TimedObjectTracker() {
        this.positionCodes = new HashSet();
    }

    public void addObject(WorldPoint worldLocation, TimedObject.ObjectType type) {
        int positionCode = worldLocation.getX() << 16 | worldLocation.getY();
        if (this.positionCodes.contains(positionCode)) {
            return;
        }
        this.positionCodes.add(positionCode);
        switch (type) {
            case ROCK: {
                this.timedObjects.addLast(new CappingRock(worldLocation));
                break;
            }
            case PLATFORM: {
                this.timedObjects.addLast(new PlayerPlatform(worldLocation));
            }
        }
    }

    public void clearRocks() {
        this.timedObjects.clear();
        this.positionCodes.clear();
    }

    public void updateRockTimers() {
        for (TimedObject obj : this.timedObjects) {
            obj.updateTimeRemaining();
        }
        this.removeExpiredRocks();
    }

    private void removeExpiredRocks() {
        Iterator it = this.timedObjects.iterator();
        while (it.hasNext()) {
            TimedObject obj = (TimedObject)it.next();
            if (!obj.isTimeExpired()) continue;
            int positionCode = obj.getWorldLocation().getX() << 16 | obj.getWorldLocation().getY();
            this.positionCodes.remove(positionCode);
            it.remove();
        }
    }

    public final LinkedList<TimedObject> getObjects() {
        return this.timedObjects;
    }
}

