/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.TimedObject;
import com.ultimatevm.TimedObjectTracker;
import com.ultimatevm.UltimateVolcanicMineConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.ColorUtil;

public class TimedObjectOverlay
extends Overlay {
    private final Client client;
    private final UltimateVolcanicMineConfig config;
    private TimedObjectTracker objTracker;

    @Inject
    TimedObjectOverlay(Client client, UltimateVolcanicMineConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.config = config;
    }

    public void setRockTracker(TimedObjectTracker rockTracker) {
        this.objTracker = rockTracker;
    }

    private void renderProgressPie(Graphics2D graphics, Point canvasLocation, TimedObject obj) {
        ProgressPieComponent progressPieComponent = new ProgressPieComponent();
        progressPieComponent.setPosition(canvasLocation);
        progressPieComponent.setProgress(obj.getTimeRemaining());
        Color stateColor = obj.getStateColor();
        progressPieComponent.setBorderColor(stateColor);
        progressPieComponent.setFill(ColorUtil.colorWithAlpha((Color)stateColor, (int)((int)((double)stateColor.getAlpha() / 2.5))));
        progressPieComponent.render(graphics);
    }

    private void renderNumber(Graphics2D graphics, Point canvasLocation, TimedObject obj) {
        int currentTicks = (int)obj.getTimeLeft();
        if (currentTicks > this.config.numberThreshold()) {
            return;
        }
        TextComponent textComponent = new TextComponent();
        textComponent.setText(Integer.toString(currentTicks));
        textComponent.setFont(new Font("Arial Bold", 1, 16));
        textComponent.setPosition(new java.awt.Point(canvasLocation.getX() - 10, canvasLocation.getY()));
        textComponent.setColor(obj.getStateColor());
        textComponent.render(graphics);
    }

    private void renderBasedOnMode(UltimateVolcanicMineConfig.TimingRenderMode mode, Graphics2D graphics, Point canvasLocation, TimedObject obj) {
        switch (mode) {
            case PROGRESS_PIE: {
                this.renderProgressPie(graphics, canvasLocation, obj);
                break;
            }
            case NUMBER: {
                this.renderNumber(graphics, canvasLocation, obj);
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        for (TimedObject obj : this.objTracker.getObjects()) {
            Point canvasLocation;
            LocalPoint localLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)obj.getWorldLocation());
            if (localLocation == null || (canvasLocation = Perspective.localToCanvas((Client)this.client, (LocalPoint)localLocation, (int)this.client.getPlane())) == null) continue;
            switch (obj.getObjectType()) {
                case ROCK: {
                    if (!this.config.rockTimer()) break;
                    this.renderBasedOnMode(this.config.rockRenderMode(), graphics, canvasLocation, obj);
                    break;
                }
                case PLATFORM: {
                    if (!this.config.platformTimer()) break;
                    this.renderBasedOnMode(this.config.platformRenderMode(), graphics, canvasLocation, obj);
                }
            }
        }
        return null;
    }
}

