/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.StabilityUpdateInfo;
import com.ultimatevm.UltimateVolcanicMineConfig;
import com.ultimatevm.VentStatus;
import java.util.ArrayList;

public class StatusState {
    private static final char[] VENT_TAGS = new char[]{'A', 'B', 'C'};
    public static final int NUM_VENTS = 3;
    public static final int STABILITY_CHANGE_CONSTANT = -25;
    public static final int TRUNCATION_POSSIBILITIES = 3;
    private VentStatus[] vents = new VentStatus[3];
    private int numIdentifiedVents;
    private int stabilityChange;
    private boolean hasReset;

    public static int getTotalVentUpdate(int change) {
        return change - -25;
    }

    public static int calcStabilityChange(StatusState state) {
        return StatusState.calcStabilityChange(state.getIdentifiedVentTotalValue());
    }

    public static int calcStabilityChange(int totalVentInfluence) {
        return -25 + totalVentInfluence;
    }

    public StatusState() {
        this.hasReset = false;
        this.numIdentifiedVents = 0;
        for (int i = 0; i < this.vents.length; ++i) {
            this.vents[i] = new VentStatus(VENT_TAGS[i]);
        }
    }

    public StatusState(StatusState state) {
        for (int i = 0; i < this.vents.length; ++i) {
            this.vents[i] = new VentStatus(VENT_TAGS[i]);
        }
        this.setEqualTo(state);
    }

    public void setVentEqualTo(StatusState state, int ventIndex) {
        if (this.vents[ventIndex].isIdentified() && !state.vents[ventIndex].isIdentified()) {
            --this.numIdentifiedVents;
        }
        if (!this.vents[ventIndex].isIdentified() && state.vents[ventIndex].isIdentified()) {
            ++this.numIdentifiedVents;
        }
        this.vents[ventIndex].setEqualTo(state.vents[ventIndex]);
    }

    public void setVentsEqualTo(StatusState state) {
        for (int i = 0; i < this.vents.length; ++i) {
            this.setVentEqualTo(state, i);
        }
    }

    public void setEqualTo(StatusState state) {
        this.hasReset = state.hasReset;
        this.stabilityChange = state.stabilityChange;
        this.setVentsEqualTo(state);
    }

    public void clearAllRanges() {
        for (int i = 0; i < this.vents.length; ++i) {
            if (this.vents[i].isIdentified()) continue;
            this.vents[i].clearRanges();
        }
    }

    public int[] updateVentStatus(int[] ventStatus, int chambers) {
        this.numIdentifiedVents = 0;
        int[] changeStates = new int[3];
        for (int i = 0; i < ventStatus.length; ++i) {
            changeStates[i] = this.vents[i].update(ventStatus[i], this.getDirectionFromChambers(i, chambers));
            if (!this.vents[i].isIdentified()) continue;
            ++this.numIdentifiedVents;
        }
        return changeStates;
    }

    public void updateVentMovement() {
        int[] currentVentInfluence = new int[]{0, 0};
        int[] previousVentInfluence = new int[]{0, 0};
        for (int i = 0; i < this.vents.length; ++i) {
            previousVentInfluence[0] = currentVentInfluence[0];
            previousVentInfluence[1] = currentVentInfluence[1];
            this.vents[i].updateEstimatedMovementInfluence(currentVentInfluence);
            this.vents[i].updateMovement(previousVentInfluence);
        }
    }

    public int reverseMovement(int knownBitFlag) {
        int currentVentInfluence = 0;
        for (int i = 0; i < this.vents.length; ++i) {
            if ((knownBitFlag & 1 << i) == 0) {
                int inf = this.vents[i].getReversedInfluence(currentVentInfluence);
                if (inf == 127) {
                    return -(i + 1);
                }
                this.vents[i].doReversedMovement(currentVentInfluence += inf);
                continue;
            }
            currentVentInfluence += this.vents[i].getEstimatedInfluence();
        }
        return 0;
    }

    public void mergePredictedRangesWith(StatusState state) {
        for (int i = 0; i < 3; ++i) {
            if (this.vents[i].isIdentified() || !state.vents[i].isRangeDefined()) continue;
            this.mergeVentWith(i, state.vents[i]);
        }
    }

    public void setOverlappingRangesWith(StatusState state) {
        for (int i = 0; i < 3; ++i) {
            if (this.vents[i].isIdentified() || !this.vents[i].isRangeDefined()) continue;
            this.overlapVentWith(i, state.vents[i]);
        }
    }

    public boolean doFreezeClipping(int moveBitState) {
        int clippedValueState = 0;
        block5: for (int i = 0; i < 3; ++i) {
            int curMove = moveBitState & 3 << i * 2;
            curMove >>= i * 2;
            switch (this.vents[i].getName()) {
                case 'A': {
                    continue block5;
                }
                case 'B': {
                    if (!this.vents[i].isIdentified() || !this.vents[0].isRangeDefined()) continue block5;
                    if (curMove == 0) {
                        if (this.vents[i].isBounded()) continue block5;
                        this.vents[0].doInnerBoundsClipping(41, 59);
                    } else if (curMove == 1) {
                        int actualValue = this.vents[i].getActualValue();
                        if (actualValue == 1 || actualValue == 99) continue block5;
                        if (this.vents[i].isWithinRange(41, 59)) {
                            this.vents[0].doOuterBoundsClipping(41, 59);
                        } else {
                            this.vents[0].doInnerBoundsClipping(41, 59);
                        }
                    } else if (curMove == 2) {
                        this.vents[0].doOuterBoundsClipping(41, 59);
                    }
                    if (this.vents[0].isRangeDefined()) continue block5;
                    clippedValueState |= 1;
                    continue block5;
                }
                case 'C': {
                    if (!this.vents[i].isIdentified()) continue block5;
                    boolean isADefined = this.vents[0].isRangeDefined();
                    boolean isBDefined = this.vents[1].isRangeDefined();
                    if (!isADefined && !isBDefined) continue block5;
                    boolean canAFreeze = this.vents[0].isWithinRange(41, 59);
                    boolean canBFreeze = this.vents[1].isWithinRange(41, 59);
                    if (curMove == 0) {
                        if (this.vents[i].isBounded()) continue block5;
                        if (!this.vents[i].isWithinRange(41, 59)) {
                            this.vents[0].doInnerBoundsClipping(41, 59);
                            this.vents[1].doInnerBoundsClipping(41, 59);
                        } else {
                            if (!canAFreeze) {
                                this.vents[1].doInnerBoundsClipping(41, 59);
                            }
                            if (!canBFreeze) {
                                this.vents[0].doInnerBoundsClipping(41, 59);
                            }
                        }
                    } else if (curMove == 1) {
                        int actualValue = this.vents[i].getActualValue();
                        if (actualValue == 1 || actualValue == 99) continue block5;
                        if (this.vents[i].isWithinRange(41, 59)) {
                            this.vents[0].doOuterBoundsClipping(41, 59);
                            this.vents[1].doOuterBoundsClipping(41, 59);
                        } else {
                            if (!canAFreeze) {
                                this.vents[1].doInnerBoundsClipping(41, 59);
                            }
                            if (!canBFreeze) {
                                this.vents[0].doInnerBoundsClipping(41, 59);
                            }
                        }
                    } else if (curMove == 2) {
                        this.vents[0].doOuterBoundsClipping(41, 59);
                        this.vents[1].doOuterBoundsClipping(41, 59);
                    }
                    if (isADefined && !this.vents[0].isRangeDefined()) {
                        clippedValueState |= 1;
                    }
                    if (!isBDefined || this.vents[1].isRangeDefined()) continue block5;
                    clippedValueState |= 2;
                }
            }
        }
        return clippedValueState != 0;
    }

    public void forceReset() {
        this.numIdentifiedVents = 0;
        for (int i = 0; i < this.vents.length; ++i) {
            this.vents[i].doVMReset();
        }
    }

    public void doVMReset() {
        if (this.hasReset) {
            return;
        }
        this.forceReset();
        this.hasReset = true;
    }

    public void doHalfSpaceClipping(int ventsToClip, int clipInfo) {
        for (int i = 0; i < 3; ++i) {
            boolean downwardClip;
            if (this.vents[i].isIdentified() || (ventsToClip & 1 << i) == 0) continue;
            int ventDirection = this.vents[i].getDirection();
            boolean bl = downwardClip = (clipInfo & 1 << i) != 0;
            if (ventDirection < 0) {
                if (downwardClip) {
                    this.vents[i].doInnerBoundsClipping(0, 53);
                    continue;
                }
                this.vents[i].doInnerBoundsClipping(47, 100);
                continue;
            }
            if (ventDirection <= 0) continue;
            if (downwardClip) {
                this.vents[i].doInnerBoundsClipping(47, 100);
                continue;
            }
            this.vents[i].doInnerBoundsClipping(0, 53);
        }
    }

    public int[] getUnidentifiedVentIndices() {
        int curIndex = 0;
        int[] indices = new int[3 - this.numIdentifiedVents];
        for (int i = 0; i < this.vents.length; ++i) {
            if (this.vents[i].isIdentified()) continue;
            indices[curIndex++] = i;
        }
        return indices;
    }

    public boolean calcPredictedVentValues(int change) {
        this.stabilityChange = change;
        if (this.isAllVentsIdentified()) {
            return false;
        }
        if (!this.isEnoughVentsIdentified()) {
            return false;
        }
        int[] indices = this.getUnidentifiedVentIndices();
        if (this.numIdentifiedVents == 1) {
            return this.calcDoubleVentValue(new VentStatus[]{this.vents[indices[0]], this.vents[indices[1]]}, change);
        }
        return this.calcSingleVentValue(this.vents[indices[0]], change);
    }

    public void alignPredictedRangesWith(StatusState state) {
        for (int i = 0; i < 3; ++i) {
            if (this.vents[i].isIdentified() || !state.vents[i].isRangeDefined()) continue;
            if (!this.vents[i].isRangeDefined()) {
                this.mergeVentWith(i, state.vents[i]);
                continue;
            }
            this.overlapVentWith(i, state.vents[i]);
        }
    }

    public void trimDoubleVentRanges(int change) {
        if (this.numIdentifiedVents != 1) {
            return;
        }
        int[] ventIndices = this.getUnidentifiedVentIndices();
        int pointsNeeded = StatusState.getTotalVentUpdate(change) - this.getIdentifiedVentTotalValue();
        this.trimRangesBasedOn(pointsNeeded, this.vents[ventIndices[1]], this.vents[ventIndices[0]]);
        this.trimRangesBasedOn(pointsNeeded, this.vents[ventIndices[0]], this.vents[ventIndices[1]]);
    }

    public void clipPredictedStabilityMismatch(int stabilityAmount) {
        boolean clipLowerBound;
        if (this.numIdentifiedVents != 2) {
            return;
        }
        int ventIndex = this.getUnidentifiedVentIndices()[0];
        if (!this.vents[ventIndex].isTwoSeperateValues()) {
            return;
        }
        int partialVentUpdate = this.getIdentifiedVentTotalValue();
        int lowerBoundStart = this.vents[ventIndex].getLowerBoundStart();
        int lowerBoundStability = StatusState.calcStabilityChange(partialVentUpdate + VentStatus.getStabilityInfluence(lowerBoundStart));
        int upperBoundEnd = this.vents[ventIndex].getUpperBoundEnd();
        int upperBoundStability = StatusState.calcStabilityChange(partialVentUpdate + VentStatus.getStabilityInfluence(upperBoundEnd));
        if (lowerBoundStability >= stabilityAmount && upperBoundStability >= stabilityAmount) {
            return;
        }
        if (lowerBoundStability == upperBoundStability) {
            return;
        }
        boolean bl = clipLowerBound = lowerBoundStability < upperBoundStability;
        if (clipLowerBound) {
            int change;
            int boundStart;
            int boundEnd = this.vents[ventIndex].getLowerBoundEnd();
            for (boundStart = lowerBoundStart; boundStart <= boundEnd && (change = StatusState.calcStabilityChange(partialVentUpdate + VentStatus.getStabilityInfluence(boundStart))) < stabilityAmount; ++boundStart) {
            }
            if (boundStart > boundEnd) {
                int upperBoundStart = this.vents[ventIndex].getUpperBoundStart();
                this.vents[ventIndex].clearRanges();
                this.vents[ventIndex].setLowerBoundRange(upperBoundStart, upperBoundEnd);
                this.vents[ventIndex].setUpperBoundRange(upperBoundStart, upperBoundEnd);
            } else {
                this.vents[ventIndex].setLowerBoundRange(boundStart, boundEnd);
            }
        } else {
            int change;
            int boundEnd;
            int boundStart = this.vents[ventIndex].getUpperBoundStart();
            for (boundEnd = upperBoundEnd; boundStart <= boundEnd && (change = StatusState.calcStabilityChange(partialVentUpdate + VentStatus.getStabilityInfluence(boundEnd))) < stabilityAmount; --boundEnd) {
            }
            if (boundStart > boundEnd) {
                int lowerBoundEnd = this.vents[ventIndex].getLowerBoundEnd();
                this.vents[ventIndex].clearRanges();
                this.vents[ventIndex].setLowerBoundRange(lowerBoundStart, lowerBoundEnd);
                this.vents[ventIndex].setUpperBoundRange(lowerBoundStart, lowerBoundEnd);
            } else {
                this.vents[ventIndex].setUpperBoundRange(boundStart, boundEnd);
            }
        }
    }

    public int getFutureStabilityChange(UltimateVolcanicMineConfig.PredictionScenario scenario) {
        if (this.numIdentifiedVents < 2) {
            return 127;
        }
        int totalVentValue = 0;
        ArrayList<VentStatus> estimatedVents = new ArrayList<VentStatus>();
        for (int i = 0; i < 3; ++i) {
            if (!this.vents[i].isRangeDefined()) {
                return 127;
            }
            if (this.vents[i].isIdentified()) {
                totalVentValue += this.vents[i].getStabilityInfluence();
                continue;
            }
            estimatedVents.add(this.vents[i]);
        }
        int estimatedVentValue = Integer.MAX_VALUE;
        for (int i = 0; i < estimatedVents.size(); ++i) {
            VentStatus vent = (VentStatus)estimatedVents.get(i);
            int avgLower = (vent.getLowerBoundEnd() + vent.getLowerBoundStart()) / 2;
            int avgUpper = (vent.getUpperBoundStart() + vent.getUpperBoundEnd()) / 2;
            int ventUpdate = 0;
            switch (scenario) {
                case WORST_CASE: {
                    ventUpdate = Math.min(VentStatus.getStabilityInfluence(avgLower), VentStatus.getStabilityInfluence(avgUpper));
                    break;
                }
                case BEST_CASE: {
                    ventUpdate = Math.max(VentStatus.getStabilityInfluence(avgLower), VentStatus.getStabilityInfluence(avgUpper));
                    break;
                }
                default: {
                    ventUpdate = (VentStatus.getStabilityInfluence(avgLower) + VentStatus.getStabilityInfluence(avgUpper)) / 2;
                }
            }
            if (estimatedVentValue == Integer.MAX_VALUE) {
                estimatedVentValue = ventUpdate;
                continue;
            }
            estimatedVentValue += ventUpdate;
        }
        if (estimatedVentValue != Integer.MAX_VALUE) {
            totalVentValue += estimatedVentValue;
        }
        return StatusState.calcStabilityChange(totalVentValue) + StabilityUpdateInfo.getMinRNGVariation();
    }

    private boolean calcSingleVentValue(VentStatus vent, int change) {
        int partialVentUpdate = this.getIdentifiedVentTotalValue();
        int pointsNeeded = StatusState.getTotalVentUpdate(change) - partialVentUpdate;
        if (pointsNeeded < 0 || pointsNeeded > 16) {
            return false;
        }
        float missingInversePercent = 1.0f - (float)pointsNeeded / 16.0f;
        int missingVentUpdate = (int)Math.ceil(50.0f * missingInversePercent);
        int lowerBoundStart = 47 - missingVentUpdate;
        int lowerBoundEnd = 53 - missingVentUpdate;
        int upperBoundStart = 47 + missingVentUpdate;
        int upperBoundEnd = 53 + missingVentUpdate;
        while (lowerBoundStart < lowerBoundEnd) {
            int newChange1 = StatusState.calcStabilityChange(partialVentUpdate + VentStatus.getStabilityInfluence(lowerBoundStart));
            int newChange2 = StatusState.calcStabilityChange(partialVentUpdate + VentStatus.getStabilityInfluence(lowerBoundEnd));
            if (newChange1 == change && newChange2 == change) break;
            if (newChange1 != change) {
                ++lowerBoundStart;
                --upperBoundEnd;
            }
            if (newChange2 == change) continue;
            --lowerBoundEnd;
            ++upperBoundStart;
        }
        vent.clearRanges();
        vent.setLowerBoundRange(lowerBoundStart, lowerBoundEnd);
        vent.setUpperBoundRange(upperBoundStart, upperBoundEnd);
        return true;
    }

    private boolean calcDoubleVentValue(VentStatus[] vents, int change) {
        int partialVentUpdate = this.getIdentifiedVentTotalValue();
        int pointsNeeded = StatusState.getTotalVentUpdate(change) - partialVentUpdate;
        if (pointsNeeded < 0 || pointsNeeded > 32) {
            return false;
        }
        int totalLowerBoundStart = 127;
        int totalLowerBoundEnd = 127;
        int totalUpperBoundStart = 127;
        int totalUpperBoundEnd = 127;
        for (int takenPoints = 0; takenPoints <= 16; ++takenPoints) {
            int remainingPoints = pointsNeeded - takenPoints;
            if (remainingPoints < 0 || remainingPoints > 16) continue;
            float missingInversePercent = 1.0f - (float)takenPoints / 16.0f;
            int missingVentUpdate = (int)Math.ceil(50.0f * missingInversePercent);
            int maxDistance = Math.min(50, missingVentUpdate);
            int minDistance = Math.max(0, missingVentUpdate - 50);
            int lowerBoundStart = 47 - maxDistance;
            int lowerBoundEnd = 53 - minDistance;
            int upperBoundStart = 47 + minDistance;
            int upperBoundEnd = 53 + maxDistance;
            while (lowerBoundStart < lowerBoundEnd) {
                int newChange1 = StatusState.calcStabilityChange(partialVentUpdate + remainingPoints + VentStatus.getStabilityInfluence(lowerBoundStart));
                int newChange2 = StatusState.calcStabilityChange(partialVentUpdate + remainingPoints + VentStatus.getStabilityInfluence(lowerBoundEnd));
                if (newChange1 == change && newChange2 == change) break;
                if (newChange1 != change) {
                    ++lowerBoundStart;
                    --upperBoundEnd;
                }
                if (newChange2 == change) continue;
                --lowerBoundEnd;
                ++upperBoundStart;
            }
            totalLowerBoundStart = totalLowerBoundStart == 127 ? lowerBoundStart : Math.min(totalLowerBoundStart, lowerBoundStart);
            totalLowerBoundEnd = totalLowerBoundEnd == 127 ? lowerBoundEnd : Math.max(totalLowerBoundEnd, lowerBoundEnd);
            totalUpperBoundStart = totalUpperBoundStart == 127 ? upperBoundStart : Math.min(totalUpperBoundStart, upperBoundStart);
            totalUpperBoundEnd = totalUpperBoundEnd == 127 ? upperBoundEnd : Math.max(totalUpperBoundEnd, upperBoundEnd);
        }
        for (int i = 0; i < vents.length; ++i) {
            vents[i].clearRanges();
            vents[i].setLowerBoundRange(totalLowerBoundStart, totalLowerBoundEnd);
            vents[i].setUpperBoundRange(totalUpperBoundStart, totalUpperBoundEnd);
        }
        return true;
    }

    private int getDirectionFromChambers(int index, int chambers) {
        return (chambers & 1 << index) != 0 ? 1 : -1;
    }

    private int getIdentifiedVentTotalValue() {
        int totalVentUpdate = 0;
        for (int i = 0; i < 3; ++i) {
            totalVentUpdate += this.vents[i].getStabilityInfluence();
        }
        return totalVentUpdate;
    }

    private void mergeVentWith(int index, VentStatus toMergeWith) {
        if (this.vents[index].isRangeDefined()) {
            this.vents[index].mergeLowerBoundRanges(toMergeWith.getLowerBoundStart(), toMergeWith.getLowerBoundEnd());
            this.vents[index].mergeUpperBoundRanges(toMergeWith.getUpperBoundStart(), toMergeWith.getUpperBoundEnd());
            if (this.vents[index].isUpperBoundWithinRange(this.vents[index].getLowerBoundStart(), this.vents[index].getLowerBoundEnd())) {
                this.vents[index].mergeUpperBoundRanges(this.vents[index].getLowerBoundStart(), this.vents[index].getLowerBoundEnd());
                this.vents[index].mergeLowerBoundRanges(this.vents[index].getUpperBoundStart(), this.vents[index].getUpperBoundEnd());
            }
        } else {
            this.vents[index].setLowerBoundRange(toMergeWith.getLowerBoundStart(), toMergeWith.getLowerBoundEnd());
            this.vents[index].setUpperBoundRange(toMergeWith.getUpperBoundStart(), toMergeWith.getUpperBoundEnd());
        }
    }

    private void overlapVentWith(int index, VentStatus toOverlapWith) {
        boolean isBothUpperValid;
        int[] lowerLower = this.vents[index].getOverlappedLowerBoundRange(toOverlapWith.getLowerBoundStart(), toOverlapWith.getLowerBoundEnd());
        int[] lowerUpper = this.vents[index].getOverlappedLowerBoundRange(toOverlapWith.getUpperBoundStart(), toOverlapWith.getUpperBoundEnd());
        int[] upperUpper = this.vents[index].getOverlappedUpperBoundRange(toOverlapWith.getUpperBoundStart(), toOverlapWith.getUpperBoundEnd());
        int[] upperLower = this.vents[index].getOverlappedUpperBoundRange(toOverlapWith.getLowerBoundStart(), toOverlapWith.getLowerBoundEnd());
        boolean isLowerLowerValid = lowerLower[0] != -1 || lowerLower[1] != -1;
        boolean isLowerUpperValid = lowerUpper[0] != -1 || lowerUpper[1] != -1;
        boolean isUpperUpperValid = upperUpper[0] != -1 || upperUpper[1] != -1;
        boolean isUpperLowerValid = upperLower[0] != -1 || upperLower[1] != -1;
        boolean isLowerValid = isLowerLowerValid || isLowerUpperValid;
        boolean isUpperValid = isUpperLowerValid || isUpperUpperValid;
        this.vents[index].clearRanges();
        if (!isLowerValid && !isUpperValid) {
            return;
        }
        boolean isBothLowerValid = isLowerUpperValid && isLowerLowerValid;
        boolean bl = isBothUpperValid = isUpperLowerValid && isUpperUpperValid;
        if (isBothLowerValid && isBothUpperValid) {
            this.vents[index].setLowerBoundRange(lowerLower[0], lowerLower[1]);
            this.vents[index].setUpperBoundRange(upperUpper[0], upperUpper[1]);
            return;
        }
        if (isLowerValid) {
            if (isBothLowerValid) {
                this.vents[index].setLowerBoundRange(lowerLower[0], lowerUpper[1]);
            } else if (isLowerLowerValid) {
                this.vents[index].setLowerBoundRange(lowerLower[0], lowerLower[1]);
            } else {
                this.vents[index].setLowerBoundRange(lowerUpper[0], lowerUpper[1]);
            }
            if (!isUpperValid) {
                this.vents[index].setUpperBoundRange(this.vents[index].getLowerBoundStart(), this.vents[index].getLowerBoundEnd());
            }
        }
        if (isUpperValid) {
            if (isBothUpperValid) {
                this.vents[index].setUpperBoundRange(upperLower[0], upperUpper[1]);
            } else if (isUpperUpperValid) {
                this.vents[index].setUpperBoundRange(upperUpper[0], upperUpper[1]);
            } else {
                this.vents[index].setUpperBoundRange(upperLower[0], upperLower[1]);
            }
            if (!isLowerValid) {
                this.vents[index].setLowerBoundRange(this.vents[index].getUpperBoundStart(), this.vents[index].getUpperBoundEnd());
            }
        }
    }

    private void trimRangesBasedOn(int pointsNeeded, VentStatus toTrim, VentStatus trimSource) {
        if (!toTrim.isRangeDefined()) {
            return;
        }
        if (toTrim.isTwoSeperateValues()) {
            int[] lowerResult = this.trimSingleSeperateRange(pointsNeeded, trimSource, new int[]{toTrim.getLowerBoundStart(), toTrim.getLowerBoundEnd()});
            boolean isLowerResultValid = lowerResult[0] != -1 && lowerResult[1] != -1;
            int[] upperResult = this.trimSingleSeperateRange(pointsNeeded, trimSource, new int[]{toTrim.getUpperBoundStart(), toTrim.getUpperBoundEnd()});
            boolean isUpperResultValid = upperResult[0] != -1 && upperResult[1] != -1;
            toTrim.clearRanges();
            if (!isLowerResultValid && !isUpperResultValid) {
                return;
            }
            if (isLowerResultValid && isUpperResultValid) {
                toTrim.setLowerBoundRange(lowerResult[0], lowerResult[1]);
                toTrim.setUpperBoundRange(upperResult[0], upperResult[1]);
            } else if (isLowerResultValid) {
                toTrim.setLowerBoundRange(lowerResult[0], lowerResult[1]);
                toTrim.setUpperBoundRange(lowerResult[0], lowerResult[1]);
            } else {
                toTrim.setLowerBoundRange(upperResult[0], upperResult[1]);
                toTrim.setUpperBoundRange(upperResult[0], upperResult[1]);
            }
        } else {
            int boundStart = toTrim.getLowerBoundStart();
            int lowerBoundStart = Integer.MAX_VALUE;
            int upperBoundEnd = Integer.MIN_VALUE;
            int lowerBoundEnd = 0;
            int upperBoundStart = 100;
            for (int boundEnd = toTrim.getLowerBoundEnd(); boundStart <= boundEnd; ++boundStart, --boundEnd) {
                boolean isBoundEndValid;
                int missingPoints = pointsNeeded - VentStatus.getStabilityInfluence(boundStart);
                boolean isBoundStartValid = this.doesVentSourceHaveRange(trimSource, missingPoints);
                if (isBoundStartValid) {
                    lowerBoundStart = Math.min(boundStart, lowerBoundStart);
                    lowerBoundEnd = Math.max(boundStart, lowerBoundEnd);
                }
                if (!(isBoundEndValid = this.doesVentSourceHaveRange(trimSource, missingPoints = pointsNeeded - VentStatus.getStabilityInfluence(boundEnd)))) continue;
                upperBoundEnd = Math.max(boundEnd, upperBoundEnd);
                upperBoundStart = Math.min(boundEnd, upperBoundStart);
            }
            toTrim.clearRanges();
            if (lowerBoundStart == Integer.MAX_VALUE && upperBoundEnd == Integer.MIN_VALUE) {
                return;
            }
            if (lowerBoundStart == Integer.MAX_VALUE) {
                toTrim.setLowerBoundRange(upperBoundStart, upperBoundEnd);
                toTrim.setUpperBoundRange(upperBoundStart, upperBoundEnd);
            } else if (upperBoundEnd == Integer.MIN_VALUE) {
                toTrim.setLowerBoundRange(lowerBoundStart, lowerBoundEnd);
                toTrim.setUpperBoundRange(lowerBoundStart, lowerBoundEnd);
            } else {
                toTrim.setLowerBoundRange(lowerBoundStart, lowerBoundEnd);
                toTrim.setUpperBoundRange(upperBoundStart, upperBoundEnd);
            }
        }
    }

    private int[] trimSingleSeperateRange(int pointsNeeded, VentStatus trimSource, int[] rangeBounds) {
        int boundStart = rangeBounds[0];
        int boundEnd = rangeBounds[1];
        while (boundStart <= boundEnd) {
            boolean isBoundEndValid;
            int missingPoints = pointsNeeded - VentStatus.getStabilityInfluence(boundStart);
            boolean isBoundStartValid = this.doesVentSourceHaveRange(trimSource, missingPoints);
            if (!isBoundStartValid) {
                ++boundStart;
            }
            if (!(isBoundEndValid = this.doesVentSourceHaveRange(trimSource, missingPoints = pointsNeeded - VentStatus.getStabilityInfluence(boundEnd)))) {
                --boundEnd;
            }
            if (!isBoundStartValid || !isBoundEndValid) continue;
            break;
        }
        if (boundStart > boundEnd) {
            return new int[]{-1, -1};
        }
        return new int[]{boundStart, boundEnd};
    }

    private boolean doesVentSourceHaveRange(VentStatus trimSource, int missingPoints) {
        int[] lowerRange = VentStatus.pointsToLowerRange(missingPoints);
        int[] upperRange = VentStatus.pointsToUpperRange(missingPoints);
        boolean isLowerValid = trimSource.isWithinRange(lowerRange[0], lowerRange[1]);
        boolean isUpperValid = trimSource.isWithinRange(upperRange[0], upperRange[1]);
        return isLowerValid || isUpperValid;
    }

    public boolean hasDoneVMReset() {
        return this.hasReset;
    }

    public boolean isEnoughVentsIdentified() {
        return this.numIdentifiedVents > 0;
    }

    public boolean isAllVentsIdentified() {
        return this.numIdentifiedVents == 3;
    }

    public final VentStatus[] getVents() {
        return this.vents;
    }

    public int getStabilityChange() {
        return this.stabilityChange;
    }

    public int getNumIdentifiedVents() {
        return this.numIdentifiedVents;
    }

    public boolean areRangesDefined() {
        int[] missingVentIndices = this.getUnidentifiedVentIndices();
        for (int i = 0; i < missingVentIndices.length; ++i) {
            if (this.vents[missingVentIndices[i]].isRangeDefined()) continue;
            return false;
        }
        return true;
    }
}

