/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.StatusState;
import com.ultimatevm.VentStatusTimeline;

public class StabilityUpdateInfo {
    private static int numPlayers = 1;
    private byte possibleRNGMods = 0;
    private StatusState stabilityUpdateState;
    private int RNGUpdateMod;
    private final int tickTimeStamp;
    private final int initialChange;
    private boolean isVerified;

    public static void resetPlayers() {
        numPlayers = 1;
    }

    public static int getNumPlayers() {
        return numPlayers;
    }

    public static void setNumPlayers(int players) {
        numPlayers = Math.max(numPlayers, players);
    }

    public static int getMinRNGVariation() {
        return -numPlayers / 3;
    }

    public static int getMaxRNGPossibleSize() {
        return numPlayers / 3 + 2;
    }

    public static StatusState getPredictionState(StabilityUpdateInfo initialStabUpdate, VentStatusTimeline timeline) {
        if (initialStabUpdate == null) {
            return timeline.getTimelinePredictionState();
        }
        StatusState predictionState = new StatusState();
        int startingRNGMod = initialStabUpdate.RNGUpdateMod;
        for (int i = StabilityUpdateInfo.getMaxRNGPossibleSize() - 1; i >= 0; --i) {
            initialStabUpdate.RNGUpdateMod = 1 - i;
            initialStabUpdate.calcStabilityChange();
            predictionState = timeline.getTimelinePredictionState();
            if (predictionState.areRangesDefined()) break;
        }
        initialStabUpdate.RNGUpdateMod = startingRNGMod;
        initialStabUpdate.calcStabilityChange();
        return predictionState;
    }

    StabilityUpdateInfo(StatusState stabilityUpdate, int currentTick, int change) {
        this.tickTimeStamp = currentTick;
        this.isVerified = false;
        for (int i = 0; i < StabilityUpdateInfo.getMaxRNGPossibleSize(); ++i) {
            this.possibleRNGMods = (byte)(this.possibleRNGMods | 1 << i);
        }
        this.stabilityUpdateState = new StatusState(stabilityUpdate);
        this.initialChange = change;
        this.RNGUpdateMod = StabilityUpdateInfo.getMinRNGVariation();
        this.verifyByInvalidPoints();
        this.calcStabilityChange();
    }

    public void verifyByInvalidPoints() {
        if (!this.isValid()) {
            return;
        }
        if (this.isVerified()) {
            return;
        }
        for (int i = 0; i < StabilityUpdateInfo.getMaxRNGPossibleSize(); ++i) {
            int currentRNGMod = 1 - i;
            if (this.stabilityUpdateState.calcPredictedVentValues(this.initialChange - currentRNGMod)) continue;
            this.possibleRNGMods = (byte)(this.possibleRNGMods & ~(1 << i));
        }
        this.checkVerification();
    }

    public void verifyByBreakpointShift(StabilityUpdateInfo futureStabState, int movementAmount) {
        if (!this.isValid()) {
            return;
        }
        if (this.isVerified() && futureStabState.isVerified()) {
            return;
        }
        if (Math.abs(movementAmount) % 3 != 0) {
            return;
        }
        int[] missingVentIndices = futureStabState.getStabilityUpdateState().getUnidentifiedVentIndices();
        if (missingVentIndices.length != 1) {
            return;
        }
        int shift = movementAmount / 3;
        StatusState testState = new StatusState(this.stabilityUpdateState);
        testState.setOverlappingRangesWith(futureStabState.getStabilityUpdateState());
    }

    public void calcStabilityChange() {
        this.stabilityUpdateState.clearAllRanges();
        this.stabilityUpdateState.calcPredictedVentValues(this.initialChange - this.RNGUpdateMod);
    }

    public void updateVentValues(StatusState updatedState) {
        this.stabilityUpdateState.setVentsEqualTo(updatedState);
        this.verifyByInvalidPoints();
        this.calcStabilityChange();
    }

    public void updatePredictedState(StatusState predictedState, StabilityUpdateInfo prevStabInfo, int initalRNGMod) {
        if (prevStabInfo == null || this.stabilityUpdateState.getNumIdentifiedVents() == prevStabInfo.getStabilityUpdateState().getNumIdentifiedVents()) {
            predictedState.setOverlappingRangesWith(this.getAllPossiblePredictedValuesState());
            this.trimDoubleVentRanges(predictedState);
        } else {
            predictedState.setOverlappingRangesWith(this.getPossiblePredictedValuesState(initalRNGMod));
        }
    }

    public StatusState getAllPossiblePredictedValuesState() {
        StatusState mergedPossiblities = new StatusState(this.stabilityUpdateState);
        for (int i = 0; i < StabilityUpdateInfo.getMaxRNGPossibleSize(); ++i) {
            StatusState testState = this.getPossiblePredictedValuesState(1 - i);
            mergedPossiblities.mergePredictedRangesWith(testState);
        }
        return mergedPossiblities;
    }

    public StatusState getPossiblePredictedValuesState(int rngMod) {
        StatusState possibleState = new StatusState(this.stabilityUpdateState);
        possibleState.clearAllRanges();
        possibleState.calcPredictedVentValues(this.initialChange - rngMod);
        return possibleState;
    }

    private void checkVerification() {
        int numBitsOn = 0;
        for (int i = 0; i < StabilityUpdateInfo.getMaxRNGPossibleSize(); ++i) {
            int currentRNGMod = 1 - i;
            if ((this.possibleRNGMods & 1 << i) == 0) continue;
            this.RNGUpdateMod = currentRNGMod;
            ++numBitsOn;
        }
        if (numBitsOn == 1) {
            this.isVerified = true;
        }
    }

    private void trimDoubleVentRanges(StatusState predictedState) {
        if (predictedState.getNumIdentifiedVents() != 1) {
            return;
        }
        StatusState mergedTrimmings = new StatusState();
        mergedTrimmings.clearAllRanges();
        for (int i = 0; i < StabilityUpdateInfo.getMaxRNGPossibleSize(); ++i) {
            StatusState testState = new StatusState(predictedState);
            testState.trimDoubleVentRanges(this.initialChange - (1 - i));
            mergedTrimmings.mergePredictedRangesWith(testState);
        }
        predictedState.setOverlappingRangesWith(mergedTrimmings);
    }

    public final StatusState getStabilityUpdateState() {
        return this.stabilityUpdateState;
    }

    public boolean isValid() {
        if (this.stabilityUpdateState.isAllVentsIdentified()) {
            return false;
        }
        return this.stabilityUpdateState.isEnoughVentsIdentified();
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public int getTickTimeStamp() {
        return this.tickTimeStamp;
    }

    public int getRNGUpdateMod() {
        return this.RNGUpdateMod;
    }

    public int getInitialChange() {
        return this.initialChange;
    }
}

