/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import java.util.Iterator;
import java.util.LinkedList;

public class StabilityTracker {
    public static final int STARTING_STABILITY = 50;
    private static final int MAX_STABILITY = 100;
    private static final int MAX_STABILITY_UPDATES = 3;
    private static final int MIN_STABILITY_CHANGE = -28;
    private static final int MAX_STABILITY_CHANGE = 24;
    private boolean hasResetHistory = false;
    private int currentStability;
    private int numDisplay;
    private LinkedList<Integer> stabilityHistory = new LinkedList();

    public StabilityTracker() {
        this.initialize();
        this.numDisplay = 3;
    }

    public void initialize() {
        this.currentStability = 50;
        this.stabilityHistory.clear();
        this.hasResetHistory = false;
    }

    public void resetStabilityHistory() {
        if (this.hasResetHistory) {
            return;
        }
        this.stabilityHistory.clear();
        this.hasResetHistory = true;
    }

    public boolean updateStability(int newStability) {
        if (this.currentStability == newStability) {
            return false;
        }
        int change = newStability - this.currentStability;
        if (change > 24 || change < -28) {
            return false;
        }
        this.currentStability = newStability;
        this.addChange(change);
        return this.currentStability != 100;
    }

    private int calcTrend() {
        if (this.stabilityHistory.size() < 2) {
            return 0;
        }
        int currentTrend = 0;
        int nextChange = Integer.MIN_VALUE;
        Iterator it = this.stabilityHistory.iterator();
        while (it.hasNext()) {
            int change = (Integer)it.next();
            if (nextChange != Integer.MIN_VALUE) {
                currentTrend += nextChange - change;
            }
            nextChange = change;
        }
        return currentTrend / 2;
    }

    public boolean isFutureStabilityBad(int stabilityThreshold) {
        int trend = 0;
        return this.getCurrentChange() + trend <= stabilityThreshold;
    }

    public String getStabilityText() {
        if (this.stabilityHistory.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator it = this.stabilityHistory.iterator();
        int numIterations = 0;
        while (it.hasNext()) {
            int change;
            if (numIterations == this.numDisplay) {
                return " (" + builder.toString() + ")";
            }
            if (++numIterations > 1) {
                builder.append(",");
            }
            if ((change = ((Integer)it.next()).intValue()) >= 0) {
                builder.append("<col=00ff00>").append(change).append("</col>");
                continue;
            }
            builder.append("<col=ff0000>").append(Math.abs(change)).append("</col>");
        }
        return " (" + builder.toString() + ")";
    }

    public int getCurrentStability() {
        return this.currentStability;
    }

    public int getCurrentChange() {
        if (this.stabilityHistory.isEmpty()) {
            return 0;
        }
        return this.stabilityHistory.getFirst();
    }

    public void addChange(int change) {
        this.stabilityHistory.addFirst(change);
        while (this.stabilityHistory.size() > 3) {
            this.stabilityHistory.removeLast();
        }
    }

    public void setDisplayCount(int count) {
        this.numDisplay = count;
    }
}

