/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.TimedObject;
import java.awt.Color;
import net.runelite.api.coords.WorldPoint;

public class PlayerPlatform
extends TimedObject {
    private final double TICK_DESPAWN_TIME = 150.0;

    PlayerPlatform(WorldPoint worldLocation) {
        super(worldLocation, TimedObject.ObjectType.PLATFORM);
    }

    @Override
    public Color getStateColor() {
        double ticksLeft = this.getTimeLeft();
        if (ticksLeft < 10.0) {
            return new Color(255, 50, 0);
        }
        if (ticksLeft < 75.0) {
            return new Color(255, 187, 0);
        }
        return new Color(0, 217, 0);
    }

    @Override
    public double getTimeLeft() {
        return 150.0 - this.ticksPassed;
    }

    @Override
    public double getTimeRemaining() {
        return Math.min(1.0, 1.0 - this.ticksPassed / 150.0);
    }

    @Override
    public boolean isTimeExpired() {
        return this.ticksPassed >= 150.0;
    }
}

