/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;

public class PickaxeProtector {
    public static int INVENTORY_SIZE = 28;
    static HashSet<Integer> protectedPickaxeTypes;
    private final Client client;
    HashSet<Integer> startingPickaxes;
    private int numTicksPickaxeDropped;

    @Inject
    PickaxeProtector(Client client) {
        this.client = client;
        this.startingPickaxes = new HashSet();
        this.resetStartingPickaxes();
        if (protectedPickaxeTypes != null) {
            return;
        }
        protectedPickaxeTypes = new HashSet<Integer>(Arrays.asList(20014, 11920, 12797, 23677, 25376, 23680, 23863, 23682, 23822, 13243, 25063, 13244, 25369, 25112, 1275));
    }

    void getStartingPickaxes() {
        if (!this.startingPickaxes.isEmpty()) {
            return;
        }
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return;
        }
        Item[] items = itemContainer.getItems();
        for (int i = 0; i < INVENTORY_SIZE; ++i) {
            Item item;
            if (i >= items.length || !protectedPickaxeTypes.contains((item = items[i]).getId()) || item.getQuantity() <= 0) continue;
            this.startingPickaxes.add(item.getId());
        }
    }

    void resetStartingPickaxes() {
        this.startingPickaxes.clear();
        this.resetTicksDropped();
    }

    boolean isPickaxeDropped() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return false;
        }
        HashSet<Integer> droppedPickaxes = new HashSet<Integer>(this.startingPickaxes);
        Item[] items = itemContainer.getItems();
        for (int i = 0; i < INVENTORY_SIZE; ++i) {
            Item item;
            if (i >= items.length || (item = items[i]).getQuantity() <= 0) continue;
            droppedPickaxes.remove(item.getId());
        }
        return !droppedPickaxes.isEmpty();
    }

    void incrementTicksDropped() {
        ++this.numTicksPickaxeDropped;
    }

    void resetTicksDropped() {
        this.numTicksPickaxeDropped = 0;
    }

    int getNumTicksPickaxeDropped() {
        return this.numTicksPickaxeDropped;
    }
}

