/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import com.ultimatevm.TimedObject;
import java.awt.Color;
import net.runelite.api.coords.WorldPoint;

public class CappingRock
extends TimedObject {
    private final double TICK_RESPAWN_TIME = 25.0;

    CappingRock(WorldPoint worldLocation) {
        super(worldLocation, TimedObject.ObjectType.ROCK);
    }

    @Override
    public Color getStateColor() {
        double ratio = this.ticksPassed / 25.0;
        if (ratio < 0.4) {
            return new Color(255, 50, 0);
        }
        if (ratio < 0.8) {
            return new Color(255, 187, 0);
        }
        return new Color(0, 217, 0);
    }

    @Override
    public double getTimeLeft() {
        return 25.0 - this.ticksPassed;
    }

    @Override
    public double getTimeRemaining() {
        return Math.min(1.0, this.ticksPassed / 25.0);
    }

    @Override
    public boolean isTimeExpired() {
        return this.ticksPassed >= 25.0;
    }
}

