/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatevm;

import java.util.HashSet;

public class CapCounter {
    private final int CAP_POINT_GAIN = 50;
    private HashSet<Integer> seenChambers = new HashSet();
    private HashSet<Integer> possibleCapPositions = new HashSet();
    private int timesCapped;
    private int currentScore;

    CapCounter() {
        this.initialize();
    }

    public void initialize() {
        this.seenChambers.clear();
        this.possibleCapPositions.clear();
        this.timesCapped = 0;
        this.currentScore = 0;
    }

    public void addCappingPositions(int chamberX, int chamberY) {
        int positionCode = chamberX << 16 | chamberY;
        if (this.seenChambers.contains(positionCode)) {
            return;
        }
        this.seenChambers.add(positionCode);
        this.possibleCapPositions.add(chamberX + 1 << 16 | chamberY - 1);
        this.possibleCapPositions.add(chamberX << 16 | chamberY - 1);
        this.possibleCapPositions.add(chamberX + 2 << 16 | chamberY);
        this.possibleCapPositions.add(chamberX + 2 << 16 | chamberY + 1);
        this.possibleCapPositions.add(chamberX + 1 << 16 | chamberY + 2);
        this.possibleCapPositions.add(chamberX << 16 | chamberY + 2);
        this.possibleCapPositions.add(chamberX - 1 << 16 | chamberY + 1);
        this.possibleCapPositions.add(chamberX - 1 << 16 | chamberY);
    }

    public boolean updateScore(int newScore, int playerX, int playerY) {
        int scoreDiff = newScore - this.currentScore;
        this.currentScore = newScore;
        if (!this.possibleCapPositions.contains(playerX << 16 | playerY)) {
            return false;
        }
        if (scoreDiff == 50) {
            ++this.timesCapped;
        }
        return scoreDiff == 50;
    }

    public int getTimesCapped() {
        return this.timesCapped;
    }
}

