/*
 * Decompiled with CFR 0.152.
 */
package com.jackriccomini.spamfilter;

import com.google.inject.Provides;
import com.jackriccomini.spamfilter.SpamFilterConfig;
import com.jackriccomini.spamfilter.SpamFilterType;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spam filter")
public class SpamFilterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpamFilterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SpamFilterConfig config;
    File configDir;
    File userGoodCorpusFile;
    File userBadCorpusFile;
    private List<String> goodCorpus;
    private List<String> badCorpus;
    private List<String> userGoodCorpus;
    private List<String> userBadCorpus;
    private Map<String, Integer> goodCounts;
    private Map<String, Integer> badCounts;

    protected void startUp() throws Exception {
        this.configDir = new File(RuneLite.RUNELITE_DIR, "spam-filter");
        this.userGoodCorpusFile = new File(this.configDir, "user_good_corpus.txt");
        this.userBadCorpusFile = new File(this.configDir, "user_bad_corpus.txt");
        if (this.configDir.mkdir()) {
            log.info("Made spam-filter directory");
            boolean good = this.userGoodCorpusFile.createNewFile();
            boolean bad = this.userBadCorpusFile.createNewFile();
            assert (good && bad);
        }
        InputStream goodCorpusRes = ((Object)((Object)this)).getClass().getResourceAsStream("/good_corpus.txt");
        InputStream badCorpusRes = ((Object)((Object)this)).getClass().getResourceAsStream("/bad_corpus.txt");
        BufferedReader goodCorpusReader = new BufferedReader(new InputStreamReader(goodCorpusRes, StandardCharsets.UTF_8));
        BufferedReader badCorpusReader = new BufferedReader(new InputStreamReader(badCorpusRes, StandardCharsets.UTF_8));
        this.goodCorpus = goodCorpusReader.lines().collect(Collectors.toList());
        this.badCorpus = badCorpusReader.lines().collect(Collectors.toList());
        goodCorpusReader.close();
        badCorpusReader.close();
        this.userGoodCorpus = Files.readAllLines(this.userGoodCorpusFile.toPath());
        this.userBadCorpus = Files.readAllLines(this.userBadCorpusFile.toPath());
        log.info("Loaded built-in corpus files with " + this.goodCorpus.size() + " (g) & " + this.badCorpus.size() + " (b) entries");
        log.info("Loaded user corpus files with " + this.userGoodCorpus.size() + " (g) & " + this.userBadCorpus.size() + " (b) entries");
        this.generateTokenCounts();
    }

    private void appendToUserCorpus(String message, List<String> corpus, File corpusFile) {
        if (this.config.showSpamScores()) {
            message = message.substring(0, message.lastIndexOf("(") - 1);
        }
        corpus.add(message);
        this.generateTokenCounts();
        try {
            Files.write(corpusFile.toPath(), corpus, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            log.warn("Something went wrong writing a corpus file", (Throwable)e);
        }
    }

    @Provides
    SpamFilterConfig provideConfig(ConfigManager configManager) {
        return (SpamFilterConfig)configManager.getConfig(SpamFilterConfig.class);
    }

    private void generateTokenCounts() {
        this.goodCounts = this.countTokens(this.goodCorpus, this.userGoodCorpus);
        this.badCounts = this.countTokens(this.badCorpus, this.userBadCorpus);
    }

    private void markSpam(String chatLine) {
        this.appendToUserCorpus(chatLine, this.userBadCorpus, this.userBadCorpusFile);
    }

    private void markHam(String chatLine) {
        this.appendToUserCorpus(chatLine, this.userGoodCorpus, this.userGoodCorpusFile);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry[] entries = event.getMenuEntries();
        MenuEntry secondEntry = entries[entries.length - 2];
        int clickedWidgetId = secondEntry.getParam1();
        Widget widget = this.client.getWidget(clickedWidgetId);
        if (widget == null) {
            return;
        }
        if (widget.getParentId() != WidgetInfo.CHATBOX_MESSAGE_LINES.getId()) {
            return;
        }
        int firstChatSender = WidgetInfo.CHATBOX_FIRST_MESSAGE.getChildId();
        int clickedChatSender = WidgetInfo.TO_CHILD((int)clickedWidgetId);
        int clickOffset = clickedChatSender - firstChatSender;
        int selectedChatOffset = clickOffset * 4 + 1;
        Widget selectedChatWidget = widget.getParent().getChild(selectedChatOffset);
        if (selectedChatWidget == null) {
            return;
        }
        String selectedChat = Text.removeTags((String)selectedChatWidget.getText());
        if (this.config.showMarkSpam()) {
            this.client.createMenuEntry(1).setOption("Mark spam").setType(MenuAction.RUNELITE).setTarget(ColorUtil.wrapWithColorTag((String)"message", (Color)Color.WHITE)).onClick(e -> {
                this.markSpam(selectedChat);
                this.client.refreshChat();
            });
        }
        if (this.config.showMarkHam()) {
            this.client.createMenuEntry(1).setOption("Mark ham").setType(MenuAction.RUNELITE).setTarget(ColorUtil.wrapWithColorTag((String)"message", (Color)Color.WHITE)).onClick(e -> {
                this.markHam(selectedChat);
                this.client.refreshChat();
            });
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        boolean isSpam;
        if (!(event.getActor() instanceof Player) || !this.config.filterOverheads()) {
            return;
        }
        String message = event.getOverheadText();
        float spamRating = this.pMessageBad(message.strip());
        boolean bl = isSpam = spamRating > (float)this.config.threshold() / 100.0f;
        if (isSpam) {
            event.getActor().setOverheadText(" ");
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        boolean isSpam;
        if (!event.getEventName().equals("chatFilterCheck")) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int messageType = intStack[intStackSize - 2];
        int messageId = intStack[intStackSize - 1];
        Object message = stringStack[stringStackSize - 1];
        ChatMessageType chatMessageType = ChatMessageType.of((int)messageType);
        if (chatMessageType != ChatMessageType.PUBLICCHAT) {
            return;
        }
        MessageNode messageNode = (MessageNode)this.client.getMessages().get((long)messageId);
        float spamRating = this.pMessageBad(((String)message).strip());
        boolean bl = isSpam = spamRating > (float)this.config.threshold() / 100.0f;
        if (isSpam) {
            if (this.config.filterType() == SpamFilterType.HIDE_MESSAGES) {
                intStack[intStackSize - 3] = 0;
            } else if (this.config.filterType() == SpamFilterType.GREY_MESSAGES) {
                message = ColorUtil.wrapWithColorTag((String)message, (Color)Color.GRAY);
            }
        }
        if (this.config.showSpamScores()) {
            DecimalFormat df = new DecimalFormat("0.00");
            String spamRatingDisplay = ColorUtil.wrapWithColorTag((String)("(" + df.format(spamRating) + ")"), (Color)Color.MAGENTA);
            message = (String)message + " " + spamRatingDisplay;
        }
        stringStack[stringStackSize - 1] = message;
    }

    float pTokenBad(String token) {
        int badCount;
        int goodCount = this.goodCounts.getOrDefault(token, 0);
        if (goodCount + (badCount = this.badCounts.getOrDefault(token, 0).intValue()) == 0) {
            return 0.4f;
        }
        float rawProbability = (float)badCount / (float)(goodCount + badCount);
        float clampUpperBound = Math.min(rawProbability, 0.99f);
        float clampLowerBound = Math.max(clampUpperBound, 0.01f);
        return clampLowerBound;
    }

    float pMessageBad(String message) {
        String msg = message.toLowerCase();
        String[] tokens = msg.split("\\s+");
        if (tokens.length == 1 && !message.startsWith("!")) {
            return 0.0f;
        }
        HashSet<String> tokensUnique = new HashSet<String>();
        for (String token : tokens) {
            tokensUnique.add(token);
        }
        float pPredictorsCorrect = 1.0f;
        float pPredictorsIncorrect = 1.0f;
        for (String token : tokensUnique) {
            float p = this.pTokenBad(token);
            pPredictorsCorrect *= p;
            pPredictorsIncorrect *= 1.0f - p;
        }
        return pPredictorsCorrect / (pPredictorsCorrect + pPredictorsIncorrect);
    }

    HashMap<String, Integer> countTokens(List<String> ... corpuses) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (List<String> corpus : corpuses) {
            for (String message : corpus) {
                String[] tokens;
                message = message.toLowerCase();
                for (String token : tokens = message.split("\\s")) {
                    counts.put(token, counts.getOrDefault(token, 0) + 1);
                }
            }
        }
        return counts;
    }
}

