/*
 * Decompiled with CFR 0.152.
 */
package com.WildernessPlayerAlarm;

import com.WildernessPlayerAlarm.AlarmOverlay;
import com.WildernessPlayerAlarm.WildernessPlayerAlarmConfig;
import com.google.inject.Provides;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wilderness Player Alarm")
public class WildernessPlayerAlarmPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WildernessPlayerAlarmPlugin.class);
    @Inject
    private Client client;
    @Inject
    private WildernessPlayerAlarmConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AlarmOverlay overlay;
    @Inject
    private Notifier notifier;
    private boolean overlayOn = false;

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        List players = this.client.getPlayers();
        boolean shouldAlarm = false;
        Player self = this.client.getLocalPlayer();
        LocalPoint currentPosition = this.client.getLocalPlayer().getLocalLocation();
        if (this.client.getVarbitValue(5963) == 1) {
            for (Player player : players) {
                if (player.getId() == self.getId() || player.getLocalLocation().distanceTo(currentPosition) / 128 > this.config.alarmRadius()) continue;
                shouldAlarm = true;
                if (this.config.ignoreClan() && player.isClanMember()) {
                    shouldAlarm = false;
                }
                if (!this.config.ignoreFriends() || !player.isFriend()) continue;
                shouldAlarm = false;
            }
        }
        if (shouldAlarm && !this.overlayOn) {
            if (this.config.desktopNotification()) {
                this.notifier.notify("Player spotted!");
            }
            this.overlayOn = true;
            this.overlayManager.add((Overlay)this.overlay);
        }
        if (!shouldAlarm) {
            this.overlayOn = false;
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    protected void shutDown() throws Exception {
        if (this.overlayOn) {
            this.overlayOn = false;
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    @Provides
    WildernessPlayerAlarmConfig provideConfig(ConfigManager configManager) {
        return (WildernessPlayerAlarmConfig)configManager.getConfig(WildernessPlayerAlarmConfig.class);
    }
}

