/*
 * Decompiled with CFR 0.152.
 */
package com.gecalc;

import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.input.KeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GECalcKeyHandler
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(GECalcKeyHandler.class);
    @Inject
    private Client client;

    GECalcKeyHandler() {
    }

    public static boolean containsOperators(String inputString) {
        if (inputString.contains("+")) {
            return true;
        }
        if (inputString.contains("-")) {
            return true;
        }
        if (inputString.contains("*")) {
            return true;
        }
        return inputString.contains("/");
    }

    private boolean isQuantityInput() {
        return this.client.getVarcIntValue(5) == 7;
    }

    private int runExpression(String expression) {
        double result = 0.0;
        String[] operators = new String[]{"+", "-", "*", "/"};
        String foundOperator = "";
        for (String operator : operators) {
            if (!expression.contains(operator)) continue;
            foundOperator = operator.replaceAll("\\*", "\\\\*").replaceAll("\\+", "\\\\+");
        }
        if (foundOperator != "") {
            try {
                String[] sides = expression.split(foundOperator);
                int left = this.convertKMBValue(sides[0]);
                int right = this.convertKMBValue(sides[1]);
                switch (foundOperator) {
                    case "\\+": {
                        result = left + right;
                        break;
                    }
                    case "-": {
                        result = left - right;
                        break;
                    }
                    case "\\*": {
                        result = left * right;
                        break;
                    }
                    case "/": {
                        result = left / right;
                    }
                }
                return (int)Math.ceil(result);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
                return 1;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 1;
            }
        }
        return 1;
    }

    private int convertKMBValue(String sanitisedInput) {
        if (sanitisedInput.matches("[0-9]+\\.[0-9]+[kmb]") || sanitisedInput.matches("[0-9]+[kmb]")) {
            double newAmount;
            char foundUnit = sanitisedInput.charAt(sanitisedInput.length() - 1);
            double amountEntered = Double.parseDouble(sanitisedInput.substring(0, sanitisedInput.length() - 1));
            switch (foundUnit) {
                case 'k': {
                    newAmount = amountEntered * 1000.0;
                    break;
                }
                case 'm': {
                    newAmount = amountEntered * 1000000.0;
                    break;
                }
                case 'b': {
                    newAmount = amountEntered * 1.0E9;
                    break;
                }
                default: {
                    newAmount = 0.0;
                }
            }
            return (int)newAmount;
        }
        try {
            return (int)Math.ceil(Double.parseDouble(sanitisedInput));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 1;
        }
    }

    private void parseQuantity() {
        int calculatedValue = 0;
        String rawInput = this.client.getVarcStrValue(359);
        String sanitisedInput = rawInput.toLowerCase().replaceAll("\\s+", "");
        try {
            calculatedValue = GECalcKeyHandler.containsOperators(sanitisedInput) ? this.runExpression(sanitisedInput) : this.convertKMBValue(sanitisedInput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info(sanitisedInput + "=" + calculatedValue);
        this.client.setVarcStrValue(359, String.valueOf(calculatedValue));
    }

    private void appendStringToValue(String toAppend, Boolean checkForMultiple) {
        String currentValue = this.client.getVarcStrValue(359);
        if (currentValue.equals("")) {
            return;
        }
        if (checkForMultiple.booleanValue() && currentValue.contains(".")) {
            return;
        }
        String newValue = currentValue + toAppend;
        this.client.setVarcStrValue(359, newValue);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.isQuantityInput()) {
            this.parseQuantity();
        } else if ((e.getKeyCode() == 46 || e.getKeyCode() == 110) && this.isQuantityInput()) {
            this.appendStringToValue(".", true);
        } else if (e.getKeyCode() == 32 && this.isQuantityInput()) {
            this.appendStringToValue(" ", false);
        } else if ((e.getKeyCode() == 107 || e.getKeyCode() == 109 || e.getKeyCode() == 106 || e.getKeyCode() == 111) && this.isQuantityInput()) {
            this.appendStringToValue(String.valueOf(e.getKeyChar()), false);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

