/*
 * Decompiled with CFR 0.152.
 */
package com.randomscreenshot;

import com.randomscreenshot.FileFactory;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.events.ScreenshotTaken;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ScreenshotUtil {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotUtil.class);
    @Inject
    private DrawManager drawManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private EventBus eventBus;
    @Inject
    private FileFactory fileFactory;

    public void takeScreenshot() {
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.saveScreenshot((Image)img));
        this.drawManager.requestNextFrameListener(imageCallback);
    }

    private void saveScreenshot(Image image) {
        File screenshotFile;
        BufferedImage screenshot = ImageUtil.bufferedImageFromImage((Image)image);
        try {
            screenshotFile = this.fileFactory.createScreenshotFile();
            ImageIO.write((RenderedImage)screenshot, "PNG", screenshotFile);
        }
        catch (IOException ex) {
            log.error("error writing screenshot", (Throwable)ex);
            return;
        }
        ScreenshotTaken screenshotTaken = new ScreenshotTaken(screenshotFile, screenshot);
        this.eventBus.post((Object)screenshotTaken);
    }
}

