/*
 * Decompiled with CFR 0.152.
 */
package com.randomscreenshot;

import com.randomscreenshot.RandomScreenshotConfig;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.RuneLite;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FileFactory {
    private static final Logger log = LoggerFactory.getLogger(FileFactory.class);
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    @Inject
    private Client client;
    @Inject
    private RandomScreenshotConfig config;

    public File createScreenshotFile() throws IOException {
        File screenshotDirectory = this.createScreenshotDirectory();
        String fileName = FileFactory.format(new Date());
        File screenshotFile = new File(screenshotDirectory, fileName + ".png");
        int i = 1;
        while (screenshotFile.exists()) {
            screenshotFile = new File(screenshotDirectory, fileName + String.format("(%d)", i++) + ".png");
        }
        return screenshotFile;
    }

    public File createScreenshotDirectory() throws IOException {
        File screenshotDirectory = this.config.useCustomDirectory() ? new File(this.config.screenshotDirectory()) : this.getPlayerScreenshotDirectory();
        if (!screenshotDirectory.mkdirs() && !screenshotDirectory.exists()) {
            throw new IOException("Could not create screenshot directory at " + screenshotDirectory.getAbsolutePath());
        }
        return screenshotDirectory;
    }

    private File getPlayerScreenshotDirectory() {
        File directory;
        if (this.client.getLocalPlayer() != null && this.client.getLocalPlayer().getName() != null) {
            Object playerDir = this.client.getLocalPlayer().getName();
            RuneScapeProfileType profileType = RuneScapeProfileType.getCurrent((Client)this.client);
            if (profileType != RuneScapeProfileType.STANDARD) {
                playerDir = (String)playerDir + "-" + Text.titleCase((Enum)profileType);
            }
            playerDir = (String)playerDir + File.separator + "Random Screenshots";
            directory = new File(RuneLite.SCREENSHOT_DIR, (String)playerDir);
        } else {
            directory = RuneLite.SCREENSHOT_DIR;
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(Date date) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return TIME_FORMAT.format(date);
        }
    }
}

