/*
 * Decompiled with CFR 0.152.
 */
package com.aerial;

import com.aerial.AerialConfig;
import com.aerial.AerialOverlay;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Projectile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Aerial Fishing")
public class AerialPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AerialPlugin.class);
    static final int BIRD_PROJECTILE = 1632;
    static final int GLOVE_NO_BIRD = 22816;
    static final int GLOVE_WITH_BIRD = 22817;
    public static Map<Integer, Integer> distToTicks = null;
    @Inject
    private Client client;
    @Inject
    private AerialConfig config;
    @Inject
    private AerialOverlay aerialOverlay;
    @Inject
    private OverlayManager overlayManager;
    private final Map<Integer, Integer> pointToEndTick = new HashMap<Integer, Integer>();

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.aerialOverlay);
        distToTicks = new HashMap<Integer, Integer>();
        distToTicks.put(1, 0);
        distToTicks.put(2, 1);
        distToTicks.put(3, 1);
        distToTicks.put(4, 2);
        distToTicks.put(5, 3);
        distToTicks.put(6, 3);
        distToTicks.put(7, 4);
        distToTicks.put(8, 4);
        distToTicks.put(9, 5);
        distToTicks.put(10, 5);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.aerialOverlay);
        distToTicks = null;
        this.pointToEndTick.clear();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int weaponId = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.WEAPON);
        if (weaponId != 22817 && weaponId != 22816) {
            return;
        }
        for (Projectile p : this.client.getProjectiles()) {
            if (p.getId() != 1632 || p.getInteracting() == null || !p.getInteracting().getName().equals(this.client.getLocalPlayer().getName())) continue;
            WorldPoint point = WorldPoint.fromLocal((Client)this.client, (LocalPoint)new LocalPoint(p.getX1(), p.getY1()));
            int distance = point.distanceTo2D(WorldPoint.fromLocal((Client)this.client, (LocalPoint)p.getTarget()));
            int hash = AerialPlugin.getPointHash(point);
            if (this.pointToEndTick.containsKey(hash)) continue;
            this.pointToEndTick.put(hash, this.client.getTickCount() + distToTicks.getOrDefault(distance, -1));
        }
        Iterator<Map.Entry<Integer, Integer>> it = this.pointToEndTick.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            if (this.client.getTickCount() + 1 == entry.getValue() && this.config.warningSound()) {
                this.client.playSoundEffect(3813);
            }
            if (this.client.getTickCount() == entry.getValue().intValue() && this.config.idleSound()) {
                this.client.playSoundEffect(3815);
            }
            if (this.client.getTickCount() < entry.getValue() + 6) continue;
            it.remove();
        }
    }

    private static int getPointHash(WorldPoint point) {
        return point.getX() << 15 + point.getY();
    }

    @Provides
    AerialConfig provideConfig(ConfigManager configManager) {
        return (AerialConfig)configManager.getConfig(AerialConfig.class);
    }
}

