/*
 * Decompiled with CFR 0.152.
 */
package com.aerial;

import com.aerial.AerialConfig;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.kit.KitType;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class AerialOverlay
extends Overlay {
    Client client;
    AerialConfig config;
    static final int[] distances = new int[]{1, 3, 4, 6, 8};
    static final WorldArea ignoreArea = new WorldArea(1360, 3627, 16, 32, 0);

    @Inject
    public AerialOverlay(Client client, AerialConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.drawRadius()) {
            return null;
        }
        int weaponId = this.client.getLocalPlayer().getPlayerComposition().getEquipmentId(KitType.WEAPON);
        if (weaponId != 22817 && weaponId != 22816) {
            return null;
        }
        WorldPoint center = this.client.getLocalPlayer().getWorldLocation();
        for (int dist : distances) {
            this.square(center, graphics, dist);
        }
        return null;
    }

    private void square(WorldPoint center, Graphics2D graphics, int dist) {
        int i;
        int cx = center.getX();
        int cy = center.getY();
        for (i = -dist; i <= dist; ++i) {
            this.renderWorldPointBorders(graphics, new WorldPoint(cx + i, cy + dist, center.getPlane()), true, false, false, false);
        }
        for (i = -dist; i <= dist; ++i) {
            this.renderWorldPointBorders(graphics, new WorldPoint(cx + i, cy - dist, center.getPlane()), false, false, true, false);
        }
        for (i = -dist; i <= dist; ++i) {
            this.renderWorldPointBorders(graphics, new WorldPoint(cx - dist, cy - i, center.getPlane()), false, false, false, true);
        }
        for (i = -dist; i <= dist; ++i) {
            this.renderWorldPointBorders(graphics, new WorldPoint(cx + dist, cy + i, center.getPlane()), false, true, false, false);
        }
    }

    private void renderWorldPointBorders(Graphics2D graphics, WorldPoint worldPoint, boolean topBorder, boolean rightBorder, boolean bottomBorder, boolean leftBorder) {
        int y2;
        int x2;
        Point canvasPointB;
        int y1;
        int x1;
        Point canvasPointA;
        if (ignoreArea.contains2D(worldPoint)) {
            return;
        }
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (localPoint == null) {
            return;
        }
        int plane = worldPoint.getPlane();
        graphics.setColor(this.config.borderColor());
        graphics.setStroke(new BasicStroke(this.config.borderWidth()));
        if (topBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() + 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() + 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
        if (rightBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() - 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() + 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
        if (bottomBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() - 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
        if (leftBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() + 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
    }
}

