/*
 * Decompiled with CFR 0.152.
 */
package com.maxhit;

import com.google.inject.Provides;
import com.maxhit.AttackStyle;
import com.maxhit.Element;
import com.maxhit.InventoryWeapons;
import com.maxhit.MagicSpell;
import com.maxhit.MaxHitConfig;
import com.maxhit.MaxHitOverlay;
import com.maxhit.NextMaxHit;
import com.maxhit.Spellbook;
import com.maxhit.WeaponType;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Max Hit", description="Displays current max hit", enabledByDefault=false, tags={"max, hit, spec, pvp, magic, spell, combat"})
public class MaxHitPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MaxHitPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private MaxHitOverlay myOverlay;
    @Inject
    private MaxHitConfig config;
    private int attackStyleVarbit = -1;
    private int equippedWeaponTypeVarbit = -1;
    private int castingModeVarbit = -1;
    private AttackStyle attackStyle;

    @Provides
    MaxHitConfig getConfig(ConfigManager configManager) {
        return (MaxHitConfig)configManager.getConfig(MaxHitConfig.class);
    }

    public void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.myOverlay);
    }

    public void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.myOverlay);
    }

    public HashMap equippableItems() {
        HashMap<String, InventoryWeapons> inventoryWeaponsHashMap;
        block20: {
            Item[] inventItems;
            inventoryWeaponsHashMap = new HashMap<String, InventoryWeapons>();
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            if (inventory == null || (inventItems = inventory.getItems()).length == 0) break block20;
            for (Item item : inventItems) {
                int level;
                int equipment;
                double pray;
                int style;
                String weaponType;
                String name;
                Integer ID;
                block23: {
                    block27: {
                        int prayerLevel;
                        int defense;
                        block30: {
                            block29: {
                                block28: {
                                    block21: {
                                        block26: {
                                            block25: {
                                                block24: {
                                                    block22: {
                                                        boolean twoHanded;
                                                        ItemStats itemStats;
                                                        ID = item.getId();
                                                        if (ID == -1 || (itemStats = this.itemManager.getItemStats(ID.intValue(), false)) == null || !itemStats.isEquipable() || this.itemManager.getItemStats(ID.intValue(), false).getEquipment().getSlot() != 3) continue;
                                                        name = this.client.getItemDefinition(ID.intValue()).getName();
                                                        inventoryWeaponsHashMap.put(name, new InventoryWeapons());
                                                        ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).ID = ID;
                                                        ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).name = name;
                                                        ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).isTwoHanded = twoHanded = this.itemManager.getItemStats(ID.intValue(), false).getEquipment().isTwoHanded();
                                                        weaponType = new String();
                                                        weaponType = name.contains("bow") || name.contains("knif") || name.contains("dart") || name.contains("throw") || name.contains("xil-ul") || name.contains("chompa") || name.contains("blowpipe") || name.contains("ballista") ? "Ranged" : (name.contains("rident") ? "Trident" : "Melee");
                                                        ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).weaponType = weaponType;
                                                        if (((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).weaponType.equals("Melee")) {
                                                            ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus = this.itemManager.getItemStats(ID.intValue(), false).getEquipment().getStr();
                                                        } else if (((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).weaponType.equals("Ranged")) {
                                                            ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus = this.itemManager.getItemStats(ID.intValue(), false).getEquipment().getRstr();
                                                        }
                                                        style = 3;
                                                        pray = 1.0;
                                                        double setBonus = 1.0;
                                                        equipment = 0;
                                                        level = 0;
                                                        defense = this.client.getRealSkillLevel(Skill.DEFENCE);
                                                        prayerLevel = this.client.getRealSkillLevel(Skill.PRAYER);
                                                        if (!weaponType.equals("Melee")) break block21;
                                                        level = this.strengthLevel();
                                                        equipment = this.strengthBonus();
                                                        equipment = twoHanded && this.equippedShieldID() != -1 && this.equippedWeaponID() != -1 && this.combatType().equals("Melee") ? equipment - this.itemManager.getItemStats(this.equippedWeaponID(), false).getEquipment().getStr() - this.itemManager.getItemStats(this.equippedShieldID(), false).getEquipment().getStr() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus : (((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).isTwoHanded && this.equippedWeaponID() != -1 && this.combatType().equals("Melee") ? equipment - this.itemManager.getItemStats(this.equippedWeaponID(), false).getEquipment().getStr() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus : (((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).isTwoHanded && this.equippedShieldID() != -1 ? equipment - this.itemManager.getItemStats(this.equippedShieldID(), false).getEquipment().getStr() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus : (!((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).isTwoHanded && this.equippedWeaponID() != -1 && this.combatType().equals("Melee") ? equipment - this.itemManager.getItemStats(this.equippedWeaponID(), false).getEquipment().getStr() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus : (equipment += ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus))));
                                                        if (prayerLevel <= 1 || prayerLevel >= 13) break block22;
                                                        pray = 1.05;
                                                        break block23;
                                                    }
                                                    if (prayerLevel < 13 || prayerLevel >= 31) break block24;
                                                    pray = 1.1;
                                                    break block23;
                                                }
                                                if (prayerLevel < 31 || prayerLevel >= 60) break block25;
                                                pray = 1.15;
                                                break block23;
                                            }
                                            if (prayerLevel < 60 || prayerLevel >= 70 || defense < 65) break block26;
                                            pray = 1.18;
                                            break block23;
                                        }
                                        if (prayerLevel < 70 || defense < 70) break block23;
                                        pray = 1.23;
                                        break block23;
                                    }
                                    if (!weaponType.equals("Ranged")) break block27;
                                    level = this.rangedLevel();
                                    if (this.equippedWeaponID() != -1) {
                                        if (this.itemManager.getItemComposition(this.equippedWeaponID()).isStackable()) {
                                            equipment = this.rangedStrengthBonus() - this.itemManager.getItemStats(this.equippedWeaponID(), false).getEquipment().getRstr() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus;
                                            if (!(this.ammoID() == -1 || this.itemManager.getItemComposition(ID.intValue()).isStackable() || this.itemManager.getItemComposition(ID.intValue()).getName().contains("rystal bow") || this.itemManager.getItemComposition(ID.intValue()).getName().contains("pipe"))) {
                                                equipment += this.itemManager.getItemStats(this.ammoID(), false).getEquipment().getRstr();
                                            }
                                        } else if (!(this.itemManager.getItemComposition(this.equippedWeaponID()).isStackable() || this.ammoID() == -1 || this.itemManager.getItemComposition(this.equippedWeaponID()).getName().contains("rystal bow") || this.itemManager.getItemComposition(this.equippedWeaponID()).getName().contains("pipe"))) {
                                            equipment = this.rangedStrengthBonus() - this.itemManager.getItemStats(this.equippedWeaponID(), false).getEquipment().getRstr() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus;
                                            if (this.itemManager.getItemComposition(ID.intValue()).isStackable() || name.contains("rystal bow") || name.contains("pipe")) {
                                                equipment -= this.itemManager.getItemStats(this.ammoID(), false).getEquipment().getRstr();
                                            }
                                        } else if (this.itemManager.getItemComposition(this.equippedWeaponID()).getName().contains("rystal bow") || this.itemManager.getItemComposition(this.equippedWeaponID()).getName().contains("pipe")) {
                                            equipment = this.rangedStrengthBonus() - this.itemManager.getItemStats(this.equippedWeaponID(), false).getEquipment().getRstr() + this.itemManager.getItemStats(ID.intValue(), false).getEquipment().getRstr();
                                            if (!this.itemManager.getItemComposition(ID.intValue()).isStackable() && this.ammoID() != -1) {
                                                equipment += this.itemManager.getItemStats(this.ammoID(), false).getEquipment().getRstr();
                                            }
                                        }
                                    } else {
                                        equipment = this.rangedStrengthBonus() + ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).strBonus;
                                        if (this.itemManager.getItemComposition(ID.intValue()).isStackable() || name.contains("rystal") || name.contains("pipe") & this.ammoID() != -1) {
                                            equipment -= this.itemManager.getItemStats(this.ammoID(), false).getEquipment().getRstr();
                                        }
                                    }
                                    if (prayerLevel <= 1 || prayerLevel >= 8) break block28;
                                    pray = 1.05;
                                    break block23;
                                }
                                if (prayerLevel < 8 || prayerLevel >= 26) break block29;
                                pray = 1.1;
                                break block23;
                            }
                            if (prayerLevel < 26 || prayerLevel >= 74) break block30;
                            pray = 1.15;
                            break block23;
                        }
                        if (prayerLevel < 74 || defense < 70) break block23;
                        pray = 1.23;
                        break block23;
                    }
                    if (weaponType.equals("Trident")) {
                        double maxTrident;
                        double magicLevel = this.magicLevel();
                        if (name.contains("swamp")) {
                            maxTrident = Math.floor(magicLevel / 3.0) - 2.0;
                            ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).maxHitBase = Math.floor(maxTrident * this.magicBonus());
                            continue;
                        }
                        if (name.contains("seas")) {
                            maxTrident = Math.floor(magicLevel / 3.0) - 5.0;
                            ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).maxHitBase = Math.floor(maxTrident * this.magicBonus());
                            continue;
                        }
                    }
                }
                double effectiveStrengthLevel = Math.floor(Math.floor((double)level * pray) + (double)style + 8.0);
                if (this.itemSet(ID).contains("oid")) {
                    effectiveStrengthLevel = Math.floor(effectiveStrengthLevel * this.setBonus(weaponType, this.itemSet(ID)));
                }
                double baseMax = Math.floor(effectiveStrengthLevel * (double)(equipment + 64) / 640.0 + 0.5);
                if (!this.itemSet(ID).contains("oid") && !this.itemSet(ID).equals("No item set")) {
                    ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).maxHitBase = baseMax * this.setBonus(weaponType, this.itemSet(ID));
                    continue;
                }
                ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).maxHitBase = baseMax;
                ((InventoryWeapons)((Object)inventoryWeaponsHashMap.get((Object)name))).maxHitSpec = this.maxHitSpec(name, baseMax);
            }
        }
        return inventoryWeaponsHashMap;
    }

    public String itemSet(int weaponID) {
        Item[] items;
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment != null && (items = equipment.getItems()) != null && items.length >= 9) {
            int bodyID = items[EquipmentInventorySlot.BODY.getSlotIdx()].getId();
            int legsID = items[EquipmentInventorySlot.LEGS.getSlotIdx()].getId();
            int helmID = items[EquipmentInventorySlot.HEAD.getSlotIdx()].getId();
            int amuletID = items[EquipmentInventorySlot.AMULET.getSlotIdx()].getId();
            int glovesID = items[EquipmentInventorySlot.GLOVES.getSlotIdx()].getId();
            if (this.client.getItemDefinition(weaponID).getName().contains("xil") || this.client.getItemDefinition(weaponID).getName().contains("ket")) {
                if (this.client.getItemDefinition(helmID).getName().contains("Obsidian") && this.client.getItemDefinition(bodyID).getName().contains("Obsidian") && this.client.getItemDefinition(legsID).getName().contains("Obsidian")) {
                    if (this.client.getItemDefinition(amuletID).getName().contains("serker")) {
                        return "Max obsidian";
                    }
                    return "Obsidian armor";
                }
                if (this.client.getItemDefinition(amuletID).getName().contains("serker")) {
                    return "Obsidian weapon and berserker necklace";
                }
            }
            if (this.client.getItemDefinition(glovesID).getName().equalsIgnoreCase("Void knight gloves")) {
                if (this.client.getItemDefinition(bodyID).getName().equalsIgnoreCase("Void knight top") && this.client.getItemDefinition(legsID).getName().equalsIgnoreCase("Void knight robe")) {
                    if (this.client.getItemDefinition(helmID).getName().equalsIgnoreCase("Void ranger helm")) {
                        return "Void range";
                    }
                    if (this.client.getItemDefinition(helmID).getName().equalsIgnoreCase("Void melee helm")) {
                        return "Void melee";
                    }
                }
                if (this.client.getItemDefinition(bodyID).getName().equalsIgnoreCase("Elite void top") && this.client.getItemDefinition(legsID).getName().equalsIgnoreCase("Elite void robe")) {
                    if (this.client.getItemDefinition(helmID).getName().equalsIgnoreCase("Void ranger helm")) {
                        return "Elite void range";
                    }
                    if (this.client.getItemDefinition(helmID).getName().equalsIgnoreCase("Void melee helm")) {
                        return "Void melee";
                    }
                    if (this.client.getItemDefinition(helmID).getName().equalsIgnoreCase("Void mage helm")) {
                        return "Elite void mage";
                    }
                }
            }
            if (this.client.getItemDefinition(helmID).getName().contains("harok") && this.client.getItemDefinition(bodyID).getName().contains("harok") && this.client.getItemDefinition(legsID).getName().contains("harok") && this.client.getItemDefinition(weaponID).getName().contains("harok")) {
                return "Dharok";
            }
        }
        return "No item set";
    }

    public double setBonus(String combatType, String set) {
        if (combatType.equals("Melee")) {
            if (set.equals("Void melee")) {
                return 1.1;
            }
            if (set.equals("Dharok")) {
                double baseHitpoints = this.client.getRealSkillLevel(Skill.HITPOINTS);
                double currentHitpoints = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
                return 1.0 + (baseHitpoints - currentHitpoints) / 100.0 * baseHitpoints / 100.0;
            }
            if (set.equals("Obsidian armor")) {
                return 1.1;
            }
            if (set.equals("Obsidian weapon and berserker necklace")) {
                return 1.2;
            }
            if (set.equals("Max obsidian")) {
                return 1.32;
            }
        }
        if (combatType.equals("Ranged")) {
            if (set.equals("Void range")) {
                return 1.1;
            }
            if (set.equals("Elite void range")) {
                return 1.125;
            }
        }
        return 1.0;
    }

    public String combatType() {
        String attackStyle = this.attackStyle();
        if (attackStyle.equalsIgnoreCase("Aggressive") || attackStyle.equalsIgnoreCase("Accurate") || attackStyle.equalsIgnoreCase("Defensive") || attackStyle.equalsIgnoreCase("Controlled")) {
            return "Melee";
        }
        if (attackStyle.contains("ang")) {
            return "Ranged";
        }
        if (attackStyle.contains("asting")) {
            return "Magic";
        }
        return "Other";
    }

    public double prayerMultiplier() {
        if (this.combatType().equals("Melee")) {
            if (this.client.isPrayerActive(Prayer.BURST_OF_STRENGTH)) {
                return 1.05;
            }
            if (this.client.isPrayerActive(Prayer.SUPERHUMAN_STRENGTH)) {
                return 1.1;
            }
            if (this.client.isPrayerActive(Prayer.ULTIMATE_STRENGTH)) {
                return 1.15;
            }
            if (this.client.isPrayerActive(Prayer.CHIVALRY)) {
                return 1.18;
            }
            if (this.client.isPrayerActive(Prayer.PIETY)) {
                return 1.23;
            }
        }
        if (this.combatType().equals("Ranged")) {
            if (this.client.isPrayerActive(Prayer.SHARP_EYE)) {
                return 1.05;
            }
            if (this.client.isPrayerActive(Prayer.HAWK_EYE)) {
                return 1.1;
            }
            if (this.client.isPrayerActive(Prayer.EAGLE_EYE)) {
                return 1.15;
            }
            if (this.client.isPrayerActive(Prayer.RIGOUR)) {
                return 1.23;
            }
        }
        return 1.0;
    }

    public String weaponName() {
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container != null) {
            Item weapon;
            Item[] items = container.getItems();
            if (items.length >= EquipmentInventorySlot.WEAPON.getSlotIdx() && (weapon = items[EquipmentInventorySlot.WEAPON.getSlotIdx()]).getId() > 512) {
                int weaponID = weapon.getId();
                return this.client.getItemDefinition(weaponID).getName();
            }
            return "no weapon";
        }
        return "No weapon or items";
    }

    public int equippedWeaponID() {
        Item weapon;
        Item[] items;
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container != null && (items = container.getItems()).length >= EquipmentInventorySlot.WEAPON.getSlotIdx() && (weapon = items[EquipmentInventorySlot.WEAPON.getSlotIdx()]).getId() > 512) {
            return weapon.getId();
        }
        return -1;
    }

    private String attackStyle() {
        this.attackStyleVarbit = this.client.getVar(43);
        this.equippedWeaponTypeVarbit = this.client.getVar(357);
        this.castingModeVarbit = this.client.getVar(2668);
        AttackStyle[] attackStyles = WeaponType.getWeaponType(this.equippedWeaponTypeVarbit).getAttackStyles();
        if (this.attackStyleVarbit < attackStyles.length) {
            this.attackStyle = attackStyles[this.attackStyleVarbit];
            if (this.attackStyle == null) {
                this.attackStyle = AttackStyle.OTHER;
            } else if (this.attackStyle == AttackStyle.CASTING && this.castingModeVarbit == 1) {
                this.attackStyle = AttackStyle.DEFENSIVE_CASTING;
            }
        }
        return this.attackStyle.getName();
    }

    public int styleBonus() {
        this.attackStyleVarbit = this.client.getVar(43);
        this.equippedWeaponTypeVarbit = this.client.getVar(357);
        this.castingModeVarbit = this.client.getVar(2668);
        WeaponType equippedWeaponType = WeaponType.getWeaponType(this.equippedWeaponTypeVarbit);
        String attackStyle = this.attackStyle();
        if (attackStyle.equalsIgnoreCase("Aggressive")) {
            return 3;
        }
        if (attackStyle.equalsIgnoreCase("Controlled")) {
            return 1;
        }
        if (this.isRangingAccurate()) {
            return 3;
        }
        if (attackStyle.equalsIgnoreCase("Longrange")) {
            return 1;
        }
        return 0;
    }

    public int magicLevel() {
        return this.client.getBoostedSkillLevel(Skill.MAGIC);
    }

    public int spellDamage() {
        MagicSpell spell = this.config.spellChoice();
        if (spell.element == Element.GOD && this.config.applyCharge()) {
            return 30;
        }
        return spell.damage;
    }

    public String shieldName() {
        Item shield;
        Item[] items;
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container != null && (items = container.getItems()).length >= EquipmentInventorySlot.SHIELD.getSlotIdx() && (shield = items[EquipmentInventorySlot.SHIELD.getSlotIdx()]).getId() > 512) {
            int shieldID = shield.getId();
            return this.client.getItemDefinition(shieldID).getName();
        }
        return "no shield";
    }

    public int equippedShieldID() {
        Item shield;
        Item[] items;
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container != null && (items = container.getItems()).length >= 6 && (shield = items[EquipmentInventorySlot.SHIELD.getSlotIdx()]).getId() > 512) {
            return shield.getId();
        }
        return -1;
    }

    public double magicBonus() {
        int[] ids;
        double magicEquipmentBonus = 0.0;
        for (int x : ids = this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds()) {
            if (x <= 512) continue;
            int id = x - 512;
            ItemStats stats = this.itemManager.getItemStats(id, false);
            ItemEquipmentStats currentEquipment = stats.getEquipment();
            magicEquipmentBonus += (double)currentEquipment.getMdmg();
        }
        if (this.itemSet(this.equippedWeaponID()).equals("Elite void mage")) {
            magicEquipmentBonus += 2.5;
        }
        if (this.weaponName().contains("moke battle") && this.config.spellChoice().spellbook == Spellbook.NORMAL) {
            magicEquipmentBonus += 10.0;
        }
        return 1.0 + magicEquipmentBonus / 100.0;
    }

    public int rangedLevel() {
        return this.client.getBoostedSkillLevel(Skill.RANGED);
    }

    public boolean isRangingAccurate() {
        int styleNum = this.client.getVar(43);
        String attackStyle = this.attackStyle();
        return attackStyle.contains("ang") && styleNum == 0;
    }

    public String ammoName() {
        Item ammo;
        int ammoID;
        Item[] items = this.client.getItemContainer(InventoryID.EQUIPMENT).getItems();
        if (items.length == 14 && (ammoID = (ammo = items[EquipmentInventorySlot.AMMO.getSlotIdx()]).getId()) != -1) {
            return this.client.getItemDefinition(ammoID).getName();
        }
        return "None";
    }

    public int ammoID() {
        Item[] items = this.client.getItemContainer(InventoryID.EQUIPMENT).getItems();
        if (items.length == 14) {
            Item ammo = items[EquipmentInventorySlot.AMMO.getSlotIdx()];
            return ammo.getId();
        }
        return -1;
    }

    public int rangedStrengthBonus() {
        Item ammo;
        int ammoID;
        ItemComposition weaponComp;
        Item weapon;
        Item[] items;
        int[] ids;
        int rangedStrBonus = 0;
        for (int x : ids = this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds()) {
            if (x <= 512) continue;
            int id = x - 512;
            ItemStats stats = this.itemManager.getItemStats(id, false);
            ItemEquipmentStats currentEquipment = stats.getEquipment();
            rangedStrBonus += currentEquipment.getRstr();
        }
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (!(container == null || (items = container.getItems()).length < EquipmentInventorySlot.WEAPON.getSlotIdx() || (weapon = items[EquipmentInventorySlot.WEAPON.getSlotIdx()]) == null || (weaponComp = this.itemManager.getItemComposition(weapon.getId())).isStackable() || this.client.getItemDefinition(weapon.getId()).getName().contains("pipe") || this.client.getItemDefinition(weapon.getId()).getName().contains("ystal") || items.length != 14 || (ammoID = (ammo = items[EquipmentInventorySlot.AMMO.getSlotIdx()]).getId()) == -1)) {
            ItemStats ammoStats = this.itemManager.getItemStats(ammoID, false);
            ItemEquipmentStats ammoEquipment = ammoStats.getEquipment();
            rangedStrBonus += ammoEquipment.getRstr();
        }
        return rangedStrBonus;
    }

    public int strengthLevel() {
        return this.client.getBoostedSkillLevel(Skill.STRENGTH);
    }

    public int ringBonus() {
        Item ring;
        Item[] items;
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container != null && (items = container.getItems()).length >= EquipmentInventorySlot.RING.getSlotIdx() && (ring = items[EquipmentInventorySlot.RING.getSlotIdx()]).getId() > 512) {
            int ringID = ring.getId();
            ItemStats ringStats = this.itemManager.getItemStats(ringID, false);
            ItemEquipmentStats ringEquipment = ringStats.getEquipment();
            return ringEquipment.getStr();
        }
        return 0;
    }

    public int strengthBonus() {
        int[] ids;
        int strBonus = 0;
        strBonus += this.ringBonus();
        for (int x : ids = this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds()) {
            if (x <= 512) continue;
            int id = x - 512;
            ItemStats stats = this.itemManager.getItemStats(id, false);
            ItemEquipmentStats currentEquipment = stats.getEquipment();
            strBonus += currentEquipment.getStr();
        }
        return strBonus;
    }

    public double maxHitBase() {
        int style = this.styleBonus();
        double pray = this.prayerMultiplier();
        double setBonus = this.setBonus(this.combatType(), this.itemSet(this.equippedWeaponID()));
        int equipment = 0;
        int level = 0;
        if (this.combatType().equals("Melee")) {
            level = this.strengthLevel();
            equipment = this.strengthBonus();
        } else if (this.combatType().equals("Ranged")) {
            level = this.rangedLevel();
            equipment = this.rangedStrengthBonus();
        } else if (this.weaponName().contains("rident")) {
            double magicLevel = this.magicLevel();
            if (this.weaponName().contains("swamp")) {
                double maxTrident = Math.floor(magicLevel / 3.0) - 2.0;
                return Math.floor(maxTrident * this.magicBonus());
            }
            if (this.weaponName().contains("seas")) {
                double maxTrident = Math.floor(magicLevel / 3.0) - 5.0;
                return Math.floor(maxTrident * this.magicBonus());
            }
        }
        double effectiveStrengthLevel = Math.floor(Math.floor((double)level * pray) + (double)style + 8.0);
        if (this.itemSet(this.equippedWeaponID()).contains("oid")) {
            effectiveStrengthLevel = Math.floor(effectiveStrengthLevel * setBonus);
        }
        double baseMax = Math.floor(effectiveStrengthLevel * (double)(equipment + 64) / 640.0 + 0.5);
        if (!this.itemSet(this.equippedWeaponID()).contains("oid")) {
            return baseMax * setBonus;
        }
        return baseMax;
    }

    public double maxMagicHitBase() {
        if (this.config.showMagic()) {
            int spellDamage = this.spellDamage();
            double magicEquipment = this.magicBonus();
            double base = (double)spellDamage * magicEquipment;
            if (this.config.spellChoice().element == Element.FIRE && this.shieldName().contains("ome of fire")) {
                base = Math.floor(base) * 1.5;
            }
            return base;
        }
        return 0.0;
    }

    public double maxHitSpec(String weaponName, double maxHitBase) {
        if (weaponName.contains("rossbo") && this.ammoName().contains("(e)")) {
            if (this.ammoName().contains("iamond")) {
                return Math.floor(maxHitBase) * 1.15;
            }
            if (this.ammoName().contains("nyx")) {
                return Math.floor(maxHitBase) * 1.2;
            }
            if (this.ammoName().contains("ragonstone")) {
                return Math.floor(maxHitBase) + Math.floor((double)this.rangedLevel() * 0.2);
            }
            if (this.ammoName().contains("pal")) {
                return Math.floor(maxHitBase) + Math.floor((double)this.rangedLevel() * 0.1);
            }
            if (this.ammoName().contains("earl")) {
                return Math.floor(maxHitBase) + Math.floor((double)this.rangedLevel() * 0.05);
            }
        }
        if (weaponName.equalsIgnoreCase("Saradomin sword")) {
            return 16.0 + Math.floor(maxHitBase) * this.specialAttackDamageMultiplier(weaponName);
        }
        if (weaponName.equalsIgnoreCase("Granite hammer")) {
            return Math.floor(maxHitBase) + 5.0;
        }
        if (this.specialAttackDamageMultiplier(weaponName) != 1.0) {
            if (weaponName.contains("dagger") || weaponName.equalsIgnoreCase("Dark bow")) {
                return Math.floor(Math.floor(maxHitBase) * this.specialAttackDamageMultiplier(weaponName)) * 2.0;
            }
            return Math.floor(maxHitBase) * this.specialAttackDamageMultiplier(weaponName);
        }
        return -1.0;
    }

    public double specialAttackDamageMultiplier(String weaponName) {
        if (weaponName.contains("Abyssal dagger")) {
            return 0.85;
        }
        if (weaponName.equalsIgnoreCase("Dragon claws")) {
            return 1.98;
        }
        if (weaponName.contains("Dragon dagger")) {
            return 1.15;
        }
        if (weaponName.equalsIgnoreCase("Dragon halberd")) {
            return 1.1;
        }
        if (weaponName.equalsIgnoreCase("Dragon longsword")) {
            return 1.25;
        }
        if (weaponName.equalsIgnoreCase("Dragon mace")) {
            return 1.5;
        }
        if (weaponName.equalsIgnoreCase("Dragon sword")) {
            return 1.25;
        }
        if (weaponName.equalsIgnoreCase("Dragon warhammer")) {
            return 1.5;
        }
        if (weaponName.equalsIgnoreCase("Armadyl godsword")) {
            return 1.375;
        }
        if (weaponName.equalsIgnoreCase("Bandos godsword")) {
            return 1.21;
        }
        if (weaponName.equalsIgnoreCase("Saradomin godsword")) {
            return 1.1;
        }
        if (weaponName.equalsIgnoreCase("Saradomin sword")) {
            return 1.1;
        }
        if (weaponName.equalsIgnoreCase("Saradomin's blessed sword")) {
            return 1.25;
        }
        if (weaponName.equalsIgnoreCase("Zamorak Godsword")) {
            return 1.1;
        }
        if (weaponName.equalsIgnoreCase("Granite hammer")) {
            return 1.0;
        }
        if (weaponName.equalsIgnoreCase("Barrelchest anchor")) {
            return 1.1;
        }
        if (weaponName.equalsIgnoreCase("Crystal halberd")) {
            return 1.1;
        }
        if (weaponName.contains("ballista")) {
            return 1.25;
        }
        if (weaponName.equalsIgnoreCase("Dragon crossbow")) {
            return 1.2;
        }
        if (weaponName.equalsIgnoreCase("Dark bow")) {
            if (this.ammoName().contains("Dragon arr")) {
                return 1.5;
            }
            return 1.3;
        }
        if (weaponName.equalsIgnoreCase("Toxic blowpipe")) {
            return 1.5;
        }
        return 1.0;
    }

    public NextMaxHit nextMaxHit() {
        NextMaxHit nextMaxHit = new NextMaxHit();
        if (this.combatType().equals("Melee") || this.combatType().equals("Ranged") || this.weaponName().contains("rident")) {
            nextMaxHit = this.nextMaxHitBase();
        } else if (this.combatType().equals("Magic")) {
            nextMaxHit = this.nextMagicMaxHitBase();
        }
        return nextMaxHit;
    }

    private NextMaxHit nextMaxHitBase() {
        double baseMax = this.maxHitBase() + 1.0;
        NextMaxHit reqs = new NextMaxHit();
        int style = this.styleBonus();
        double pray = this.prayerMultiplier();
        double setBonus = this.setBonus(this.combatType(), this.itemSet(this.equippedWeaponID()));
        int equipment = 0;
        int level = 0;
        if (this.combatType().equals("Melee")) {
            level = this.strengthLevel();
            equipment = this.strengthBonus();
        } else if (this.combatType().equals("Ranged")) {
            level = this.rangedLevel();
            equipment = this.rangedStrengthBonus();
        } else if (this.weaponName().contains("rident")) {
            double magicLevel;
            double magicLevelNew = magicLevel = (double)this.magicLevel();
            if (this.weaponName().contains("swamp")) {
                magicLevelNew = (Math.ceil(baseMax / this.magicBonus()) + 2.0) * 3.0;
            }
            if (this.weaponName().contains("seas")) {
                magicLevelNew = (Math.ceil(baseMax / this.magicBonus()) + 5.0) * 3.0;
            }
            double magicDiff = magicLevelNew - magicLevel;
            reqs.magicLevels = (int)magicDiff;
            return reqs;
        }
        double effectiveStrengthLevel = Math.floor(Math.floor((double)level * pray) + (double)style + 8.0);
        if (this.itemSet(this.equippedWeaponID()).contains("oid")) {
            effectiveStrengthLevel = Math.floor(effectiveStrengthLevel * setBonus);
        }
        if (!this.itemSet(this.equippedWeaponID()).contains("oid")) {
            baseMax /= setBonus;
        }
        double equipmentNew = Math.ceil((baseMax - 0.5) * 640.0 / effectiveStrengthLevel - 64.0);
        double equipmentDiff = equipmentNew - (double)equipment;
        double reverseEffectiveStrengthLevel = Math.ceil((baseMax - 0.5) * 640.0 / (double)(equipment + 64) - 8.0 - (double)style);
        if (this.itemSet(this.equippedWeaponID()).contains("oid")) {
            reverseEffectiveStrengthLevel /= setBonus;
        }
        double levelNew = Math.ceil(reverseEffectiveStrengthLevel / pray);
        double levelDiff = levelNew - (double)level;
        double prayerNew = reverseEffectiveStrengthLevel / (double)level;
        double prayerDiff = Math.ceil((prayerNew - pray) * 100.0);
        if (this.combatType().equals("Melee")) {
            reqs.strengthBonus = (int)equipmentDiff;
            reqs.strengthLevels = (int)levelDiff;
        } else if (this.combatType().equals("Ranged")) {
            reqs.rangedBonus = (int)equipmentDiff;
            reqs.rangedLevels = (int)levelDiff;
        }
        reqs.prayerBoost = (int)prayerDiff;
        return reqs;
    }

    private NextMaxHit nextMagicMaxHitBase() {
        NextMaxHit nextMaxHit = new NextMaxHit();
        double base = this.maxMagicHitBase() + 1.0;
        if (this.config.spellChoice().element == Element.FIRE && this.shieldName().contains("ome of fire")) {
            base = Math.ceil(base / 1.5);
        }
        double equipmentNew = base / (double)this.spellDamage();
        double equipmentDiff = Math.ceil((equipmentNew - this.magicBonus()) * 100.0);
        nextMaxHit.magicBonus = (int)equipmentDiff;
        return nextMaxHit;
    }
}

