/*
 * Decompiled with CFR 0.152.
 */
package com.maxhit;

import com.maxhit.InventoryWeapons;
import com.maxhit.MaxHitConfig;
import com.maxhit.MaxHitPlugin;
import com.maxhit.NextMaxHit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class MaxHitOverlay
extends Overlay {
    private static final Color COMBAT_LEVEL_COLOUR = new Color(16750623);
    private MaxHitPlugin plugin;
    private MaxHitConfig config;
    private Client client;
    private TooltipManager tooltipManager;
    private PanelComponent panelComponent = new PanelComponent();

    @Inject
    public MaxHitOverlay(MaxHitPlugin plugin, MaxHitConfig config, Client client, TooltipManager tooltipManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Max hit overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        HashMap map;
        this.panelComponent.getChildren().clear();
        if (this.config.maxHit()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max Hit:").right(Double.toString(Math.floor(this.plugin.maxHitBase()))).build());
        }
        if (this.config.showSpec() && this.plugin.maxHitSpec(this.plugin.weaponName(), this.plugin.maxHitBase()) != -1.0) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max Special:").right(Double.toString(Math.floor(this.plugin.maxHitSpec(this.plugin.weaponName(), this.plugin.maxHitBase())))).build());
        }
        if (this.config.showMagic()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Magic Max Hit:").right(Double.toString(Math.floor(this.plugin.maxMagicHitBase()))).build());
        }
        if (this.config.showNextMaxHit() && this.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.tooltipManager.add(new Tooltip(this.getNextMaxHitTooltip()));
        }
        if ((map = this.plugin.equippableItems()).size() != 0) {
            for (Object weapon : map.keySet()) {
                String wep = weapon.toString();
                if (this.config.inventoryWeapons()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left(((InventoryWeapons)((Object)map.get((Object)wep))).name).right(Double.toString(Math.floor(((InventoryWeapons)((Object)map.get((Object)wep))).maxHitBase))).build());
                }
                if (((InventoryWeapons)((Object)map.get((Object)wep))).maxHitSpec > 0.0 && this.config.invetoryWeaponsSpecial()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left(((InventoryWeapons)((Object)map.get((Object)wep))).name + " Spec").right(Double.toString(Math.floor(((InventoryWeapons)((Object)map.get((Object)wep))).maxHitSpec))).build());
                }
                if (!this.config.inventorySelectiveSpecial() || this.config.inventoryWeapons() || this.config.invetoryWeaponsSpecial()) continue;
                if (((InventoryWeapons)((Object)map.get((Object)wep))).maxHitSpec <= 0.0) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left(((InventoryWeapons)((Object)map.get((Object)wep))).name).right(Double.toString(Math.floor(((InventoryWeapons)((Object)map.get((Object)wep))).maxHitBase))).build());
                    continue;
                }
                this.panelComponent.getChildren().add(LineComponent.builder().left(((InventoryWeapons)((Object)map.get((Object)wep))).name + " Spec").right(Double.toString(Math.floor(((InventoryWeapons)((Object)map.get((Object)wep))).maxHitSpec))).build());
            }
        }
        return this.panelComponent.render(graphics);
    }

    private String getNextMaxHitTooltip() {
        NextMaxHit nextMaxHit = this.plugin.nextMaxHit();
        StringBuilder sb = new StringBuilder();
        sb.append(ColorUtil.wrapWithColorTag((String)"Next max hit:", (Color)COMBAT_LEVEL_COLOUR));
        if (nextMaxHit.strengthLevels > 0) {
            sb.append("</br>").append(nextMaxHit.strengthLevels).append(" Strength levels");
        } else if (nextMaxHit.rangedLevels > 0) {
            sb.append("</br>").append(nextMaxHit.rangedLevels).append(" Ranged levels");
        } else if (nextMaxHit.magicLevels > 0) {
            sb.append("</br>").append(nextMaxHit.magicLevels).append(" Magic levels");
        }
        if (nextMaxHit.strengthBonus > 0) {
            sb.append("</br>").append(nextMaxHit.strengthBonus).append(" Strength bonus");
        } else if (nextMaxHit.rangedBonus > 0) {
            sb.append("</br>").append(nextMaxHit.rangedBonus).append(" Ranged bonus");
        } else if (nextMaxHit.magicBonus > 0) {
            sb.append("</br>").append(nextMaxHit.magicBonus).append(" % Magic damage");
        }
        if (nextMaxHit.prayerBoost > 0) {
            sb.append("</br>").append(nextMaxHit.prayerBoost).append(" % Prayer boost");
        }
        return sb.toString();
    }
}

