/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor.ntfyer;

import com.google.inject.Provides;
import com.skeldoor.ntfyer.ntfyerConfig;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NotificationFired;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ntfyer")
public class ntfyerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ntfyerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ntfyerConfig config;
    @Inject
    private EventBus eventBus;
    @Inject
    private OkHttpClient okHttpClient;

    protected void startUp() throws Exception {
        log.info("ntfyer started!");
    }

    protected void shutDown() throws Exception {
        log.info("ntfyer stopped!");
    }

    @Subscribe
    public void onNotificationFired(NotificationFired notificationFired) {
        if (Objects.equals(this.config.ntfyTopic(), "") || this.config.ntfyTopic() == null || Objects.equals(this.config.ntfyUrl(), "") || this.config.ntfyUrl() == null) {
            return;
        }
        try {
            Object ntfyUrl = this.config.ntfyUrl();
            if (!((String)ntfyUrl).endsWith("/")) {
                ntfyUrl = (String)ntfyUrl + "/";
            }
            ntfyUrl = (String)ntfyUrl + this.config.ntfyTopic();
            MediaType mediaType = MediaType.parse((String)"text/plain; charset=utf-8");
            Request r = new Request.Builder().addHeader("Title", "RuneLite ntfyer").url((String)ntfyUrl).post(RequestBody.create((MediaType)mediaType, (String)notificationFired.getMessage())).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error sending post data", (Throwable)e);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        log.debug("Successfully sent ntfy notification");
                        response.close();
                    } else {
                        log.debug("Post request unsuccessful");
                        response.close();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Provides
    ntfyerConfig provideConfig(ConfigManager configManager) {
        return (ntfyerConfig)configManager.getConfig(ntfyerConfig.class);
    }
}

