/*
 * Decompiled with CFR 0.152.
 */
package com.speshkitty.playerpronouns;

import com.google.inject.Provides;
import com.speshkitty.playerpronouns.DatabaseAPI;
import com.speshkitty.playerpronouns.PlayerPronounsConfig;
import com.speshkitty.playerpronouns.PlayerPronounsOverlay;
import com.speshkitty.playerpronouns.Pronoun;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Player Pronouns")
public class PlayerPronounsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PlayerPronounsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PlayerPronounsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PlayerPronounsConfig config;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private DatabaseAPI databaseAPI;
    @Inject
    private ClientThread thread;
    private String playerNameHashed = "";
    final int maxPronounLength = 25;
    private boolean logging_in = false;
    boolean shouldUpdateConfig = true;

    protected String getPlayerNameHashed() {
        if (this.playerNameHashed.isEmpty()) {
            if (this.client.getLocalPlayer() == null) {
                return "";
            }
            if (this.client.getLocalPlayer().getName() == null) {
                return "";
            }
            this.playerNameHashed = this.databaseAPI.hashString(Text.removeTags((String)this.client.getLocalPlayer().getName()));
        }
        return this.playerNameHashed;
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.getPlayerNameHashed();
        }
        log.info("Player Pronouns started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.databaseAPI.destroy();
        log.info("Player Pronouns stopped!");
    }

    @Provides
    PlayerPronounsConfig provideConfig(ConfigManager configManager) {
        return (PlayerPronounsConfig)configManager.getConfig(PlayerPronounsConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.logging_in = true;
        }
        if (this.logging_in && gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.logging_in = false;
            this.thread.invokeLater(() -> {
                if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
                    return false;
                }
                this.playerNameHashed = this.databaseAPI.hashString(this.client.getLocalPlayer().getName());
                if (this.playerNameHashed.isEmpty()) {
                    return false;
                }
                if (!this.config.pronoun().isEmpty()) {
                    this.databaseAPI.putPlayersPronoun(this.config.presetPronoun(), true);
                }
                return true;
            });
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!this.shouldUpdateConfig) {
            this.shouldUpdateConfig = true;
            return;
        }
        if (!configChanged.getGroup().equals("playerpronouns")) {
            return;
        }
        if ("presetPronoun".equals(configChanged.getKey())) {
            Pronoun oldPronoun = Pronoun.valueOf(configChanged.getOldValue());
            this.databaseAPI.putPlayersPronoun(oldPronoun, false);
        }
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void lookupData() {
        this.databaseAPI.cleanUpData();
        this.databaseAPI.getData();
    }
}

