/*
 * Decompiled with CFR 0.152.
 */
package com.speshkitty.playerpronouns;

import com.speshkitty.playerpronouns.DatabaseAPI;
import com.speshkitty.playerpronouns.PlayerPronounsConfig;
import com.speshkitty.playerpronouns.PlayerPronounsPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerPronounsOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(PlayerPronounsOverlay.class);
    private final PlayerPronounsPlugin playerPronounsPlugin;
    private final PlayerPronounsConfig config;
    private final Client client;
    private final TooltipManager tooltipManager;
    @Inject
    private DatabaseAPI databaseAPI;

    @Inject
    PlayerPronounsOverlay(PlayerPronounsPlugin playerPronounsPlugin, PlayerPronounsConfig config, Client client, TooltipManager tooltipManager) {
        this.playerPronounsPlugin = playerPronounsPlugin;
        this.config = config;
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.TOOLTIP);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        MenuEntry[] list;
        if (this.client.isMenuOpen()) {
            return null;
        }
        ArrayList<Player> checkedPlayers = new ArrayList<Player>();
        for (MenuEntry entry : list = this.client.getMenuEntries()) {
            switch (entry.getOption()) {
                case "Add friend": 
                case "Message": 
                case "Remove friend": {
                    String target = Text.removeTags((String)entry.getTarget()).replace('\u00a0', ' ').trim();
                    String heldText = this.databaseAPI.findUserPronouns(target);
                    if (heldText != null && !heldText.isEmpty()) {
                        this.tooltipManager.add(new Tooltip(heldText));
                    }
                    return null;
                }
            }
        }
        for (MenuEntry entry : list) {
            Player foundPlayer = entry.getPlayer();
            if (foundPlayer == null || checkedPlayers.contains(foundPlayer)) continue;
            checkedPlayers.add(foundPlayer);
        }
        int numPlayersInList = checkedPlayers.size();
        for (Player p : checkedPlayers) {
            String heldText = this.databaseAPI.findUserPronouns(p.getName());
            if (heldText == null || heldText.isEmpty()) continue;
            if (numPlayersInList == 1) {
                this.tooltipManager.add(new Tooltip(heldText));
                continue;
            }
            this.tooltipManager.add(new Tooltip(p.getName() + ": " + heldText));
        }
        return null;
    }
}

